/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.validate;

import com.irdstudio.sdk.beans.core.annotation.NumType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumTypeValidatorImpl
implements ConstraintValidator<NumType, String> {
    private static Logger logger = LoggerFactory.getLogger(NumTypeValidatorImpl.class);

    public void initialize(NumType constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        try {
            if (value == null || value.equals("")) {
                return true;
            }
            Pattern pattern = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$");
            Matcher match = pattern.matcher(value);
            if (match.matches()) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return false;
    }
}

