/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.irdstudio.sdk.beans.core.util.ReflectUtility;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class BaseInfo<T>
implements Serializable {
    private static final long serialVersionUID = 19431238035861340L;
    public static final Integer DEFAULT_MAX_PAGE_SIZE = 1000;
    public static final Integer DEFAULT_MIN_PAGE_SIZE = 10;
    public static final Integer DEFAULT_MIN_PAGE_NO = 1;
    private Integer page = 0;
    private Integer size = 0;
    private Integer total = 0;
    private Integer rows = 0;
    @JsonIgnore
    private StringBuffer order;
    private String loginUserId;
    private String loginUserName;
    private String loginUserOrgCode;
    private String loginUserLeageOrgCode;
    private String loginUserOrgLocation;
    private String prdCodebyBaseInfo;
    private String dutyCodeStr;
    private String all;
    private T oldData;
    private String dlText;

    public String getLoginUserOrgLocation() {
        return this.loginUserOrgLocation;
    }

    public void setLoginUserOrgLocation(String loginUserOrgLocation) {
        this.loginUserOrgLocation = loginUserOrgLocation;
    }

    public void setSize(Integer pageSize) {
        this.rows = this.size = pageSize > DEFAULT_MAX_PAGE_SIZE ? DEFAULT_MAX_PAGE_SIZE : pageSize;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public String getLoginUserId() {
        return this.loginUserId;
    }

    public void setLoginUserId(String loginUserId) {
        this.loginUserId = loginUserId;
    }

    public String getLoginUserOrgCode() {
        return this.loginUserOrgCode;
    }

    public void setLoginUserOrgCode(String loginUserOrgCode) {
        this.loginUserOrgCode = loginUserOrgCode;
    }

    public String getLoginUserLeageOrgCode() {
        return this.loginUserLeageOrgCode;
    }

    public void setLoginUserLeageOrgCode(String loginUserLeageOrgCode) {
        this.loginUserLeageOrgCode = loginUserLeageOrgCode;
    }

    public void checkAndSetPageInfo() {
        this.size = this.size <= 0 ? DEFAULT_MIN_PAGE_SIZE : this.size;
        this.page = this.page < 1 ? DEFAULT_MIN_PAGE_NO : this.page;
        this.rows = this.size;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getSize() {
        return this.size;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public Integer getRows() {
        return this.rows;
    }

    public void setRows(Integer rows) {
        this.size = this.rows = rows > DEFAULT_MAX_PAGE_SIZE ? DEFAULT_MAX_PAGE_SIZE : rows;
    }

    public String getOrder() {
        return this.order == null ? "" : this.order.toString();
    }

    private void setOrder(String orderType, String[] fields) {
        if (fields != null && fields.length > 0) {
            if (this.order == null) {
                this.order = new StringBuffer();
            }
            Integer i = 0;
            while (i < fields.length) {
                String field = fields[i];
                if (!StringUtils.isBlank((CharSequence)field)) {
                    if (this.order.length() > 0) {
                        this.order.append(", ");
                    }
                    field = this.javaPropToColName(field);
                    this.order.append(field);
                    if (i == fields.length - 1) {
                        this.order.append(" ").append(orderType).append(" ");
                    } else {
                        this.order.append(",");
                    }
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
    }

    public void setOrder(String order) {
        this.order = new StringBuffer(order);
    }

    public void setAscOrder(String ... fields) {
        this.setOrder("ASC", fields);
    }

    public void setDescOrder(String ... fields) {
        this.setOrder("DESC", fields);
    }

    public String getPrdCodebyBaseInfo() {
        return this.prdCodebyBaseInfo;
    }

    public void setPrdCodebyBaseInfo(String prdCodebyBaseInfo) {
        this.prdCodebyBaseInfo = prdCodebyBaseInfo;
    }

    public String getDutyCodeStr() {
        return this.dutyCodeStr;
    }

    public void setDutyCodeStr(String dutyCodeStr) {
        this.dutyCodeStr = dutyCodeStr;
    }

    public String getAll() {
        return this.all;
    }

    public void setAll(String all) {
        this.all = all;
    }

    public String getDlText() {
        return this.dlText;
    }

    public void setDlText(String dlText) {
        this.dlText = dlText;
    }

    public T getOldData() {
        return this.oldData;
    }

    public void setOldData(T oldData) {
        this.oldData = oldData;
    }

    public String diffPrefix() {
        return "";
    }

    public String getLoginUserName() {
        return this.loginUserName;
    }

    public void setLoginUserName(String loginUserName) {
        this.loginUserName = loginUserName;
    }

    public List<DiffProp> diff() {
        if (this.oldData == null) {
            return Collections.emptyList();
        }
        Class<?> clazz = this.getClass();
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<DiffProp> diff = new ArrayList<DiffProp>(fields.length);
        for (Field field : fields) {
            Number newD;
            Number oldD;
            Describe describe = field.getAnnotation(Describe.class);
            if (describe == null) continue;
            Object oldVal = ReflectUtility.getObjectFieldValue(this.oldData, field);
            Object newVal = ReflectUtility.getObjectFieldValue(this, field);
            Class<?> valClazz = field.getType();
            boolean equals = true;
            if (valClazz == BigDecimal.class) {
                oldD = (BigDecimal)oldVal;
                newD = (BigDecimal)newVal;
                equals = ((BigDecimal)oldD).compareTo((BigDecimal)newD) == 0;
            } else if (valClazz == String.class) {
                equals = StringUtils.equals((CharSequence)this.valueOf(oldVal), (CharSequence)this.valueOf(newVal));
                if (describe.type() != null && describe.type() != Object.class) {
                    oldVal = this.transformCode(describe.type(), this.valueOf(oldVal));
                    newVal = this.transformCode(describe.type(), this.valueOf(newVal));
                }
            } else if (valClazz == Integer.class) {
                oldD = (Integer)oldVal;
                newD = (Integer)newVal;
                boolean bl = equals = ((Integer)oldD).compareTo((Integer)newD) == 0;
            }
            if (equals) continue;
            DiffProp diffProp = new DiffProp(field.getName(), describe.value(), this.valueOf(oldVal), this.valueOf(newVal));
            diff.add(diffProp);
        }
        return diff;
    }

    private String valueOf(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public String transformCode(Class<?> clazz, String code) {
        try {
            Method nameByCode = clazz.getMethod("nameByCode", String.class);
            return (String)nameByCode.invoke(null, code);
        }
        catch (Exception e) {
            return code;
        }
    }

    private String javaPropToColName(String prop) {
        String regx = "[A-Z]";
        Pattern pattern = Pattern.compile(regx);
        Matcher m = pattern.matcher(prop);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "_" + m.group().toLowerCase());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static class DiffProp {
        private String propCode;
        private String propName;
        private String oldVal;
        private String newVal;

        public DiffProp() {
        }

        public DiffProp(String code, String name, String oldVal, String newVal) {
            this.propCode = code;
            this.propName = name;
            this.oldVal = oldVal;
            this.newVal = newVal;
        }

        public String getPropCode() {
            return this.propCode;
        }

        public void setPropCode(String propCode) {
            this.propCode = propCode;
        }

        public String getPropName() {
            return this.propName;
        }

        public void setPropName(String propName) {
            this.propName = propName;
        }

        public String getOldVal() {
            return this.oldVal;
        }

        public void setOldVal(String oldVal) {
            this.oldVal = oldVal;
        }

        public String getNewVal() {
            return this.newVal;
        }

        public void setNewVal(String newVal) {
            this.newVal = newVal;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Describe {
        public String value() default "";

        public Class<?> type() default Object.class;
    }
}

