/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.cache;

import com.irdstudio.sdk.beans.core.cache.Cache;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import java.util.Map;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public final class CacheManager {
    private static Cache cache;

    private static final void assertCache() throws Exception {
        if (Objects.isNull(cache)) {
            throw new IllegalAccessException("Cache not initialize!");
        }
    }

    public static final void initCache() throws Exception {
        if (Objects.isNull(cache)) {
            cache = (Cache)SpringContextUtils.getBean("cache");
        }
    }

    public static final <T> T getCacheMap(String cacheKey) throws Exception {
        CacheManager.assertCache();
        if (StringUtil.isNotEmpty(cacheKey)) {
            return cache.get(cacheKey);
        }
        return null;
    }

    public static final <T> T getCacheObject(String cacheKey, String objectkey) throws Exception {
        Map cacheObjectMap = (Map)CacheManager.getCacheMap(cacheKey);
        if (Objects.nonNull(cacheObjectMap) && !cacheObjectMap.isEmpty() && StringUtil.isNotEmpty(objectkey)) {
            return (T)cacheObjectMap.get(objectkey);
        }
        return null;
    }

    public static final void addCache(String cacheKey, Object value) throws Exception {
        CacheManager.assertCache();
        cache.add(cacheKey, value);
    }

    static {
        try {
            CacheManager.initCache();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(CacheManager.class).error("\u7cfb\u7edf\u9ed8\u8ba4\u7f13\u5b58\u521d\u59cb\u5316\u5931\u8d25!", (Throwable)e);
        }
    }
}

