/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.constant;

public enum CommonReturnCode {
    SUCCESS("S0A00000", "\u6210\u529f", true),
    ERR_REST_INPUT_VALIDATION_REJECTED("M0001", "\u8f93\u5165\u53c2\u6570\u6709\u8bef"),
    ERR_ILLEGAL_HTTP_REQUEST("M0002", "\u975e\u6cd5\u7684HTTP\u8bf7\u6c42"),
    ERR_ILLEGAL_OPEN_ID("M0003", "\u65e0\u6548\u7684openId"),
    ERR_ILLEGAL_MOBILE_IN("M0004", "\u624b\u673a\u53f7\u7801\u91cd\u590d"),
    ERR_CFG_SERVICE_EXCEPTION("B0001", "\u57fa\u7840\u914d\u7f6e\u670d\u52a1\u51fa\u73b0\u5f02\u5e38"),
    ERR_PRD_SERVICE_EXCEPTION("B1001", "\u4ea7\u54c1\u670d\u52a1\u51fa\u73b0\u5f02\u5e38"),
    ERR_CUS_SERVICE_EXCEPTION("B2001", "\u5ba2\u6237\u670d\u52a1\u51fa\u73b0\u5f02\u5e38"),
    ERR_LIMIT_SERVICE_EXCEPTION("B3001", "\u989d\u5ea6\u670d\u52a1\u51fa\u73b0\u5f02\u5e38"),
    ERR_CTR_SERVICE_EXCEPTION("B4001", "\u5408\u540c\u670d\u52a1\u51fa\u73b0\u5f02\u5e38"),
    ERR_LOAN_SERVICE_EXCEPTION("B5001", "\u501f\u636e\u670d\u52a1\u51fa\u73b0\u5f02\u5e38"),
    ERR_RISK_SERVICE_EXCEPTION("B6001", "\u98ce\u63a7\u670d\u52a1\u51fa\u73b0\u5f02\u5e38"),
    ERR_SERVICE_NETWORK_EXCEPTION("S0001", "\u5185\u90e8\u7f51\u7edc\u5f02\u5e38\u8bbf\u95ee\u6838\u5fc3\u4e1a\u52a1\u5931\u8d25"),
    ERR_SERVICE_WAIT_HANDLING_TIMEOUT("S0002", "\u7b49\u5f85\u6838\u5fc3\u4e1a\u52a1\u5904\u7406\u8d85\u65f6"),
    ERR_SERVICE_FORBIDDEN_EXCEPTION("S0003", "\u6838\u5fc3\u4e1a\u52a1\u4e0d\u53ef\u7528"),
    ERR_SERVICE_UNKNOWN_EXCEPTION("S0004", "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u6838\u5fc3\u4e1a\u52a1\u6682\u65f6\u4e0d\u53ef\u7528"),
    ERR_IBM_FRAMEWORK_ERROR("Z0001", "IBM\u7cfb\u7edf\u6846\u67b6\u9519\u8bef"),
    ERR_IO_PRINT_EXCEPTION("Z0002", "IO\u8f93\u51fa\u5f02\u5e38"),
    ERR_UNKNOWN_ERROR("Z1999", "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");

    private static final int MIN_ERR_NUMBER = 1;
    private static final int MAX_ERR_NUMBER = 1999;
    private static final String CURRENT_APP_SYSTEM_ID = "T24";
    private String code;
    private String msg;

    private CommonReturnCode(String errCodeRightPart, String returnDesc) {
        if (errCodeRightPart.length() != 5) {
            throw new IllegalArgumentException("\u6839\u636e\u89c4\u8303\uff0c\u8fd4\u56de\u7801\u53ea\u6709\u540e5\u4f4d\u662f\u53ef\u5b9a\u4e49\u7684\u90e8\u5206");
        }
        char errType = errCodeRightPart.charAt(0);
        switch (errType) {
            case 'B': 
            case 'D': 
            case 'F': 
            case 'M': 
            case 'S': 
            case 'Z': {
                break;
            }
            default: {
                throw new IllegalArgumentException("\u6839\u636e\u89c4\u8303\uff0c\u8fd4\u56de\u7801\u5012\u6570\u7b2c5\u4f4d\u4e3a\u5b57\u6bcd\u8868\u793a\u9519\u8bef\u7c7b\u578b\uff0c\u76ee\u524d\u6709M\u3001B\u3001S\u3001F\u3001D\u3001Z");
            }
        }
        String errNumStr = errCodeRightPart.substring(1, 5);
        if (!errNumStr.matches("[0-9]{4}")) {
            throw new IllegalArgumentException("\u6839\u636e\u89c4\u8303\uff0c\u8fd4\u56de\u7801\u540e4\u4f4d\u5fc5\u987b\u4e3a\u6570\u5b57");
        }
        int errNum = Integer.parseInt(errNumStr);
        if (errNum < 1 || errNum > 1999) {
            throw new IllegalArgumentException("\u5e94\u7528\u5b9a\u4e49\u9519\u8bef\u7801\u540e4\u4f4d\u5fc5\u987b\u4ecb\u4e8e0001~1999\u8fd9\u4e2a\u8303\u56f4");
        }
        this.code = "ET24" + errCodeRightPart;
        this.msg = returnDesc;
    }

    private CommonReturnCode(String fullReturnCode, String returnDesc, boolean isSuccessReturnCode) {
        this.code = fullReturnCode;
        this.msg = returnDesc;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public boolean isSuccess() {
        return CommonReturnCode.SUCCESS.code.equals(this.code);
    }
}

