/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum DataRuleType {
    All("00"),
    LEVEL_ONE("01"),
    LEVEL_TWO("02"),
    LEVEL_THREE("03"),
    LEVEL_FOUR("04"),
    LEVEL_FIVE("05"),
    Owner("01"),
    CurrOrg("02"),
    CurrDownOrg("03"),
    CurrOwnerPrd("04");

    private String value;
    private static Map<String, DataRuleType> typeMapper;

    private DataRuleType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static final DataRuleType getDataRuleType(String dataRuleType) {
        if (null == dataRuleType) {
            return LEVEL_ONE;
        }
        if (typeMapper.containsKey(dataRuleType)) {
            return typeMapper.get(dataRuleType);
        }
        return LEVEL_ONE;
    }

    static {
        typeMapper = new ConcurrentHashMap<String, DataRuleType>(DataRuleType.values().length);
        Arrays.stream(DataRuleType.values()).forEach(s -> typeMapper.put(s.getValue(), (DataRuleType)((Object)s)));
    }
}

