/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.spring;

import com.irdstudio.sdk.beans.core.util.AESUtility;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.RSAUtility;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class DecryptPropteryPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    protected String convertProperty(String propertyName, String propertyValue) {
        try {
            if (this.isRasDecryptProperty(propertyName)) {
                propertyValue = super.convertProperty(propertyName, RSAUtility.decryptByBase64(propertyValue, PropertiesUtil.getPropertyByKey("key", "rsa.privateKey")));
            }
            if (this.isAesDecryptProperty(propertyName)) {
                propertyValue = super.convertProperty(propertyName, AESUtility.decryptMD5Key(propertyValue, PropertiesUtil.getPropertyByKey("key", "aes.key")));
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(DecryptPropteryPlaceholderConfigurer.class).error(e.getMessage(), (Throwable)e);
        }
        return this.convertPropertyValue(propertyValue);
    }

    private boolean isRasDecryptProperty(String propertyName) {
        String cfgRasDecrypt = PropertiesUtil.getPropertyByKey("application", propertyName + ".rsa.decrypt");
        return StringUtil.isNotEmpty(propertyName) && Boolean.valueOf(cfgRasDecrypt) != false;
    }

    private boolean isAesDecryptProperty(String propertyName) {
        String cfgRasDecrypt = PropertiesUtil.getPropertyByKey("application", propertyName + ".aes.decrypt");
        return StringUtil.isNotEmpty(propertyName) && Boolean.valueOf(cfgRasDecrypt) != false;
    }
}

