/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.threadpool;

import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.threadpool.ThreadPool;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationThreadPool
implements ThreadPool {
    private String poolName;
    private boolean isRunning = false;
    private BlockingQueue<Callable<ExecuteRtnInfo>> taskQueue;
    private int queueSize;
    private BlockingQueue<Future<ExecuteRtnInfo>> finishQueue;
    private Map<String, Integer> execute_num = new HashMap<String, Integer>();
    private volatile int maxTaskNum;
    private Integer live_thread = 0;
    private int success_num = 0;
    private int failure_num = 0;
    private int finished_task = 0;
    private Thread startThead;
    private static Logger logger = LoggerFactory.getLogger(ApplicationThreadPool.class);

    public void initThreadPool() {
        this.taskQueue = new LinkedBlockingQueue<Callable<ExecuteRtnInfo>>(this.queueSize);
        this.finishQueue = new LinkedBlockingQueue<Future<ExecuteRtnInfo>>(this.maxTaskNum + 1);
        this.startThead = new Thread(() -> this.start());
        this.startThead.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (!this.isRunning) {
            this.isRunning = true;
        }
        int i = 1;
        while (this.isRunning) {
            if (!this.taskQueue.isEmpty()) {
                try {
                    while (this.live_thread >= this.maxTaskNum) {
                        this.unblock();
                        Thread.sleep(500L);
                        Thread.yield();
                    }
                    Callable<ExecuteRtnInfo> callable = this.taskQueue.take();
                    Future<ExecuteRtnInfo> future = Executors.newSingleThreadExecutor().submit(callable);
                    String clazzName = callable.getClass().getName();
                    if (!this.execute_num.containsKey(clazzName)) {
                        this.execute_num.put(clazzName, 0);
                    }
                    this.execute_num.put(clazzName, this.execute_num.get(clazzName) + 1);
                    Object object = this.live_thread;
                    synchronized (object) {
                        Integer n = this.live_thread;
                        Integer n2 = this.live_thread = Integer.valueOf(this.live_thread + 1);
                    }
                    object = this.finishQueue;
                    synchronized (object) {
                        if (this.finishQueue.size() >= this.maxTaskNum - 1) {
                            this.releaseFinishedThread(this.finishQueue.take());
                        }
                        this.finishQueue.put(future);
                    }
                    logger.info(this.toString());
                }
                catch (Throwable e) {
                    logger.error("\u7ebf\u7a0b\u6c60\u8fd0\u884c\u7ebf\u7a0b\u5f02\u5e38!", e);
                }
            } else {
                try {
                    Thread.sleep(200L);
                    if (this.taskQueue.isEmpty()) {
                        this.unblock();
                    }
                }
                catch (InterruptedException e) {
                    logger.error("\u7ebf\u7a0b\u6c60\u91ca\u653e\u4efb\u52a1\u5f02\u5e38!", (Throwable)e);
                }
                ++i;
            }
            if (i % 1200 != 0) continue;
            logger.info(this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(int newQueueSize, int newMaxTaskNum) {
        if (newMaxTaskNum < 0 || newMaxTaskNum < 0) {
            throw new IllegalArgumentException();
        }
        BlockingQueue<Callable<ExecuteRtnInfo>> blockingQueue = this.taskQueue;
        synchronized (blockingQueue) {
            this.maxTaskNum = newMaxTaskNum;
            if (newQueueSize == this.queueSize) {
                return;
            }
            LinkedBlockingQueue<Callable<ExecuteRtnInfo>> newTaskQueue = new LinkedBlockingQueue<Callable<ExecuteRtnInfo>>(newQueueSize);
            while (this.taskQueue.size() > 0) {
            }
            this.taskQueue = newTaskQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void stop() {
        this.unblock();
        this.isRunning = false;
        try {
            BlockingQueue<Callable<ExecuteRtnInfo>> blockingQueue = this.taskQueue;
            synchronized (blockingQueue) {
                if (this.taskQueue.isEmpty()) {
                    this.startThead.stop();
                } else {
                    Thread.sleep(1000L);
                    Thread.yield();
                }
            }
        }
        catch (Exception e) {
            logger.error("\u505c\u6b62\u7ebf\u7a0b\u6c60\u5f02\u5e38!", (Throwable)e);
        }
    }

    @Override
    public void setPoolName(String name) {
        this.poolName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unblock() {
        BlockingQueue<Future<ExecuteRtnInfo>> blockingQueue = this.finishQueue;
        synchronized (blockingQueue) {
            for (Future future : this.finishQueue) {
                this.releaseFinishedThread(future);
                this.finishQueue.remove(future);
            }
            this.finishQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseFinishedThread(Future<ExecuteRtnInfo> future) {
        block11: {
            try {
                if (future.isDone()) {
                    ++this.finished_task;
                    ExecuteRtnInfo info = future.get();
                    switch (info.getRtn()) {
                        case SUCCESS: {
                            ++this.success_num;
                            break;
                        }
                        case EXCEPTION: {
                            break;
                        }
                        case FAILURE: {
                            ++this.failure_num;
                        }
                    }
                    Integer n = this.live_thread;
                    synchronized (n) {
                        Integer n2 = this.live_thread;
                        Integer n3 = this.live_thread = Integer.valueOf(this.live_thread - 1);
                        break block11;
                    }
                }
                this.finishQueue.add(future);
            }
            catch (Exception e) {
                logger.error("\u7ebf\u7a0b\u6c60\u8fd0\u884c\u7ebf\u7a0b\u5f02\u5e38!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Callable<ExecuteRtnInfo> task) throws Exception {
        BlockingQueue<Callable<ExecuteRtnInfo>> blockingQueue = this.taskQueue;
        synchronized (blockingQueue) {
            try {
                this.taskQueue.put(task);
            }
            catch (Exception e) {
                logger.error("\u4efb\u52a1\uff1a" + task + "\u52a0\u5165\u7ebf\u7a0b\u6c60\u5931\u8d25!", (Throwable)e);
                throw e;
            }
            finally {
                this.taskQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Collection<Callable<ExecuteRtnInfo>> tasks) {
        BlockingQueue<Callable<ExecuteRtnInfo>> blockingQueue = this.taskQueue;
        synchronized (blockingQueue) {
            try {
                for (Callable<ExecuteRtnInfo> call : tasks) {
                    this.taskQueue.put(call);
                }
            }
            catch (Exception e) {
                logger.error("\u4efb\u52a1\uff1a" + tasks + "\u52a0\u5165\u7ebf\u7a0b\u6c60\u5931\u8d25!", (Throwable)e);
            }
            finally {
                this.taskQueue.notify();
            }
        }
    }

    public void addExecuteNumber(String key) {
        if (!this.execute_num.containsKey(key)) {
            this.execute_num.put(key, 0);
        }
        this.execute_num.put(key, this.execute_num.get(key) + 1);
    }

    @Override
    public boolean getRunning() {
        return this.isRunning;
    }

    @Override
    public void setRunning(boolean isRunning) {
        if (isRunning && !this.isRunning) {
            this.isRunning = isRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ApplicationThreadPool applicationThreadPool = this;
        synchronized (applicationThreadPool) {
            this.toString();
            this.isRunning = false;
            this.taskQueue.clear();
            this.unblock();
            this.execute_num.clear();
            this.startThead.stop();
        }
    }

    @Override
    public BlockingQueue<Callable<ExecuteRtnInfo>> getTaskQueue() {
        return this.taskQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskQueue(BlockingQueue<Callable<ExecuteRtnInfo>> taskQueue) {
        BlockingQueue<Callable<ExecuteRtnInfo>> blockingQueue = this.taskQueue;
        synchronized (blockingQueue) {
            if (this.taskQueue.size() > 0) {
                this.taskQueue.addAll(taskQueue);
            }
            this.taskQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskQueue(BlockingQueue<Callable<ExecuteRtnInfo>> taskQueue) {
        BlockingQueue<Callable<ExecuteRtnInfo>> blockingQueue = this.taskQueue;
        synchronized (blockingQueue) {
            this.taskQueue.addAll(taskQueue);
            this.taskQueue.notify();
        }
    }

    @Override
    public BlockingQueue<Future<ExecuteRtnInfo>> getFinishQueue() {
        return this.finishQueue;
    }

    public void setFinishQueue(BlockingQueue<Future<ExecuteRtnInfo>> finishQueue) {
        this.finishQueue = finishQueue;
    }

    @Override
    public Integer getMaxTaskNum() {
        return this.maxTaskNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxTask(int maxTask) {
        BlockingQueue<Future<ExecuteRtnInfo>> blockingQueue = this.finishQueue;
        synchronized (blockingQueue) {
            LinkedBlockingQueue<Future<ExecuteRtnInfo>> temp = new LinkedBlockingQueue<Future<ExecuteRtnInfo>>();
            temp.addAll(this.finishQueue);
            this.maxTaskNum = maxTask;
            this.finishQueue = new LinkedBlockingQueue<Future<ExecuteRtnInfo>>(this.maxTaskNum + 1);
            this.finishQueue.addAll(temp);
            temp.clear();
            this.finishQueue.notify();
        }
    }

    @Override
    public Integer getLiveThreadNum() {
        return this.live_thread;
    }

    public void addLiveThread(int liveThread) {
        if (this.live_thread == null) {
            this.live_thread = 0;
        }
        ApplicationThreadPool applicationThreadPool = this;
        applicationThreadPool.live_thread = applicationThreadPool.live_thread + liveThread;
    }

    public Map<String, Integer> getExecuteNum() {
        return this.execute_num;
    }

    public void setExecuteNum(Map<String, Integer> executeNum) {
        if (executeNum != null && executeNum.size() > 0) {
            for (String key : executeNum.keySet()) {
                if (!this.execute_num.containsKey(key)) {
                    this.execute_num.put(key, executeNum.get(key));
                    continue;
                }
                this.execute_num.put(key, executeNum.get(key) + this.execute_num.get(key));
            }
        }
    }

    public int getSuccess_num() {
        return this.success_num;
    }

    public void setSuccess_num(int successNum) {
        this.success_num = successNum;
    }

    public int getFailureNum() {
        return this.failure_num;
    }

    public void setFailureNum(int failure_num) {
        this.failure_num = failure_num;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Pool name:" + this.poolName);
        sb.append(" Queue number: " + this.taskQueue.size());
        sb.append(" WorkThread number:" + this.maxTaskNum);
        sb.append(" LiveThread number:" + this.live_thread);
        sb.append(" Finished task number:" + this.finished_task);
        sb.append(" Success task number:" + this.success_num);
        sb.append(" Failure task number:" + this.failure_num);
        sb.append(" Wait task number:" + this.taskQueue.size());
        sb.append(" Execute number:" + this.execute_num.toString());
        return sb.toString();
    }

    public void setMaxTaskNum(int maxTaskNum) {
        this.maxTaskNum = maxTaskNum;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }
}

