/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.threadpool;

import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationThreadPool2 {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationThreadPool2.class);
    private final ThreadPoolExecutor threadpool;

    public ApplicationThreadPool2(Integer maxThread) {
        this.threadpool = (ThreadPoolExecutor)Executors.newFixedThreadPool(maxThread);
        logger.info("\u7ebf\u7a0b\u6c60\u5df2\u521d\u59cb\u5316\uff01\uff0c\u7ebf\u7a0b\u6c60\u5927\u5c0f\uff1a" + maxThread);
    }

    public Future add(Callable<ExecuteRtnInfo> task) {
        return this.threadpool.submit(task);
    }

    public <RE> Future<ExecuteRtnInfo<RE>> addWithGeneric(Callable<ExecuteRtnInfo<RE>> task) {
        return this.threadpool.submit(task);
    }

    public void change(Integer newThreadNum) {
        this.threadpool.setMaximumPoolSize(newThreadNum);
    }
}

