/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import com.irdstudio.sdk.beans.core.exception.AppRuntimeException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class AssertUtil {
    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new AppRuntimeException(message);
        }
    }

    public static void isTrue(boolean expression) {
        AssertUtil.isTrue(expression, "[Assertion failed] - this expression must be true");
    }

    public static void isNotNull(Object object, String message) {
        if (object == null) {
            throw new AppRuntimeException(message);
        }
    }

    public static void isNotNull(Object object) {
        AssertUtil.isNotNull(object, "[Assertion failed] - this argument is required; it must not be null");
    }

    public static void hasLength(String text, String message) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new AppRuntimeException(message);
        }
    }

    public static void hasLength(String text) {
        AssertUtil.hasLength(text, "[Assertion failed] - this String argument must have length; it must not be null or empty");
    }

    public static void hasText(String text, String message) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw new AppRuntimeException(message);
        }
    }

    public static void hasText(String text) {
        AssertUtil.hasText(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
    }

    public static void doesNotContain(String textToSearch, String substring, String message) {
        if (StringUtils.contains((CharSequence)textToSearch, (CharSequence)substring)) {
            throw new AppRuntimeException(message);
        }
    }

    public static void doesNotContain(String textToSearch, String substring) {
        AssertUtil.doesNotContain(textToSearch, substring, "[Assertion failed] - this String argument must not contain the substring [" + substring + "]");
    }

    public static void notEmpty(Object[] array, String message) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            throw new AppRuntimeException(message);
        }
    }

    public static void notEmpty(Object[] array) {
        AssertUtil.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element");
    }

    public static void noNullElements(Object[] array, String message) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                throw new AppRuntimeException(message);
            }
        }
    }

    public static void noNullElements(Object[] array) {
        AssertUtil.noNullElements(array, "[Assertion failed] - this array must not contain any null elements");
    }

    public static <E> void notEmpty(Collection<E> collection, String message) {
        AssertUtil.isNotNull(collection, message);
        if (collection.isEmpty()) {
            throw new AppRuntimeException(message);
        }
    }

    public static <E> void notEmpty(Collection<E> collection) {
        AssertUtil.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
    }

    public static <K, V> void notEmpty(Map<K, V> map, String message) {
        AssertUtil.isNotNull(map, message);
        if (map.isEmpty()) {
            throw new AppRuntimeException(message);
        }
    }

    public static <K, V> void notEmpty(Map<K, V> map) {
        AssertUtil.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry");
    }

    public static void isInstanceOf(Class<?> clazz, Object obj) {
        AssertUtil.isInstanceOf(clazz, obj, "");
    }

    public static void isInstanceOf(Class<?> type, Object obj, String message) {
        AssertUtil.isNotNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            throw new AppRuntimeException(message + " Object of class [" + (obj != null ? obj.getClass().getName() : "null") + "] must be an instance of " + type);
        }
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) {
        AssertUtil.isAssignable(superType, subType, "");
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String message) {
        AssertUtil.isNotNull(superType, "Type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            throw new AppRuntimeException(message + subType + " is not assignable to " + superType);
        }
    }

    public static void state(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void state(boolean expression) {
        AssertUtil.state(expression, "[Assertion failed] - this state invariant must be true");
    }

    public static void assertMaxLength(String str, int maxLength, String message) {
        if (StringUtils.isEmpty((CharSequence)str) || str.length() > maxLength) {
            throw new AppRuntimeException(message);
        }
    }

    public static void assertNonnegativeInt(int n, String errorMessage) {
        if (n < 0) {
            throw new AppRuntimeException(errorMessage);
        }
    }

    public static void assertGreaterThanOrEqual(int a, int b, String errorMessage) {
        AssertUtil.assertGreaterThanOrEqual((Integer)a, (Integer)b, errorMessage);
    }

    public static void assertGreaterThanOrEqual(Integer a, Integer b, String errorMessage) {
        AssertUtil.isNotNull(a);
        AssertUtil.isNotNull(b);
        if (a < b) {
            throw new AppRuntimeException(errorMessage);
        }
    }

    public static void assertEqual(long l, long m, String errorMessage) {
        AssertUtil.assertEqual((Long)l, (Long)m, errorMessage);
    }

    public static void assertEqual(Long l, Long m, String errorMessage) {
        AssertUtil.isNotNull(l);
        AssertUtil.isNotNull(m);
        if (!l.equals(m)) {
            throw new AppRuntimeException(errorMessage);
        }
    }

    public static void assertGreaterThanOrEqual(long a, long b, String errorMessage) {
        AssertUtil.assertGreaterThanOrEqual((Long)a, (Long)b, errorMessage);
    }

    public static void assertGreaterThanOrEqual(Long a, Long b, String errorMessage) {
        AssertUtil.isNotNull(a);
        AssertUtil.isNotNull(b);
        if (a < b) {
            throw new AppRuntimeException(errorMessage);
        }
    }

    public static void assertGreaterThan(long a, long b, String errorMessage) {
        if (a <= b) {
            throw new AppRuntimeException(errorMessage);
        }
    }

    public static void assertGreaterThan(Long a, Long b, String errorMessage) {
        AssertUtil.isNotNull(a);
        AssertUtil.isNotNull(b);
        AssertUtil.assertGreaterThan((long)a, (long)b, errorMessage);
    }

    public static void assertOneOfThem(short a, String errorMessage, short ... values) {
        boolean pass = false;
        if (values != null) {
            for (short n : values) {
                if (a != n) continue;
                pass = true;
                break;
            }
        } else {
            throw new AppRuntimeException("values\ufffd\ufffd\ufffd\ufffd");
        }
        if (!pass) {
            throw new AppRuntimeException(errorMessage);
        }
    }

    public static void assertGreaterThanZero(long l, String errorMessage) {
        AssertUtil.assertGreaterThanZero((Long)l, errorMessage);
    }

    public static void assertGreaterThanZero(Long l, String errorMessage) {
        AssertUtil.isNotNull(l, errorMessage);
        if (l < 1L) {
            throw new AppRuntimeException(errorMessage);
        }
    }

    public static void assertOneOfThemThanZero(String errorMessage, int ... values) {
        boolean exception = true;
        if (values != null) {
            for (int n : values) {
                if (n < 0) continue;
                exception = false;
                break;
            }
        }
        if (exception) {
            throw new AppRuntimeException(errorMessage);
        }
    }

    public static void assertNotNull(Object o, String errorMessage) {
        if (o == null) {
            throw new AppRuntimeException(errorMessage);
        }
    }

    public static void assertTimeRange(Date start, Date end, String errorMessage) {
        if (start == null || end == null) {
            throw new AppRuntimeException("start\u6216end\u4e3a\u7a7a");
        }
        if (start.after(end)) {
            throw new AppRuntimeException(errorMessage);
        }
    }
}

