/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import com.alibaba.fastjson.JSON;
import com.irdstudio.sdk.beans.core.util.Bean2TemplateXmlUtility;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFileUtil {
    private static Logger logger = LoggerFactory.getLogger(DataFileUtil.class);
    private static String defaultSeparator = "|";
    private static String defaultCharacterSet = "UTF-8";

    public static <T> List<T> readTxt(File file, Class<? extends T> clazz, String templateName) throws Exception {
        return DataFileUtil.readTxt(file, clazz, templateName, defaultCharacterSet);
    }

    public static <T> List<T> readTxt(File file, Class<? extends T> clazz, String templateName, String charSet) throws Exception {
        InputStreamReader reader = null;
        BufferedReader br = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(file), charSet);
            br = new BufferedReader(reader);
            String line = br.readLine();
            ArrayList<T> tList = new ArrayList<T>();
            while (StringUtil.isStrNotEmpty(line)) {
                T object = clazz.newInstance();
                String jsonStr = DataFileUtil.dataToJsonStr(line, templateName);
                object = DataFileUtil.jsonStrToBean(object, jsonStr);
                tList.add(object);
                line = br.readLine();
            }
            ArrayList<T> arrayList = tList;
            return arrayList;
        }
        catch (UnsupportedEncodingException e) {
            logger.info("The Character Encoding is not supported:" + e);
            throw new Exception("The Character Encoding is not supported:" + e);
        }
        catch (FileNotFoundException e) {
            logger.info("open the file denoted by a specified pathname has failed:" + e);
            throw new Exception("open the file denoted by a specified pathname has failed:" + e);
        }
        catch (IOException e) {
            logger.info("I/O operations has faile:" + e);
            throw new Exception("I/O operations has faile:" + e);
        }
        catch (IllegalArgumentException e) {
            logger.info(" an illegal or inappropriate argument:" + e);
            throw new Exception("an illegal or inappropriate argument:" + e);
        }
        finally {
            if (Objects.nonNull(br)) {
                br.close();
            }
            if (Objects.nonNull(reader)) {
                reader.close();
            }
        }
    }

    private static String dataToJsonStr(String data, String templateName) {
        String[] dataArray = data.split("\\" + defaultSeparator);
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        String baseKey = "field";
        for (int i = 0; i < dataArray.length; ++i) {
            fieldMap.put(baseKey + (i + 1), DataFileUtil.replaceBlank(dataArray[i]));
        }
        return Bean2TemplateXmlUtility.getTemplate(templateName, fieldMap);
    }

    private static <T> T jsonStrToBean(Object t, String jsonStr) {
        t = JSON.parseObject((String)jsonStr, t.getClass());
        return (T)t;
    }

    private static String replaceBlank(String str) {
        if (StringUtil.isEmpty(str)) {
            return "";
        }
        return str.replaceAll("\\s", "").replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "'");
    }
}

