/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import com.irdstudio.sdk.beans.core.exception.BizException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtility {
    private static Logger logger = LoggerFactory.getLogger(DateUtility.class);
    public static final String TIME_FORMATE_MODE = "yyyy-MM-dd HH:mm:ss";
    public static Pattern pattern = Pattern.compile("(\\d+)\u5e74(\\d+)\u6708(\\d+)[\u65e5\u53f7]");

    public static Date getCurrAppDate() {
        return new Date();
    }

    public static String getCurrAppDateStr() {
        return DateUtility.formatDate(DateUtility.getCurrAppDate(), "yyyy-MM-dd");
    }

    public static String formatDate(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String getCurrAppTimeStr() {
        return DateUtility.formatDate(DateUtility.getCurrAppDate(), "HH:mm:ss");
    }

    public static String getCurrAppDateTimeStr() {
        return DateUtility.formatDate(DateUtility.getCurrAppDate(), TIME_FORMATE_MODE);
    }

    public static String getCurrAppDateTimeString() {
        return DateUtility.formatDate(DateUtility.getCurrAppDate(), TIME_FORMATE_MODE);
    }

    public static String format8To10(String date) {
        return DateUtility.formatDate(DateUtility.parseDate(date, "yyyyMMdd"), "yyyy-MM-dd");
    }

    public static String format10To8(String date) {
        return DateUtility.formatDate(DateUtility.parseDate(date, "yyyy-MM-dd"), "yyyyMMdd");
    }

    public static Date parseDate(String dateStr, String pattern) {
        try {
            return new SimpleDateFormat(pattern).parse(dateStr);
        }
        catch (ParseException parseException) {
            return DateUtility.getCurrAppDate();
        }
    }

    public static void checkDate(String date, String pattern) throws BizException {
        try {
            new SimpleDateFormat(pattern).parse(date);
        }
        catch (ParseException e) {
            throw new BizException("\u65e5\u671f" + date + "\u4e0d\u7b26\u5408" + pattern + "\u683c\u5f0f!");
        }
    }

    public static void checkDate1(String dateStr, String sName) throws BizException {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1][0-9])|([2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        Matcher m = pattern.matcher(dateStr);
        if (!m.matches()) {
            throw new BizException("\u4f20\u5165\u53c2\u6570\u3010" + sName + "\uff1a" + dateStr + "\u3011\u4e0d\u7b26\u5408\u683c\u5f0f\u8981\u6c42");
        }
        logger.info("\u4f20\u5165\u53c2\u6570\u3010" + sName + "\uff1a" + dateStr + "\u3011\u7b26\u5408\u683c\u5f0f\u8981\u6c42");
    }

    public static String formatDateTime19To14(String date) throws BizException {
        if (date == null || "".equals(date)) {
            return "";
        }
        if (date.length() != 19) {
            throw new BizException("\u65f6\u95f4\uff1a" + date + "\u683c\u5f0f\u4e0d\u5408\u89c4");
        }
        try {
            SimpleDateFormat sf1 = new SimpleDateFormat(TIME_FORMATE_MODE);
            SimpleDateFormat sf2 = new SimpleDateFormat("yyyyMMddHHmmss");
            String dt = sf2.format(sf1.parse(date));
            return dt;
        }
        catch (Exception e) {
            throw new BizException("\u65f6\u95f4\uff1a" + date + "\u683c\u5f0f\u4e0d\u5408\u89c4");
        }
    }

    public static String formatDateTime14To19(String date) throws BizException {
        if (date == null || "".equals(date)) {
            return "";
        }
        if (date.length() != 14) {
            throw new BizException("\u65f6\u95f4\uff1a" + date + "\u683c\u5f0f\u4e0d\u5408\u89c4");
        }
        try {
            SimpleDateFormat sfl = new SimpleDateFormat("yyyyMMddHHmmss");
            SimpleDateFormat sf2 = new SimpleDateFormat(TIME_FORMATE_MODE);
            String dt = sf2.format(sfl.parse(date));
            return dt;
        }
        catch (Exception e) {
            throw new BizException("\u65f6\u95f4\uff1a" + date + "\u683c\u5f0f\u4e0d\u5408\u89c4");
        }
    }

    public static int getCurrentYear(String dateStr) {
        String[] date = dateStr.split("-");
        return Integer.parseInt(date[0], 10);
    }

    public static int getCurrentMonth(String dateStr) {
        String[] date = dateStr.split("-");
        return Integer.parseInt(date[1], 10);
    }

    public static int getCurrentDay(String dateStr) {
        String[] date = dateStr.split("-");
        return Integer.parseInt(date[2], 10);
    }

    public static String bYearZero(int y) {
        if (y < 10) {
            return "000" + String.valueOf(y);
        }
        if (y < 100) {
            return "00" + String.valueOf(y);
        }
        if (y < 1000) {
            return "0" + String.valueOf(y);
        }
        return String.valueOf(y);
    }

    public static String bZero(int m) {
        return m < 10 ? "0" + String.valueOf(m) : String.valueOf(m);
    }

    public static String getDateStr(String dateStr, int hkm) {
        String reDateStr = "";
        int yy = Integer.parseInt(dateStr.substring(0, 4), 10);
        int mm = Integer.parseInt(dateStr.substring(4, 6), 10);
        int dd = Integer.parseInt(dateStr.substring(6, 8), 10);
        int yy2 = 0;
        int mm2 = 0;
        int dd2 = dd;
        if ((mm + hkm) % 12 == 0) {
            yy2 = yy + (mm + hkm) / 12 - 1;
            mm2 = 12;
        } else if ((mm + hkm) % 12 == 1) {
            yy2 = yy + (mm + hkm) / 12;
            mm2 = 1;
        } else {
            yy2 = yy + (mm + hkm) / 12;
            mm2 = (mm + hkm) % 12;
        }
        reDateStr = String.valueOf(yy2) + "-" + DateUtility.bZero(mm2) + "-" + DateUtility.bZero(dd2);
        return reDateStr;
    }

    public static int getMonthDays(int year, int month) {
        int days = 1;
        boolean isrn = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
        switch (month) {
            case 1: {
                days = 31;
                break;
            }
            case 2: {
                if (isrn) {
                    days = 29;
                    break;
                }
                days = 28;
                break;
            }
            case 3: {
                days = 31;
                break;
            }
            case 4: {
                days = 30;
                break;
            }
            case 5: {
                days = 31;
                break;
            }
            case 6: {
                days = 30;
                break;
            }
            case 7: {
                days = 31;
                break;
            }
            case 8: {
                days = 31;
                break;
            }
            case 9: {
                days = 30;
                break;
            }
            case 10: {
                days = 31;
                break;
            }
            case 11: {
                days = 30;
                break;
            }
            case 12: {
                days = 31;
            }
        }
        return days;
    }

    public static int getBetweenDays(String beginDate, String endDate) {
        int sum = 0;
        int beginYear = DateUtility.getCurrentYear(beginDate);
        int beginMonth = DateUtility.getCurrentMonth(beginDate);
        int beginDay = DateUtility.getCurrentDay(beginDate);
        int endYear = DateUtility.getCurrentYear(endDate);
        int endMonth = DateUtility.getCurrentMonth(endDate);
        int endDay = DateUtility.getCurrentDay(endDate);
        String startDateStr = DateUtility.bYearZero(beginYear) + DateUtility.bZero(beginMonth) + "01";
        int sumMonth = (endYear - beginYear + 1) * 12 - beginMonth - (12 - endMonth);
        for (int i = 0; i < sumMonth; ++i) {
            String dateStr = DateUtility.getDateStr(startDateStr, i);
            sum += DateUtility.getMonthDays(DateUtility.getCurrentYear(dateStr), DateUtility.getCurrentMonth(dateStr));
        }
        sum = sum - beginDay + endDay;
        return sum;
    }

    public static String getCurrDate() {
        String TIME_FORMATE_MODE = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(TIME_FORMATE_MODE);
        return sdf.format(new Date());
    }

    public static String getCurrDateTime() {
        String TIME_FORMATE_MODE = TIME_FORMATE_MODE;
        SimpleDateFormat sdf = new SimpleDateFormat(TIME_FORMATE_MODE);
        return sdf.format(new Date());
    }

    public static String getCurrTime() {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        return df.format(new Date());
    }

    private static String ADD_DATE(int optype, String date, int num) {
        String st_return = "";
        try {
            DateFormat daf_date = DateFormat.getDateInstance(2, Locale.CHINA);
            daf_date.parse(date);
            Calendar calendar = daf_date.getCalendar();
            calendar.add(optype, num);
            String st_m = "";
            String st_d = "";
            int y = calendar.get(1);
            int m = calendar.get(2) + 1;
            int d = calendar.get(5);
            st_m = m <= 9 ? "0" + m : "" + m;
            st_d = d <= 9 ? "0" + d : "" + d;
            st_return = y + "-" + st_m + "-" + st_d;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return st_return;
    }

    public static String ADD_DAY(String date, int n) {
        return DateUtility.ADD_DATE(5, date, n);
    }

    public static String ADD_MONTH(String date, int n) {
        return DateUtility.ADD_DATE(2, date, n);
    }

    public static String getStartDateByMonths(Date endDate, int months) throws BizException {
        String startDate = "";
        if (endDate == null) {
            return null;
        }
        try {
            Calendar calendarEndDate = Calendar.getInstance();
            calendarEndDate.setTime(endDate);
            calendarEndDate.add(2, 0 - months);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            startDate = sdf.format(calendarEndDate.getTime());
        }
        catch (Exception e) {
            throw new BizException("\u65f6\u95f4\uff1a" + endDate + "\u683c\u5f0f\u4e0d\u5408\u89c4");
        }
        return startDate;
    }

    public static String getStartMonthByMonths(Date endDate, int months) throws BizException {
        String startMonth = "";
        if (endDate == null) {
            return null;
        }
        try {
            Calendar calendarEndDate = Calendar.getInstance();
            calendarEndDate.setTime(endDate);
            calendarEndDate.add(2, 0 - months);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            startMonth = sdf.format(calendarEndDate.getTime());
        }
        catch (Exception e) {
            throw new BizException("\u65f6\u95f4\uff1a" + endDate + "\u683c\u5f0f\u4e0d\u5408\u89c4");
        }
        return startMonth;
    }

    public static String changeDateFormat(String date) {
        date = date.replace("-", "/");
        return date;
    }

    public static int compareToDate(String date1, String date2) throws BizException {
        String TIME_FORMATE_MODE = "yyyy-MM-dd";
        SimpleDateFormat df = new SimpleDateFormat(TIME_FORMATE_MODE);
        try {
            Date dt1 = df.parse(date1);
            Date dt2 = df.parse(date2);
            return dt1.compareTo(dt2);
        }
        catch (ParseException e) {
            throw new BizException(e.getMessage(), e);
        }
    }

    public static String parseExcelUploadDateString(String excelStr, String formatPattern) {
        if (StringUtils.isNotBlank((CharSequence)excelStr)) {
            String formatStr = excelStr;
            Matcher startedMatcher = pattern.matcher(excelStr);
            if (startedMatcher.matches()) {
                formatStr = String.format("%s-%s-%s", startedMatcher.group(1), StringUtils.leftPad((String)startedMatcher.group(2), (int)2, (String)"0"), StringUtils.leftPad((String)startedMatcher.group(3), (int)2, (String)"0"));
            } else {
                formatStr = StringUtils.replaceEach((String)excelStr, (String[])new String[]{".", "/", "\\"}, (String[])new String[]{"-", "-", "-"});
                Object[] strs = StringUtils.split((String)formatStr, (String)"-");
                for (int i = 0; i < strs.length; ++i) {
                    if (strs[i].length() != 1) continue;
                    strs[i] = StringUtils.leftPad((String)strs[i], (int)2, (String)"0");
                }
                formatStr = StringUtils.join((Object[])strs, (String)"-");
            }
            if (StringUtils.isBlank((CharSequence)formatPattern)) {
                formatPattern = "yyyy-MM-dd";
            }
            if (StringUtils.equals((CharSequence)formatPattern, (CharSequence)"yyyy-MM-dd")) {
                return formatStr;
            }
            try {
                Date date = DateUtils.parseDate((String)formatStr, (String[])new String[]{"yyyy-MM-dd"});
                return DateFormatUtils.format((Date)date, (String)formatPattern);
            }
            catch (Exception e) {
                return excelStr;
            }
        }
        return excelStr;
    }
}

