/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class FileUtil {
    public static byte[] getContent(String filePath) throws IOException {
        File file = new File(filePath);
        return FileUtil.getContent(file);
    }

    public static byte[] toByteArray(String filename) throws IOException {
        File f = new File(filename);
        return FileUtil.toByteArray(f);
    }

    public static byte[] toByteArrayByChannel(String filename) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            throw new FileNotFoundException(filename);
        }
        return FileUtil.toByteArrayByChannel(f);
    }

    public static byte[] getContent(File file) throws IOException {
        int offset;
        long fileSize = file.length();
        if (fileSize > Integer.MAX_VALUE) {
            return null;
        }
        FileInputStream fi = new FileInputStream(file);
        byte[] buffer = new byte[(int)fileSize];
        int numRead = 0;
        for (offset = 0; offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
        }
        if (offset != buffer.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        fi.close();
        return buffer;
    }

    public static byte[] toByteArray(File f) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.getName());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)f.length());
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(f));
            int buf_size = 1024;
            byte[] buffer = new byte[buf_size];
            int len = 0;
            while (-1 != (len = in.read(buffer, 0, buf_size))) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            bos.close();
        }
    }

    public static byte[] toByteArrayByChannel(File f) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.getName());
        }
        AbstractInterruptibleChannel channel = null;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(f);
            channel = fs.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)((FileChannel)channel).size());
            while (((FileChannel)channel).read(byteBuffer) > 0) {
            }
            byte[] byArray = byteBuffer.array();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] toByteArray3(String filename) throws IOException {
        FileChannel fc = null;
        try {
            fc = new RandomAccessFile(filename, "r").getChannel();
            MappedByteBuffer byteBuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size()).load();
            byte[] result = new byte[(int)fc.size()];
            if (byteBuffer.remaining() > 0) {
                byteBuffer.get(result, 0, byteBuffer.remaining());
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeBytesToFile(byte[] bs, String targetFilePath, String targetFileName) throws IOException {
        FileOutputStream out = new FileOutputStream(targetFilePath + targetFileName);
        ByteArrayInputStream is = new ByteArrayInputStream(bs);
        byte[] buff = new byte[1024];
        int len = 0;
        while ((len = is.read(buff)) != -1) {
            ((OutputStream)out).write(buff, 0, len);
        }
        ((InputStream)is).close();
        ((OutputStream)out).close();
    }

    public static void byteCopyFile(File fromFile, String to) throws Exception {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(fromFile);
            int readLen = 0x500000;
            int fileLen = (int)fromFile.length();
            if (readLen > fileLen) {
                readLen = fileLen;
            }
            byte[] byt = new byte[readLen];
            File toFile = new File(to);
            String fName = toFile.getName();
            String p = to.substring(0, to.indexOf(fName) - 1);
            File pf = new File(p);
            if (!pf.exists()) {
                pf.mkdirs();
            }
            if (toFile.exists()) {
                toFile.delete();
            }
            toFile.createNewFile();
            fos = new FileOutputStream(toFile);
            int read = fis.read(byt);
            while (read != -1) {
                fos.write(byt, 0, read);
                read = fis.read(byt);
                if (read != 0) continue;
            }
            fos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeContent(String content, String filePath, boolean appendToFile) throws Exception {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(filePath, appendToFile);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            bw = new BufferedWriter(osw);
            bw.write(content);
            bw.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (osw != null) {
                    osw.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String readFileByLines(String absolutePath) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        String str = "";
        br = new BufferedReader(new InputStreamReader(new FileInputStream(absolutePath)));
        while ((str = br.readLine()) != null) {
            sb.append(str).append("\n");
        }
        if (Objects.nonNull(br)) {
            br.close();
        }
        return sb.toString();
    }

    public static List<File> getDirAllFile(File parentFile) {
        if (!parentFile.exists()) {
            return Collections.emptyList();
        }
        if (StringUtils.equalsAny((CharSequence)parentFile.getName(), (CharSequence[])new CharSequence[]{".git"})) {
            return Collections.emptyList();
        }
        ArrayList<File> list = new ArrayList<File>();
        if (parentFile.isFile()) {
            list.add(parentFile);
        }
        if (parentFile.isDirectory()) {
            File[] files;
            for (File subFile : files = parentFile.listFiles()) {
                list.addAll(FileUtil.getDirAllFile(subFile));
            }
        }
        return list;
    }

    public static void copyDirToDir(File src, File desc) throws IOException {
        File localProjectDir = src;
        if (localProjectDir.exists() && localProjectDir.isDirectory()) {
            File[] localSubDir;
            for (File sub : localSubDir = localProjectDir.listFiles()) {
                File target = new File(desc, sub.getName());
                if (sub.isDirectory()) {
                    if (sub.getName().equals(".git")) continue;
                    FileUtils.copyDirectory((File)sub, (File)target);
                    continue;
                }
                FileUtils.copyFile((File)sub, (File)target);
            }
        }
    }
}

