/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.irdstudio.sdk.beans.core.annotation.BeanMapKey;
import com.irdstudio.sdk.beans.core.util.NumberUtility;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.dubbo.common.utils.PojoUtils;
import org.slf4j.LoggerFactory;

public final class HsfGenericUtils {
    public static final String CLASS_STRING = "class";

    public static final Object exchangeRtnData(Object hsfRtnObj) throws Exception {
        Object rtnObj = null;
        String clazzName = "java.lang.Object";
        if (hsfRtnObj instanceof Map) {
            clazzName = (String)((Map)hsfRtnObj).get(CLASS_STRING);
        }
        if (clazzName.matches(".+Exception$")) {
            rtnObj = HsfGenericUtils.map2Exception((Map)hsfRtnObj);
            if (Objects.nonNull(rtnObj)) {
                throw (Exception)rtnObj;
            }
            LoggerFactory.getLogger(HsfGenericUtils.class).error("\u89e3\u6790\u5f02\u5e38\u5bf9\u8c61\u51fa\u9519!+\n\r" + hsfRtnObj);
        } else {
            rtnObj = PojoUtils.realize((Object)hsfRtnObj, Class.forName(clazzName));
        }
        return rtnObj;
    }

    public static final Object jsonExchangeRtnData(Object hsfRtnObj) throws Exception {
        if (hsfRtnObj instanceof Map) {
            Map rtnMap = (Map)hsfRtnObj;
            Object rtnObj = null;
            if (rtnMap.containsKey(CLASS_STRING)) {
                rtnObj = Class.forName((String)rtnMap.get(CLASS_STRING)).newInstance();
                JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)rtnMap));
                rtnObj = JSONObject.toJavaObject((JSON)jsonObject, rtnObj.getClass());
            }
            return rtnObj;
        }
        if (hsfRtnObj instanceof List) {
            List list = null;
            JSONArray jsonArray = JSONObject.parseArray((String)JSONObject.toJSONString((Object)hsfRtnObj), (Feature[])new Feature[0]);
            if (Objects.nonNull(jsonArray) && !jsonArray.isEmpty()) {
                Class<?> listGenrClass = Class.forName((String)jsonArray.getJSONObject(0).get((Object)CLASS_STRING));
                list = JSONObject.parseArray((String)jsonArray.toJSONString(), listGenrClass);
            }
            return list;
        }
        return hsfRtnObj;
    }

    public static Object map2Bean(Map<String, Object> dataMap) throws Exception {
        Object object = null;
        String clazzName = (String)dataMap.get(CLASS_STRING);
        if (StringUtil.isNotEmpty(clazzName)) {
            if (clazzName.matches(".+Exception$")) {
                object = HsfGenericUtils.newExceptionObject(clazzName, (String)dataMap.get("message"));
                HsfGenericUtils.exceptionMap2Bean(dataMap, object);
            } else {
                object = HsfGenericUtils.newObject(clazzName);
                object = HsfGenericUtils.map2Object(dataMap, object);
            }
        }
        return object;
    }

    public static Object map2Exception(Map<String, Object> dataMap) throws Exception {
        Object object = null;
        String clazzName = (String)dataMap.get(CLASS_STRING);
        if (StringUtil.isNotEmpty(clazzName)) {
            object = HsfGenericUtils.newExceptionObject(clazzName, HsfGenericUtils.removePrefix((String)dataMap.get("message")));
            HsfGenericUtils.exceptionMap2Bean(dataMap, object);
        }
        return object;
    }

    public static Object map2Object(Map<String, Object> dataMap, Object object) throws Exception {
        if (Objects.nonNull(dataMap) && !dataMap.isEmpty() && Objects.nonNull(object)) {
            for (String key : dataMap.keySet()) {
                List<Object> valObj = dataMap.get(key);
                if (!Objects.nonNull(valObj)) continue;
                if (valObj instanceof List) {
                    List valObjList = valObj;
                    valObj = HsfGenericUtils.list2Bean(valObjList);
                } else if (valObj instanceof Map) {
                    valObj = HsfGenericUtils.map2Bean((Map)((Object)valObj));
                }
                try {
                    HsfGenericUtils.setValue(object, key, valObj);
                }
                catch (Exception exception) {}
            }
        }
        return object;
    }

    public static Object exceptionMap2Bean(Map<String, Object> dataMap, Object object) throws Exception {
        if (Objects.nonNull(dataMap) && !dataMap.isEmpty() && Objects.nonNull(object)) {
            for (String key : dataMap.keySet()) {
                Object valObj = dataMap.get(key);
                if ("stackTrace".equals(key)) {
                    valObj = HsfGenericUtils.getstackTrace(valObj);
                }
                if ("message".equals(key)) {
                    valObj = HsfGenericUtils.removePrefix(StringUtil.replaceObjNull(valObj));
                }
                if (!Objects.nonNull(valObj)) continue;
                try {
                    HsfGenericUtils.setValue(object, key, valObj);
                }
                catch (Exception exception) {}
            }
        }
        return object;
    }

    private static StackTraceElement[] getstackTrace(Object obj) {
        List<Object> collStacks = null;
        if (obj instanceof Collection) {
            collStacks = (List<Object>)obj;
        } else if (obj.getClass().isArray()) {
            collStacks = Arrays.asList((Object[])obj);
        } else {
            return null;
        }
        LinkedList<StackTraceElement> stacks = new LinkedList<StackTraceElement>();
        for (Object e : collStacks) {
            Map dataMap = (Map)e;
            String lineNumber = StringUtil.replaceObjNull(dataMap.get("lineNumber"));
            stacks.add(new StackTraceElement(StringUtil.replaceObjNull(dataMap.get("className")), StringUtil.replaceObjNull(dataMap.get("methodName")), StringUtil.replaceObjNull(dataMap.get("fileName")), NumberUtility.isInteger(lineNumber) ? Integer.valueOf(lineNumber) : -1));
        }
        return stacks.toArray(new StackTraceElement[stacks.size()]);
    }

    public static Object newObject(String clazzName) throws Exception {
        return Class.forName(clazzName).newInstance();
    }

    private static Object newExceptionObject(String clazzName, String message) throws Exception {
        Constructor<?> c2;
        Object obj = null;
        Class<?> clazz = Class.forName(clazzName);
        try {
            c2 = clazz.getConstructor(Throwable.class);
            obj = c2.newInstance(new Exception(message));
        }
        catch (Exception c2) {
            // empty catch block
        }
        if (Objects.isNull(obj)) {
            try {
                c2 = clazz.getConstructor(String.class);
                obj = c2.newInstance(message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj;
    }

    private static final String removePrefix(String message) {
        try {
            return Pattern.compile("Exception From Host:\\[{1}[0-9]*\\.[0-9]*\\.[0-9]*\\.[0-9]*\\]{1}").matcher(message).replaceAll("");
        }
        catch (Exception exception) {
            return message;
        }
    }

    public static void setValue(Object bean, String fieldKey, Object objVal) throws Exception {
        Field field = HsfGenericUtils.getFiled(bean, fieldKey);
        if (Objects.nonNull(field)) {
            field.setAccessible(true);
            if (Enum.class.isAssignableFrom(field.getType())) {
                objVal = Enum.valueOf(field.getType(), StringUtil.replaceObjNull(objVal));
            }
            field.set(bean, objVal);
        }
    }

    public static Field getFiled(Object bean, String key) {
        ArrayList<Field> list = new ArrayList<Field>();
        Class<?> clazz = bean.getClass();
        while (Objects.nonNull(clazz) && !clazz.getName().equals("java.lang.Object")) {
            list.clear();
            list.addAll(Arrays.asList(clazz.getDeclaredFields()));
            Field field = list.parallelStream().filter(s -> HsfGenericUtils.getFiled(s, key)).findFirst().orElse(null);
            if (Objects.nonNull(field)) {
                return field;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static boolean getFiled(Field field, String key) {
        JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
        if (Objects.nonNull(jsonProperty)) {
            return key.equals(jsonProperty.value());
        }
        BeanMapKey beanMapKey = field.getAnnotation(BeanMapKey.class);
        if (Objects.nonNull(beanMapKey)) {
            return key.equals(beanMapKey.value());
        }
        return field.getName().equals(key);
    }

    public static List<Object> list2Bean(List<Object> list) throws Exception {
        ArrayList<Object> dataList = new ArrayList<Object>();
        if (Objects.nonNull(list) && !list.isEmpty()) {
            if (list.get(0) instanceof Map) {
                for (Object obj : list) {
                    Map dataMap = (Map)obj;
                    dataList.add(HsfGenericUtils.map2Bean(dataMap));
                }
            } else {
                dataList.add(list);
            }
        }
        return dataList;
    }
}

