/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import org.springframework.test.util.ReflectionTestUtils;

public class ReflectUtility {
    public static final Object convert(Object object, Class<?> convertClass) throws Exception {
        Object rtnObject = null;
        if (Objects.nonNull(convertClass) && Objects.nonNull(object)) {
            if (Objects.equals(convertClass, object.getClass())) {
                rtnObject = object;
            }
            String strObject = String.valueOf(object);
            if (String.class.isAssignableFrom(convertClass)) {
                rtnObject = strObject;
            }
            if (Number.class.isAssignableFrom(convertClass)) {
                Method method = ReflectUtility.getObjectMethod(convertClass, "valueOf", String.class);
                if (Objects.nonNull(method)) {
                    rtnObject = method.invoke(convertClass.newInstance(), strObject);
                } else {
                    method = ReflectUtility.getObjectMethod(convertClass, "valueOf", Long.class);
                    if (Objects.nonNull(method)) {
                        rtnObject = method.invoke(convertClass.newInstance(), Long.valueOf(strObject));
                    }
                }
            }
        }
        return rtnObject;
    }

    public static final Field getObjectFiled(Object bean, String name) throws Exception {
        Class<?> clazz = bean.getClass();
        return ReflectUtility.getObjectFiled(clazz, name);
    }

    public static final Field getObjectFiled(Class<?> clazz, String name) throws Exception {
        while (Objects.nonNull(clazz) && !clazz.getName().equals("java.lang.Object")) {
            Field field = clazz.getField(name);
            if (Objects.nonNull(field)) {
                return field;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setObjectFieldValue(Object object, Field field, Object value) {
        boolean isAccessible = field.isAccessible();
        try {
            if (!isAccessible) {
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (Exception exception) {
        }
        finally {
            if (!isAccessible) {
                field.setAccessible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object getObjectFieldValue(Object object, Field field) {
        boolean isAccessible = field.isAccessible();
        try {
            if (!isAccessible) {
                field.setAccessible(true);
            }
            Object object2 = field.get(object);
            return object2;
        }
        catch (Exception exception) {
        }
        finally {
            if (!isAccessible) {
                field.setAccessible(false);
            }
        }
        return null;
    }

    public static final Method getObjectMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        return Optional.of(clazz.getDeclaredMethod(name, parameterTypes)).orElse(clazz.getMethod(name, parameterTypes));
    }

    public static final void invokeSetter(Object object, String fieldName, Object value, boolean throwException) {
        block2: {
            try {
                ReflectionTestUtils.invokeSetterMethod((Object)object, (String)fieldName, (Object)value);
            }
            catch (Exception e) {
                if (!throwException) break block2;
                throw new RuntimeException(String.format("\u6839\u636e\u5c5e\u6027\u540d\u79f0 %s \u8c03\u7528setter\u65b9\u6cd5\u5f02\u5e38 %s", fieldName, e.getMessage()), e);
            }
        }
    }

    public static final Object invokeGetter(Object object, String fieldName, boolean throwException) {
        try {
            Object value = ReflectionTestUtils.invokeGetterMethod((Object)object, (String)fieldName);
            return value;
        }
        catch (Exception e) {
            if (throwException) {
                throw new RuntimeException(String.format("\u6839\u636e\u5c5e\u6027\u540d\u79f0 %s \u8c03\u7528getter\u65b9\u6cd5\u5f02\u5e38 %s", fieldName, e.getMessage()), e);
            }
            return null;
        }
    }
}

