/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import com.irdstudio.sdk.beans.core.util.StringUtils;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.sftp.SftpClientFactory;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFTPUtil {
    private static Logger logger = LoggerFactory.getLogger(SFTPUtil.class);
    private ChannelSftp channel;
    private Session session;
    private String userName;
    private String password;
    private String ftpHost;
    private int ftpPort;

    public SFTPUtil() {
    }

    public SFTPUtil(String userName, String password, String ftpHost, int ftpPort) throws JSchException, FileSystemException {
        this.userName = userName;
        this.password = password;
        this.ftpHost = ftpHost;
        this.ftpPort = ftpPort;
        logger.info("SFTP\u8fde\u63a5\u4fe1\u606f: userName=" + userName + ", password=******, ftpHost=" + ftpHost + ", ftpPort=" + ftpPort);
        this.connectServer();
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    public void closeSFTP() {
        this.disconnect();
    }

    public synchronized boolean downFile(SFTPUtil sftp, String remotePath, String remoteFile, String localFile, boolean closeFlag) throws Exception {
        boolean flag = false;
        InputStream input = null;
        FileOutputStream out = null;
        try {
            this.channel.cd(remotePath);
            input = this.channel.get(remoteFile);
            if (localFile != null && !"".equals(localFile)) {
                File checkFileTemp = new File(localFile);
                if (!checkFileTemp.getParentFile().exists()) {
                    checkFileTemp.getParentFile().mkdirs();
                }
            } else {
                boolean checkFileTemp = flag;
                return checkFileTemp;
            }
            out = new FileOutputStream(new File(localFile));
            byte[] bt = new byte[1024];
            int length = -1;
            while ((length = input.read(bt)) != -1) {
                out.write(bt, 0, length);
            }
            if (closeFlag) {
                sftp.disconnect();
            }
            flag = true;
        }
        catch (SftpException e) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01" + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01" + e.getMessage());
        }
        catch (FileNotFoundException e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5230\u672c\u5730\u7684\u8def\u5f84\u6709\u8bef\uff01" + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u4e0b\u8f7d\u6587\u4ef6\u5230\u672c\u5730\u7684\u8def\u5f84\u6709\u8bef\uff01");
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u5199\u5165\u6709\u8bef\uff01" + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u6587\u4ef6\u5199\u5165\u6709\u8bef\uff01");
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return flag;
    }

    public synchronized boolean downFile(SFTPUtil sftp, String remotePath, String remoteFileName, String localFilePath, String localFileName, boolean closeFlag) throws Exception {
        boolean flag = false;
        InputStream input = null;
        FileOutputStream out = null;
        try {
            input = this.channel.get(remotePath + remoteFileName);
            String localRemoteFile = localFilePath + remoteFileName;
            File checkFileTemp = null;
            if (localRemoteFile != null && !"".equals(localRemoteFile)) {
                checkFileTemp = new File(localRemoteFile);
                if (!checkFileTemp.getParentFile().exists()) {
                    checkFileTemp.getParentFile().mkdirs();
                }
            } else {
                boolean bl = flag;
                return bl;
            }
            out = new FileOutputStream(new File(localRemoteFile));
            byte[] bt = new byte[1024];
            int length = -1;
            while ((length = input.read(bt)) != -1) {
                out.write(bt, 0, length);
            }
            if (closeFlag) {
                sftp.disconnect();
            }
            flag = true;
            File upSupFile = new File(localFilePath + localFileName);
            if (checkFileTemp != null) {
                checkFileTemp.renameTo(upSupFile);
            }
        }
        catch (SftpException e) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01" + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01");
        }
        catch (FileNotFoundException e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5230\u672c\u5730\u7684\u8def\u5f84\u6709\u8bef\uff01" + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u4e0b\u8f7d\u6587\u4ef6\u5230\u672c\u5730\u7684\u8def\u5f84\u6709\u8bef\uff01");
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u5199\u5165\u6709\u8bef\uff01" + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u6587\u4ef6\u5199\u5165\u6709\u8bef\uff01");
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return flag;
    }

    public synchronized boolean upFile(String remotePath, String fileName, String localFile, boolean closeFlag, boolean filePathFlag) throws Exception {
        boolean flag = false;
        FileInputStream input = null;
        try {
            input = new FileInputStream(localFile);
            if (filePathFlag) {
                String[] dirs = remotePath.split("\\/");
                if (dirs == null || dirs.length < 1) {
                    dirs = remotePath.split("\\\\");
                }
                String now = this.channel.pwd();
                this.channel.cd("/");
                for (int i = 0; i < dirs.length; ++i) {
                    if (dirs[i] == null || "".equals(dirs[i])) continue;
                    boolean dirExists = false;
                    try {
                        dirExists = this.openDirs(dirs[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (dirExists) continue;
                    this.channel.mkdir(dirs[i]);
                    this.channel.cd(dirs[i]);
                }
                this.channel.cd(now);
            }
            this.channel.cd(remotePath);
            this.channel.put((InputStream)input, fileName);
            this.channel.chmod(444, fileName);
            flag = true;
        }
        catch (SftpException e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01" + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01" + e.getMessage());
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFoundException \u4e0a\u4f20\u6587\u4ef6\u627e\u4e0d\u5230\uff01" + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u8def\u5f84\u6709\u8bef\uff01" + e.getMessage());
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (Exception e) {
                    logger.error("\u8f93\u5165\u6d41\u5173\u95ed\u5931\u8d25" + e.getMessage());
                    e.printStackTrace();
                }
            }
            if (closeFlag) {
                this.disconnect();
            }
        }
        return flag;
    }

    private synchronized void connectServer() throws JSchException, FileSystemException {
        if (this.channel != null) {
            this.disconnect();
        }
        FileSystemOptions fso = new FileSystemOptions();
        SftpFileSystemConfigBuilder.getInstance().setStrictHostKeyChecking(fso, "no");
        logger.info("SFTP\u8fde\u63a5\u6b63\u5728\u521b\u5efaSession... ...");
        this.session = SftpClientFactory.createConnection((String)this.ftpHost, (int)this.ftpPort, (char[])this.userName.toCharArray(), (char[])this.password.toCharArray(), (FileSystemOptions)fso);
        logger.info("SFTP\u8fde\u63a5Session\u521b\u5efa\u6210\u529f");
        logger.info("SFTP\u8fde\u63a5\u6b63\u5728\u6253\u5f00SFTP\u901a\u9053... ...");
        Channel _channel = this.session.openChannel("sftp");
        logger.info("SFTP\u8fde\u63a5\u901a\u9053\u6253\u5f00\u6210\u529f");
        logger.info("SFTP\u8fde\u63a5\u4e2d... ...");
        _channel.connect();
        logger.info("SFTP\u8fde\u63a5\u6210\u529f");
        this.channel = (ChannelSftp)_channel;
    }

    private synchronized void disconnect() {
        if (this.channel != null) {
            this.channel.exit();
        }
        logger.info("SFTP\u8fde\u63a5\u901a\u9053\u5173\u95ed\u6210\u529f");
        if (this.session != null) {
            this.session.disconnect();
        }
        logger.info("SFTP\u8fde\u63a5\u9000\u51faSession\u6210\u529f");
        this.channel = null;
    }

    public synchronized InputStream downFile(String remotePath, String remoteFile) throws Exception {
        try {
            this.channel.cd(remotePath);
            return this.channel.get(remoteFile);
        }
        catch (SftpException e) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01" + e.getMessage());
            e.printStackTrace();
            throw new Exception("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", e);
        }
    }

    public synchronized boolean openDirs(String directory) {
        try {
            this.channel.cd(directory);
            return true;
        }
        catch (SftpException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized boolean checkSFTPFile(String remoteFolder, String remoteFileName, Boolean closeFlag) throws Exception {
        boolean flag = false;
        try {
            if (!this.openDirs(remoteFolder)) {
                logger.info("SFTP\u8fdc\u7a0b\u6587\u4ef6\u76ee\u5f55" + remoteFolder + "\u4e0d\u5b58\u5728\uff01\uff01\uff01");
                boolean bl = flag;
                return bl;
            }
            Pattern pattern = Pattern.compile(remoteFileName);
            Vector<ChannelSftp.LsEntry> files = this.ls(remoteFolder);
            for (ChannelSftp.LsEntry file : files) {
                if (!file.getFilename().equals(remoteFileName) && !pattern.matcher(file.getFilename()).find()) continue;
                int count = (int)pattern.splitAsStream(file.getFilename()).filter(new Predicate<String>(){

                    @Override
                    public boolean test(String arg0) {
                        return !"".equals(arg0);
                    }
                }).count();
                if (count != StringUtils.countForStr(remoteFileName, "[*]")) {
                    flag = false;
                    continue;
                }
                flag = true;
            }
            logger.info("SFTP\u8fdc\u7a0b\u6587\u4ef6" + remoteFolder + remoteFileName + (flag ? "\u5b58\u5728" : "\u4e0d\u5b58\u5728"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (closeFlag.booleanValue()) {
                this.disconnect();
            }
        }
        return flag;
    }

    public synchronized boolean checkSFTPFile(String remoteFolder, String[] signArray, Boolean closeFlag) throws Exception {
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = true;
        try {
            if (!this.openDirs(remoteFolder)) {
                logger.info("SFTP\u8fdc\u7a0b\u6587\u4ef6\u76ee\u5f55" + remoteFolder + "\u4e0d\u5b58\u5728\uff01\uff01\uff01");
                boolean bl = flag;
                return bl;
            }
            for (String signFileName : signArray) {
                flag1 = false;
                Vector<ChannelSftp.LsEntry> files = this.ls(remoteFolder);
                for (ChannelSftp.LsEntry file : files) {
                    if (!file.getFilename().equals(signFileName)) continue;
                    flag1 = true;
                }
                if (!flag1) {
                    flag2 = false;
                }
                logger.info("SFTP\u8fdc\u7a0b\u6587\u4ef6" + remoteFolder + signFileName + (flag1 ? "\u5b58\u5728" : "\u4e0d\u5b58\u5728"));
                logger.info("---------------------------------------->>>>>>>>>>" + signFileName + ":" + flag1);
            }
            if (flag2) {
                flag = flag2;
            }
            logger.info("---------------------------------------->>>>>>>>>>>>>" + flag);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (closeFlag.booleanValue()) {
                this.disconnect();
            }
        }
        return flag;
    }

    public synchronized Vector<ChannelSftp.LsEntry> ls(String directory) throws Exception {
        try {
            Class<ChannelSftp> c = ChannelSftp.class;
            Field field = c.getDeclaredField("server_version");
            field.setAccessible(true);
            field.set(this.channel, 2);
            this.channel.setFilenameEncoding("GBK");
            return this.channel.ls(directory);
        }
        catch (SftpException e) {
            e.printStackTrace();
            logger.error("\u67e5\u770b\u6307\u5b9a\u76ee\u5f55" + directory + "\u4e0b\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            throw new Exception(e.getMessage(), e);
        }
    }

    public boolean isNew(String userName, String ftpHost) throws FileSystemException, JSchException {
        if (userName.equals(this.userName) && ftpHost.equals(this.ftpHost)) {
            if (this.channel == null || this.channel.isClosed()) {
                this.connectServer();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean renameFile(String oldPath, String fileName, String newPath, boolean closeFlag, boolean filePathFlag) throws Exception {
        boolean flag = false;
        try {
            if (filePathFlag) {
                String[] dirs = newPath.split("\\/");
                if (dirs == null || dirs.length < 1) {
                    dirs = newPath.split("\\\\");
                }
                String now = this.channel.pwd();
                this.channel.cd("/");
                for (int i = 0; i < dirs.length; ++i) {
                    if (dirs[i] == null || "".equals(dirs[i])) continue;
                    boolean dirExists = false;
                    try {
                        dirExists = this.openDirs(dirs[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (dirExists) continue;
                    this.channel.mkdir(dirs[i]);
                    this.channel.cd(dirs[i]);
                }
                this.channel.cd(now);
            }
            if (this.checkSFTPFile(oldPath, fileName, (Boolean)false)) {
                this.channel.cd(oldPath);
                this.channel.rename(oldPath + fileName, newPath + fileName);
            }
            flag = true;
        }
        catch (Exception e) {
            logger.error("\u91cd\u547d\u540d\u6587\u4ef6\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u91cd\u547d\u540d\u6587\u4ef6\u5931\u8d25\uff01" + e.getMessage());
        }
        finally {
            if (closeFlag) {
                this.disconnect();
            }
        }
        return flag;
    }
}

