/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.test.util.ReflectionTestUtils;

public class TmModelUtil {
    public static final String tableCodeToClassName(String tableCode) {
        String[] names;
        if (StringUtils.isBlank((CharSequence)tableCode)) {
            return tableCode;
        }
        String splitChar = "_";
        if (tableCode.indexOf(95) == -1) {
            splitChar = "-";
        }
        if ((names = tableCode.toLowerCase().split(splitChar)).length == 1) {
            names = tableCode.split(splitChar);
        }
        StringBuffer classNameBuffer = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            classNameBuffer.append(StringUtils.capitalize((String)names[i]));
        }
        return classNameBuffer.toString();
    }

    public static final String modelCodeToClassName(String modelCode) {
        String splitChar = "_";
        if (modelCode.indexOf(95) == -1) {
            splitChar = "-";
        }
        String[] names = modelCode.split(splitChar);
        StringBuffer classNameBuffer = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            classNameBuffer.append(StringUtils.capitalize((String)names[i]));
        }
        return classNameBuffer.toString();
    }

    public static final String propertyToField(String property) {
        if (null == property) {
            return "";
        }
        char[] chars = property.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (char c : chars) {
            if (CharUtils.isAsciiAlphaUpper((char)c)) {
                sb.append("_" + StringUtils.lowerCase((String)CharUtils.toString((char)c)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static final String fieldToProperty(String field) {
        if (null == field) {
            return "";
        }
        char[] chars = (field = StringUtils.replace((String)field, (String)"-", (String)"_")).indexOf("_") == -1 ? field.toCharArray() : field.toLowerCase().toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '_') {
                int j = i + 1;
                if (j >= chars.length) continue;
                sb.append(StringUtils.upperCase((String)CharUtils.toString((char)chars[j])));
                ++i;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static final String fieldTypeToJavaType(String fieldType) {
        if (StringUtils.isEmpty((CharSequence)fieldType)) {
            return "\u65e0\u6548\u6570\u636e\u7c7b\u578b";
        }
        if ("VARCHAR".equals(fieldType = fieldType.toUpperCase()) || "VARCHAR2".equals(fieldType) || "CLOB".equals(fieldType) || "CHAR".equals(fieldType) || "NCHAR".equals(fieldType) || "CHAR2".equals(fieldType) || "TIMESTAMP".equals(fieldType) || "TEXT".equals(fieldType) || "LONG".equals(fieldType) || "DATE".equals(fieldType) || "LONGBLOB".equals(fieldType) || "DATETIME".equals(fieldType) || "TIME".equals(fieldType) || "NVARCHAR".equals(fieldType)) {
            return "String";
        }
        if ("INT".equals(fieldType) || "SMALLINT".equals(fieldType) || "MEDIUMINT".equals(fieldType)) {
            return "Integer";
        }
        if ("DECIMAL".equals(fieldType) || "NUMBER".equals(fieldType) || "BIGINT".equals(fieldType)) {
            return "BigDecimal";
        }
        return "String";
    }

    public static final Class<?> fieldTypeToJavaClass(String fieldType) {
        String type = TmModelUtil.fieldTypeToJavaType(fieldType);
        if (type.equals("String")) {
            return String.class;
        }
        if (type.equals("Integer")) {
            return Integer.class;
        }
        if (type.equals("BigDecimal")) {
            return BigDecimal.class;
        }
        return null;
    }

    public static String wrapperNull(Object obj, String key, String defaultVal) {
        String val = TmModelUtil.wrapperNull(obj, key);
        if (StringUtils.isBlank((CharSequence)val)) {
            val = defaultVal;
        }
        if (StringUtils.isBlank((CharSequence)val)) {
            val = "";
        }
        return val;
    }

    public static String wrapperNull(Object obj, String key) {
        String value = null;
        if (obj instanceof Map) {
            if (key.contains(".")) {
                String[] keyPaths = StringUtils.split((String)key, (String)".");
                Object val = obj;
                for (int i = 0; i < keyPaths.length && val != null; ++i) {
                    val = val instanceof Map ? ((Map)val).get(keyPaths[i]) : ReflectionTestUtils.invokeGetterMethod((Object)val, (String)keyPaths[i]);
                }
                if (val != null) {
                    value = val.toString();
                }
            } else {
                value = MapUtils.getString((Map)((Map)obj), (Object)key);
            }
        } else if (key.contains(".")) {
            String[] keyPaths = StringUtils.split((String)key, (String)".");
            Object val = obj;
            for (int i = 0; i < keyPaths.length && val != null; ++i) {
                val = val instanceof Map ? ((Map)val).get(keyPaths[i]) : ReflectionTestUtils.invokeGetterMethod((Object)val, (String)keyPaths[i]);
            }
            if (val != null) {
                value = val.toString();
            }
        } else {
            Object val = ReflectionTestUtils.invokeGetterMethod((Object)obj, (String)key);
            if (val != null) {
                value = val.toString();
            }
        }
        if (value == null) {
            return "";
        }
        return value;
    }
}

