/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.vo;

import com.alibaba.fastjson.JSON;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class FilterItem {
    private String logicOp;
    private String op;
    private List<String> colNames;
    private List<String> keys;
    private List<String> values;

    public String getLogicOp() {
        return StringUtils.isBlank((CharSequence)this.logicOp) ? "AND" : this.logicOp;
    }

    public void setLogicOp(String logicOp) {
        logicOp = RegExUtils.removeAll((String)this.op, (String)"\\s");
        if (!StringUtils.equalsAnyIgnoreCase((CharSequence)logicOp, (CharSequence[])new CharSequence[]{"AND", "OR"})) {
            logicOp = "AND";
        }
        this.logicOp = StringUtils.upperCase((String)logicOp);
    }

    public String getOp() {
        return RegExUtils.removeAll((String)this.op, (String)"\\s");
    }

    public FilterOpEnum getOpEnum() {
        return FilterOpEnum.get(this.op);
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getStartKey() {
        if (this.keys == null || this.keys.size() == 0) {
            return null;
        }
        return RegExUtils.removeAll((String)this.keys.get(0), (String)"\\s");
    }

    public String getEndKey() {
        if (this.keys == null || this.keys.size() == 0) {
            return null;
        }
        if (this.keys.size() < 2) {
            return this.getStartKey();
        }
        return RegExUtils.removeAll((String)this.keys.get(1), (String)"\\s");
    }

    public String getKey() {
        return this.getStartKey();
    }

    public void setKey(String key) {
        this.keys = new ArrayList<String>();
        this.keys.add(key);
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    public List<String> getColNames() {
        return this.colNames;
    }

    public void setColNames(List<String> colNames) {
        this.colNames = colNames;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public String getColName() {
        if (this.colNames != null && this.colNames.size() > 0 && StringUtils.isNotBlank((CharSequence)this.colNames.get(0))) {
            return RegExUtils.removeAll((String)this.colNames.get(0), (String)"\\s");
        }
        return BaseInfo.javaPropToColName(this.getKey());
    }

    public String getStartColName() {
        if (this.colNames != null && this.colNames.size() > 0 && StringUtils.isNotBlank((CharSequence)this.colNames.get(0))) {
            return RegExUtils.removeAll((String)this.colNames.get(0), (String)"\\s");
        }
        return BaseInfo.javaPropToColName(this.getStartKey());
    }

    public String getEndColName() {
        if (this.colNames != null && this.colNames.size() > 0) {
            if (StringUtils.isNotBlank((CharSequence)this.colNames.get(1))) {
                return RegExUtils.removeAll((String)this.colNames.get(1), (String)"\\s");
            }
            if (StringUtils.isNotBlank((CharSequence)this.getStartColName())) {
                return this.getStartColName();
            }
        }
        return BaseInfo.javaPropToColName(this.getEndKey());
    }

    public String getValue() {
        if (this.values != null && this.values.size() > 0) {
            return this.values.get(0);
        }
        return null;
    }

    public String getStartValue() {
        if (this.values != null && this.values.size() > 0) {
            return this.values.get(0);
        }
        return null;
    }

    public String getEndValue() {
        if (this.values != null && this.values.size() > 1) {
            return this.values.get(1);
        }
        return null;
    }

    public static List<FilterItem> parseFilter(String filterCondJson) {
        if (StringUtils.isBlank((CharSequence)filterCondJson)) {
            return Collections.emptyList();
        }
        try {
            List itemList = JSON.parseArray((String)filterCondJson, FilterItem.class);
            return itemList;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(FilterItem.class).error("\u8fc7\u6ee4\u6761\u4ef6\u89e3\u6790\u9519\u8bef {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }

    public boolean getOpLike() {
        return FilterOpEnum.Like == this.getOpEnum();
    }

    public boolean getOpNotLike() {
        return FilterOpEnum.NotLike == this.getOpEnum();
    }

    public boolean getOpIn() {
        return FilterOpEnum.In == this.getOpEnum();
    }

    public boolean getOpNotIn() {
        return FilterOpEnum.NotIn == this.getOpEnum();
    }

    public boolean getOpBetween() {
        return FilterOpEnum.Between == this.getOpEnum();
    }

    public boolean getOpEquals() {
        return FilterOpEnum.Equals == this.getOpEnum();
    }

    public boolean getOpGreaterThan() {
        return FilterOpEnum.GreaterThan == this.getOpEnum();
    }

    public boolean getOpGreaterEquals() {
        return FilterOpEnum.GreaterEquals == this.getOpEnum();
    }

    public boolean getOpLessThan() {
        return FilterOpEnum.LessThan == this.getOpEnum();
    }

    public boolean getOpLessEquals() {
        return FilterOpEnum.LessEquals == this.getOpEnum();
    }

    public static enum FilterOpEnum {
        Like("lk", "\u5305\u542b"),
        NotLike("nlk", "\u4e0d\u5305\u542b"),
        In("i", "\u5305\u542bIn"),
        NotIn("ni", "\u4e0d\u5305\u542bIn"),
        Between("btw", "\u4ecb\u4e8e"),
        Equals("eq", "\u7b49\u4e8e"),
        GreaterThan("gt", "\u5927\u4e8e"),
        GreaterEquals("ge", "\u5927\u4e8e\u7b49\u4e8e"),
        LessThan("lt", "\u5c0f\u4e8e"),
        LessEquals("le", "\u5c0f\u4e8e\u7b49\u4e8e");

        private String code;
        private String name;

        private FilterOpEnum(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public static String nameByCode(String code) {
            if (code == null) {
                return "";
            }
            for (FilterOpEnum r : FilterOpEnum.values()) {
                if (!r.getCode().equals(code)) continue;
                return r.getName();
            }
            return "";
        }

        public static String codeByName(String name) {
            if (name == null) {
                return "";
            }
            for (FilterOpEnum r : FilterOpEnum.values()) {
                if (!r.getName().equals(name)) continue;
                return r.getCode();
            }
            return "";
        }

        public static FilterOpEnum get(String code) {
            if (code == null) {
                return null;
            }
            for (FilterOpEnum r : FilterOpEnum.values()) {
                if (!r.getCode().equals(code)) continue;
                return r;
            }
            return null;
        }
    }
}

