/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import com.irdstudio.sdk.beans.core.util.Base64;
import java.security.MessageDigest;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class AESUtility {
    public static final String AES_KEY_ALGORITHM = "AES";
    public static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    static Base64.Encoder encoder = java.util.Base64.getEncoder();

    public static final String encryptMD5Key(String src, String key) throws Exception {
        return new String(encoder.encode(AESUtility.encryptMD5Key(src.getBytes("UTF-8"), AESUtility.getMD5KeyBytes(key))));
    }

    public static final String encrypt(String src, String key) throws Exception {
        return new String(encoder.encode(AESUtility.encrypt(src.getBytes("UTF-8"), AESUtility.getMD5KeyBytes(key))));
    }

    public static final byte[] encryptMD5Key(byte[] src, byte[] key) throws Exception {
        if (key == null) {
            return null;
        }
        MessageDigest alg = MessageDigest.getInstance("MD5");
        alg.update(key);
        byte[] key16 = alg.digest();
        SecretKeySpec skeySpec = new SecretKeySpec(key16, AES_KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, skeySpec);
        byte[] encrypted = cipher.doFinal(src);
        return encrypted;
    }

    public static final byte[] encrypt(byte[] src, byte[] key16) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(key16, AES_KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, skeySpec);
        return cipher.doFinal(src);
    }

    public static final String decryptMD5Key(String str, String key) throws Exception {
        return new String(AESUtility.decryptMD5Key(Base64.decode(str), AESUtility.getMD5KeyBytes(key)), "UTF-8");
    }

    public static final byte[] decryptMD5Key(byte[] src, byte[] key) throws Exception {
        if (key == null) {
            return null;
        }
        MessageDigest alg = MessageDigest.getInstance("MD5");
        alg.update(key);
        byte[] key16 = alg.digest();
        SecretKeySpec skeySpec = new SecretKeySpec(key16, AES_KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, skeySpec);
        return cipher.doFinal(src);
    }

    public static final byte[] getMD5KeyBytes(String strKey) throws Exception {
        if (null == strKey || strKey.length() < 1) {
            throw new Exception("key is null or empty!");
        }
        MessageDigest alg = MessageDigest.getInstance("MD5");
        alg.update(strKey.getBytes());
        return alg.digest();
    }

    public static final String getSecretKey() throws Exception {
        return AESUtility.getSecretKey(128);
    }

    public static final String getSecretKey(int length) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(AES_KEY_ALGORITHM);
        kg.init(256);
        SecretKey sk = kg.generateKey();
        return new String(encoder.encode(sk.getEncoded()));
    }

    public static void main(String[] args) throws Exception {
        String s = AESUtility.encryptMD5Key("lp_piccs", "y3PsTEpHRnI9EZe0zBNeaIzi1225MEhGIJcaPzSBsKI=");
        System.out.println(s);
    }
}

