/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import com.irdstudio.sdk.beans.core.exception.BizException;
import com.irdstudio.sdk.beans.core.util.DateUtility;
import com.irdstudio.sdk.beans.core.util.NumberUtility;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageRuleCheckUtil {
    private static Logger logger = LoggerFactory.getLogger(MessageRuleCheckUtil.class);

    public static void checkDouble(String param, String name) throws BizException {
        if (!NumberUtility.isDouble(param)) {
            logger.error("\u53c2\u6570[" + name + "], \u503c[" + param + "]\u5408\u89c4\u6027\u6821\u9a8c\u4e0d\u901a\u8fc7!");
            throw new BizException("\u53c2\u6570[" + name + "], \u503c[" + param + "]\u5408\u89c4\u6027\u6821\u9a8c\u4e0d\u901a\u8fc7!");
        }
    }

    public static void checkInteger(String param, String name) throws BizException {
        if (!NumberUtility.isInteger(param)) {
            logger.error("\u53c2\u6570[" + name + "], \u503c[" + param + "]\u5408\u89c4\u6027\u6821\u9a8c\u4e0d\u901a\u8fc7!");
            throw new BizException("\u53c2\u6570[" + name + "], \u503c[" + param + "]\u5408\u89c4\u6027\u6821\u9a8c\u4e0d\u901a\u8fc7!");
        }
    }

    public static void checkNameSpell(String param) throws BizException {
        Matcher matcher = Pattern.compile("([ ]||[a-zA-Z])+").matcher(param);
        if (!matcher.matches()) {
            logger.error("\u62fc\u97f3[" + param + "]\u5408\u89c4\u6027\u6821\u9a8c\u4e0d\u901a\u8fc7!");
            throw new BizException("\u62fc\u97f3[" + param + "]\u5408\u89c4\u6027\u6821\u9a8c\u4e0d\u901a\u8fc7!");
        }
    }

    public static void validateIdNo18(String idNo) throws BizException {
        if (idNo.length() != 18) {
            throw new BizException("\u53ea\u652f\u630118\u4f4d\u8eab\u4efd\u8bc1\u6821\u9a8c");
        }
        String[] valCodeArr = new String[]{"1", "0", "x", "9", "8", "7", "6", "5", "4", "3", "2"};
        String[] wi = new String[]{"7", "9", "10", "5", "8", "4", "2", "1", "6", "3", "7", "9", "10", "5", "8", "4", "2"};
        String ai = "";
        String idCard = idNo.toLowerCase();
        if (idCard.length() == 18) {
            ai = idCard.substring(0, 17);
        } else if (idCard.length() == 15) {
            ai = idCard.substring(0, 6) + "19" + idCard.substring(6, 15);
        }
        if (!NumberUtility.isNumeric(ai)) {
            throw new BizException("18\u4f4d\u8bc1\u4ef6\u53f7\u7801\u9664\u6700\u540e\u4e00\u4f4d\u5916\u5747\u4e3a\u6570\u5b57");
        }
        String year = ai.substring(6, 10);
        String month = ai.substring(10, 12);
        String day = ai.substring(12, 14);
        GregorianCalendar gc = new GregorianCalendar();
        try {
            if (gc.get(1) - Integer.parseInt(year) > 150 || gc.getTime().getTime() - DateUtility.parseDate(year + "-" + month + "-" + day, "yyyy-MM-dd").getTime() < 0L) {
                throw new BizException("\u51fa\u751f\u65e5\u671f\u4e0d\u5728\u6709\u6548\u8303\u56f4\u5185");
            }
        }
        catch (BizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BizException(e.getMessage());
        }
        if (Integer.parseInt(month) > 12 || Integer.parseInt(month) == 0) {
            throw new BizException("\u8eab\u4efd\u8bc1\u6708\u4efd\u65e0\u6548");
        }
        if (Integer.parseInt(day) > 31 || Integer.parseInt(day) == 0) {
            throw new BizException("\u8eab\u4efd\u8bc1\u65e5\u671f\u65e0\u6548");
        }
        int totalmulAiWi = 0;
        for (int i = 0; i < 17; ++i) {
            totalmulAiWi += Integer.parseInt(String.valueOf(ai.charAt(i))) * Integer.parseInt(wi[i]);
        }
        int modValue = totalmulAiWi % 11;
        String strVerifyCode = valCodeArr[modValue];
        if (!(ai = ai + strVerifyCode).equals(idCard)) {
            throw new BizException("\u8eab\u4efd\u8bc1\u65e0\u6548, \u4e0d\u662f\u5408\u6cd5\u8eab\u4efd\u8bc1\u53f7\u7801");
        }
    }

    public static void checkDate(String sName, String date, String pattern) throws BizException {
        try {
            DateUtility.checkDate(date, pattern);
        }
        catch (Exception e) {
            logger.error("\u53c2\u6570[" + sName + "]\u5bf9\u5e94\u7684\u503c[" + date + "], \u4e0d\u7b26\u5408\u5b9a\u4e49\u683c\u5f0f[" + pattern + "]!");
            throw new BizException("\u53c2\u6570[" + sName + "]\u5bf9\u5e94\u7684\u503c[" + date + "], \u4e0d\u7b26\u5408\u5b9a\u4e49\u683c\u5f0f[" + pattern + "]!");
        }
        logger.debug("\u53c2\u6570[" + sName + "]\u5bf9\u5e94\u7684\u503c[" + date + "], \u683c\u5f0f[" + pattern + "]\u6821\u9a8c\u901a\u8fc7!");
    }
}

