/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import com.irdstudio.sdk.beans.core.util.StringUtils;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.util.ReflectionUtils;

public class SqlScriptGenerateUtil {
    private static Logger log = LoggerFactory.getLogger(SqlScriptGenerateUtil.class);
    private static final String EMPTY_STR = "";

    public static String generateSqlScript(List<? extends BaseInfo> list, Class<? extends BaseInfo> clazz) {
        return SqlScriptGenerateUtil.generateSqlScript(list, clazz, Collections.emptyList());
    }

    public static String generateSqlScript(List<? extends BaseInfo> list, Class<? extends BaseInfo> clazz, List<String> ignoreFields) {
        List[] insertInfos = SqlScriptGenerateUtil.generateInsertInfo(list, ignoreFields);
        if (insertInfos == null) {
            return EMPTY_STR;
        }
        StringBuffer sqlSb = new StringBuffer();
        String clazzName = clazz.getSimpleName();
        String tableName = SqlScriptGenerateUtil.javaPropToColName(SqlScriptGenerateUtil.wrapperTableName(clazzName));
        sqlSb.append("INSERT INTO ").append(tableName).append(" (");
        Object[] columns = insertInfos[0].toArray(new String[0]);
        sqlSb.append(org.apache.commons.lang3.StringUtils.join((Object[])columns, (String)","));
        sqlSb.append(")").append(" VALUES ");
        for (int i = 1; i < insertInfos.length; ++i) {
            sqlSb.append("(");
            for (int j = 0; j < insertInfos[i].size(); ++j) {
                Object obj = insertInfos[i].get(j);
                if (obj == null) {
                    sqlSb.append("NULL");
                } else {
                    sqlSb.append(String.format("'%s'", StringUtils.escapeStringForSql(obj.toString())));
                }
                if (j >= insertInfos[i].size() - 1) continue;
                sqlSb.append(",");
            }
            sqlSb.append(")");
            if (i >= insertInfos.length - 1) continue;
            sqlSb.append(", \n");
        }
        String sql = sqlSb.toString();
        return sql;
    }

    public static List<String> generateSqlScript2List(List list, Class<?> clazz) {
        return SqlScriptGenerateUtil.generateSqlScript2List(list, clazz, Collections.emptyList());
    }

    public static List<String> generateSqlScript2List(List list, Class<?> clazz, List<String> ignoreFields) {
        List[] insertInfos = SqlScriptGenerateUtil.generateInsertInfo(list, ignoreFields);
        if (insertInfos == null) {
            return Collections.emptyList();
        }
        String clazzName = clazz.getSimpleName();
        String tableName = SqlScriptGenerateUtil.javaPropToColName(SqlScriptGenerateUtil.wrapperTableName(clazzName));
        ArrayList<String> sqls = new ArrayList<String>(list.size());
        Object[] columns = insertInfos[0].toArray(new String[0]);
        StringBuffer sqlSb = new StringBuffer();
        for (int i = 1; i < insertInfos.length; ++i) {
            sqlSb.append("INSERT INTO ").append(tableName).append(" (");
            sqlSb.append(org.apache.commons.lang3.StringUtils.join((Object[])columns, (String)","));
            sqlSb.append(")").append(" VALUES ");
            sqlSb.append("(");
            for (int j = 0; j < insertInfos[i].size(); ++j) {
                Object obj = insertInfos[i].get(j);
                if (obj == null) {
                    sqlSb.append("NULL");
                } else {
                    sqlSb.append(String.format("'%s'", StringUtils.escapeStringForSql(obj.toString())));
                }
                if (j >= insertInfos[i].size() - 1) continue;
                sqlSb.append(",");
            }
            sqlSb.append(");");
            sqls.add(sqlSb.toString());
            sqlSb.delete(0, sqlSb.length());
        }
        return sqls;
    }

    private static String wrapperTableName(String clazzName) {
        String newName = org.apache.commons.lang3.StringUtils.replaceEach((String)clazzName, (String[])new String[]{"DTO", "DO", "PO", "VO"}, (String[])new String[]{EMPTY_STR, EMPTY_STR, EMPTY_STR, EMPTY_STR});
        return org.apache.commons.lang3.StringUtils.uncapitalize((String)newName);
    }

    private static String javaFieldName(String dbColName) {
        String[] words = org.apache.commons.lang3.StringUtils.split((String)dbColName, (String)"_");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (i > 0) {
                buffer.append(org.apache.commons.lang3.StringUtils.capitalize((String)word.toLowerCase()));
                continue;
            }
            buffer.append(word.toLowerCase());
        }
        return buffer.toString();
    }

    public static String javaPropToColName(String prop) {
        String regx = "[A-Z]";
        Pattern pattern = Pattern.compile(regx);
        Matcher m = pattern.matcher(prop);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "_" + m.group().toLowerCase());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static List<Object[]> getPOJOValues(Object bean) {
        return SqlScriptGenerateUtil.getPOJOValues(bean, false);
    }

    public static List<Object[]> getPOJOValues(Object bean, boolean withNull) {
        Field[] fields;
        if (bean == null) {
            return new ArrayList<Object[]>();
        }
        ArrayList<Object[]> vals = new ArrayList<Object[]>();
        Class<?> cls = bean.getClass();
        for (Field f : fields = cls.getDeclaredFields()) {
            if (f.getName().equals("serialVersionUID") || f.getAnnotation(BaseInfo.Ignore.class) != null) continue;
            String dbName = SqlScriptGenerateUtil.javaPropToColName(f.getName());
            Object val = ReflectionTestUtils.invokeGetterMethod((Object)bean, (String)f.getName());
            if (!withNull && val == null) continue;
            vals.add(new Object[]{dbName, val});
        }
        return vals;
    }

    public static List[] generateInsertInfo(List beans, List<String> ignoreFields) {
        if (CollectionUtils.isEmpty((Collection)beans)) {
            return null;
        }
        List[] vals = new List[beans.size() + 1];
        if (beans.get(0) == null) {
            return null;
        }
        Class<?> cls = beans.get(0).getClass();
        Field[] fields = cls.getDeclaredFields();
        vals[0] = new ArrayList(fields.length);
        for (int i = 0; i < beans.size(); ++i) {
            ArrayList<Object> beanVal;
            Object bean = beans.get(i);
            vals[i + 1] = beanVal = new ArrayList<Object>(fields.length);
            for (Field f : fields) {
                if (f.getName().equals("serialVersionUID") || f.getAnnotation(BaseInfo.Ignore.class) != null || ignoreFields.contains(f.getName())) continue;
                String dbName = SqlScriptGenerateUtil.javaPropToColName(f.getName());
                Object val = ReflectionTestUtils.invokeGetterMethod(bean, (String)f.getName());
                if (i == 0) {
                    vals[0].add(dbName);
                }
                beanVal.add(val);
            }
        }
        return vals;
    }

    public static <T> T generatePOJO(ResultSet rs, Class<T> cls) {
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            T t = cls.newInstance();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String colName = metaData.getColumnLabel(i);
                String fieldName = SqlScriptGenerateUtil.javaFieldName(colName);
                Object obj = rs.getObject(colName);
                Field field = ReflectionUtils.findField(cls, (String)fieldName);
                if (field == null && (field = ReflectionUtils.findField(cls, (String)colName)) != null) {
                    fieldName = colName;
                }
                if (field == null) continue;
                obj = SqlScriptGenerateUtil.convertType(obj, field.getType());
                if (field.getName().startsWith("set")) {
                    fieldName = "set" + org.apache.commons.lang3.StringUtils.capitalize((String)field.getName());
                }
                try {
                    ReflectionTestUtils.invokeSetterMethod(t, (String)fieldName, (Object)obj);
                    continue;
                }
                catch (Exception e) {
                    log.error("{} {} {} {} {}", new Object[]{cls, fieldName, field.getType(), obj, obj == null ? null : obj.getClass()});
                }
            }
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> generateMap(ResultSet rs) {
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String colName = metaData.getColumnLabel(i);
                String fieldName = SqlScriptGenerateUtil.javaFieldName(colName);
                Object obj = rs.getObject(colName);
                resultMap.put(colName, obj);
                resultMap.put(fieldName, obj);
            }
            return resultMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Object convertType(Object obj, Class<?> cls) {
        Object result = obj;
        if (cls == BigDecimal.class && obj != null) {
            result = new BigDecimal(obj.toString());
        } else if (Date.class == cls && obj instanceof String && obj != null) {
            try {
                Date date = DateUtils.parseDate((String)obj.toString(), (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd"});
            }
            catch (ParseException e) {
                result = obj;
            }
        } else if (obj != null && obj instanceof Date && String.class == cls) {
            Date date = (Date)obj;
            String dateStr = DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
            result = dateStr;
        } else if (obj != null && (cls == Integer.class || cls == Integer.TYPE)) {
            result = Integer.parseInt(obj.toString());
        }
        return result;
    }
}

