/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.base;

import com.irdstudio.sdk.beans.core.base.DataOptionalAuthority;
import com.irdstudio.sdk.beans.core.base.DataOptionalAuthorityDao;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.enums.DataRuleType;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.rpc.service.GenericService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractFrameworkService
implements FrameworkService,
DataOptionalAuthority {
    private static Logger logger = LoggerFactory.getLogger(AbstractFrameworkService.class);
    private static final String SEQUENCE_SERVICE_ID = "sequenceService";
    private static final String PUBSYSINFO_SERVICE_ID = "pubSysInfoService";

    public String getSequence(String seqId) throws Exception {
        return this.getSequence(seqId, null);
    }

    public String getSequence(String seqId, String orgCode) throws Exception {
        return this.getSequence(seqId, orgCode, null);
    }

    public String getSequence(String seqId, String orgCode, String prdCode) throws Exception {
        GenericService gs = (GenericService)SpringContextUtils.getBean(SEQUENCE_SERVICE_ID);
        Object obj = gs.$invoke("getSequence", new String[]{"java.lang.String", "java.lang.String", "java.lang.String"}, new Object[]{seqId, orgCode, prdCode});
        logger.info("SequenceID\uff1a" + seqId + "\u76ee\u524d\u8c03\u7528\u670d\u52a1\u751f\u6210\u7684\u6d41\u6c34\u53f7\u4e3a:" + obj);
        return String.valueOf(obj);
    }

    public String getSequence(String seqId, String orgCode, String prdCode, String legalOrgCode, String areaCode) throws Exception {
        GenericService gs = (GenericService)SpringContextUtils.getBean(SEQUENCE_SERVICE_ID);
        Object obj = gs.$invoke("getSequence", new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"}, new Object[]{seqId, orgCode, prdCode, legalOrgCode, areaCode});
        logger.info("SequenceID\uff1a" + seqId + "\u76ee\u524d\u8c03\u7528\u670d\u52a1\u751f\u6210\u7684\u6d41\u6c34\u53f7\u4e3a:" + obj);
        return String.valueOf(obj);
    }

    public List<String> getSequences(String seqId, int seqNum) throws Exception {
        return this.getSequences(seqId, null, seqNum);
    }

    public List<String> getSequences(String seqId, String orgCode, int seqNum) throws Exception {
        return this.getSequences(seqId, orgCode, null, seqNum);
    }

    public List<String> getSequences(String seqId, String orgCode, String prdCode, String legalOrgCode, String areaCode, int seqNum) throws Exception {
        GenericService gs = (GenericService)SpringContextUtils.getBean(SEQUENCE_SERVICE_ID);
        Object obj = gs.$invoke("getSequences", new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Integer"}, new Object[]{seqId, orgCode, prdCode, legalOrgCode, areaCode, seqNum});
        logger.info("SequenceID\uff1a" + seqId + "\u76ee\u524d\u8c03\u7528\u670d\u52a1\u751f\u6210\u7684\u6d41\u6c34\u53f7\u4e3a:" + obj);
        return (List)obj;
    }

    public List<String> getSequences(String seqId, String orgCode, String prdCode, int seqNum) throws Exception {
        GenericService gs = (GenericService)SpringContextUtils.getBean(SEQUENCE_SERVICE_ID);
        Object obj = gs.$invoke("getSequences", new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Integer"}, new Object[]{seqId, orgCode, prdCode, seqNum});
        logger.info("SequenceID\uff1a" + seqId + "\u76ee\u524d\u8c03\u7528\u670d\u52a1\u751f\u6210\u7684\u6d41\u6c34\u53f7\u4e3a:" + obj);
        return (List)obj;
    }

    public String getOpenday(String sysId) {
        GenericService gs = (GenericService)SpringContextUtils.getBean(PUBSYSINFO_SERVICE_ID);
        Object obj = gs.$invoke("getOpenday", new String[]{"java.lang.String"}, new Object[]{sysId});
        logger.info("\u7cfb\u7edf\u8425\u4e1a\u65e5\u671f\u4e3a\uff1a" + obj);
        return (String)obj;
    }

    public String getOpenday() {
        GenericService gs = (GenericService)SpringContextUtils.getBean(PUBSYSINFO_SERVICE_ID);
        Object obj = gs.$invoke("getOpenday", new String[]{"java.lang.String"}, new Object[]{"1001"});
        logger.info("\u7cfb\u7edf\u8425\u4e1a\u65e5\u671f\u4e3a\uff1a" + obj);
        return (String)obj;
    }

    @Override
    public boolean checkOptionalAuthority(Map<String, String> primaryKey, String dataRule) {
        DataOptionalAuthorityDao dataAuthorityDao = this.getDataAuthorityDao();
        boolean isHave = false;
        if (Objects.nonNull(dataAuthorityDao)) {
            int num = -1;
            DataRuleType dataRuleType = DataRuleType.getDataRuleType(dataRule);
            switch (dataRuleType) {
                case Owner: {
                    num = dataAuthorityDao.getByOwner(primaryKey);
                    break;
                }
                case CurrOrg: {
                    num = dataAuthorityDao.getByCurrOrg(primaryKey);
                    break;
                }
                case CurrDownOrg: {
                    num = dataAuthorityDao.getByCurrDownOrg(primaryKey);
                    break;
                }
                default: {
                    num = -1;
                }
            }
            isHave = num > 0;
        }
        return isHave;
    }

    public DataOptionalAuthorityDao getDataAuthorityDao() {
        return null;
    }
}

