/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import com.irdstudio.sdk.beans.core.util.DateTool;
import com.irdstudio.sdk.beans.core.util.ReflectUtility;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOperateUtil {
    private static Logger logger = LoggerFactory.getLogger(FileOperateUtil.class);
    private static String QUOT_TRAN_SIGN = "<#>";

    public static <T> List<T> readTxt(File file, Class<? extends T> clazz, String operation) throws Exception {
        InputStreamReader reader = null;
        BufferedReader br = null;
        try {
            if (!StringUtil.isNotEmpty(operation)) {
                throw new Exception("\u8bf7\u4f20\u5165\u5206\u9694\u7b26\u53f7");
            }
            reader = new InputStreamReader((InputStream)new FileInputStream(file), "GBK");
            br = new BufferedReader(reader);
            String line = "";
            line = br.readLine();
            ArrayList<T> tList = new ArrayList<T>();
            while (StringUtil.isStrNotEmpty(line)) {
                T object = clazz.newInstance();
                object = FileOperateUtil.setData(object, line, operation);
                tList.add(object);
                line = br.readLine();
            }
            ArrayList<T> arrayList = tList;
            return arrayList;
        }
        catch (UnsupportedEncodingException e) {
            logger.info("The Character Encoding is not supported:" + e);
            throw new Exception("The Character Encoding is not supported:" + e);
        }
        catch (FileNotFoundException e) {
            logger.info("open the file denoted by a specified pathname has failed:" + e);
            throw new Exception("open the file denoted by a specified pathname has failed:" + e);
        }
        catch (IOException e) {
            logger.info("I/O operations has faile:" + e);
            throw new Exception("I/O operations has faile:" + e);
        }
        catch (IllegalArgumentException e) {
            logger.info(" an illegal or inappropriate argument:" + e);
            throw new Exception("an illegal or inappropriate argument:" + e);
        }
        catch (IllegalAccessException e) {
            logger.info(" an illegal or inappropriate access:" + e);
            throw new Exception(" an illegal or inappropriate access:" + e);
        }
        catch (InstantiationException e) {
            logger.info(" an illegal or inappropriate access:" + e);
            throw new Exception(" an illegal or inappropriate access:" + e);
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static <T> byte[] writeTxt(List<T> lists, String operation) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] result = null;
        try {
            if (byteArrayOutputStream == null) {
                byteArrayOutputStream = new ByteArrayOutputStream();
            }
            if (!StringUtil.isNotEmpty(operation)) {
                throw new Exception("\u8bf7\u4f20\u5165\u5206\u9694\u7b26\u53f7");
            }
            for (T t : lists) {
                String outputStr = ToStringBuilder.reflectionToString(t, (ToStringStyle)ToStringStyle.NO_FIELD_NAMES_STYLE);
                outputStr = outputStr.substring(outputStr.indexOf("[") + 1, outputStr.lastIndexOf("]")).replace(",", operation).replace("<null>", "");
                byteArrayOutputStream.write(outputStr.getBytes("GBK"));
                byteArrayOutputStream.write("\r\n".getBytes("GBK"));
            }
            byteArrayOutputStream.flush();
            result = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            Object object = result;
            return object;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.flush();
                    byteArrayOutputStream.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static <T> File writeTxt(String filePath, List<T> lists, String operation) throws Exception {
        OutputStreamWriter out = null;
        OutputStream fos = null;
        File file = null;
        try {
            file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            fos = new FileOutputStream(file);
            out = new OutputStreamWriter(fos, "UTF-8");
            for (T t : lists) {
                String outputStr = new ReflectionToStringBuilder(t, ToStringStyle.NO_FIELD_NAMES_STYLE){

                    protected Object getValue(Field field) throws IllegalArgumentException, IllegalAccessException {
                        if (field.getType().isAssignableFrom(BigDecimal.class)) {
                            Object value = super.getValue(field);
                            if (value != null) {
                                return ((BigDecimal)super.getValue(field)).toPlainString();
                            }
                            return value;
                        }
                        if (field.getType().isAssignableFrom(String.class)) {
                            Object value = super.getValue(field);
                            if (value != null) {
                                String val = (String)value;
                                if (val.contains(",")) {
                                    val = val.replace(",", QUOT_TRAN_SIGN);
                                }
                                return val;
                            }
                            return value;
                        }
                        return super.getValue(field);
                    }
                }.toString();
                outputStr = outputStr.substring(outputStr.indexOf("[") + 1, outputStr.lastIndexOf("]")).replace(",", operation).replace("<null>", "");
                outputStr = outputStr.replace(QUOT_TRAN_SIGN, ",");
                out.write(outputStr);
                out.write("\r\n");
            }
            logger.info("\u6587\u4ef6\u683c\u5f0f" + out.getEncoding());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
            if (fos != null) {
                fos.flush();
                ((FileOutputStream)fos).close();
            }
        }
        return file;
    }

    private static <T> T setData(Object t, String data, String operation) throws IllegalArgumentException, IllegalAccessException, Exception {
        String[] dataArray = data.split("\\" + operation);
        int count = 0;
        for (String str : dataArray) {
            ++count;
            Field[] fields = t.getClass().getDeclaredFields();
            if (!Objects.nonNull(fields) || fields.length <= 0) continue;
            Field field = fields[count];
            t = FileOperateUtil.changeData(t, field, str.trim());
        }
        return (T)t;
    }

    private static Object changeData(Object t, Field field, String data) throws IllegalArgumentException, IllegalAccessException {
        if (field.getGenericType().toString().equals("class java.math.BigDecimal")) {
            if (StringUtil.isNotEmpty(data)) {
                ReflectUtility.setObjectFieldValue(t, field, new BigDecimal(data));
            }
        } else if (field.getGenericType().toString().equals("int") || field.getGenericType().toString().equals("class java.lang.Integer")) {
            ReflectUtility.setObjectFieldValue(t, field, Integer.parseInt(data));
        } else if (field.getGenericType().toString().equals("class java.lang.Long")) {
            ReflectUtility.setObjectFieldValue(t, field, Long.parseLong(data));
        } else if (field.getGenericType().toString().equals("class java.lang.Float")) {
            ReflectUtility.setObjectFieldValue(t, field, Float.valueOf(Float.parseFloat(data)));
        } else if (field.getGenericType().toString().equals("class java.lang.Double")) {
            ReflectUtility.setObjectFieldValue(t, field, Double.parseDouble(data));
        } else if (field.getGenericType().toString().equals("class java.lang.Boolean")) {
            ReflectUtility.setObjectFieldValue(t, field, Boolean.parseBoolean(data));
        } else if (field.getGenericType().toString().equals("java.util.Date")) {
            ReflectUtility.setObjectFieldValue(t, field, DateTool.formatDate(data, "yyyy-MM-dd"));
        } else {
            ReflectUtility.setObjectFieldValue(t, field, data);
        }
        return t;
    }

    public static File compressTar(File[] sources, File target) throws Exception {
        FileOutputStream out = null;
        try {
            if (target.exists()) {
                target.delete();
            }
            target.createNewFile();
            out = new FileOutputStream(target);
        }
        catch (FileNotFoundException e1) {
            logger.info("\u627e\u4e0d\u5230\u6587\u4ef6" + e1);
            throw new Exception("\u4f20\u5165\u7684\u76ee\u6807\u6587\u4ef6target\u4e3a\u7a7a");
        }
        TarArchiveOutputStream os = new TarArchiveOutputStream((OutputStream)out);
        for (File file : sources) {
            try {
                os.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(file));
                FileInputStream fis = new FileInputStream(file);
                IOUtils.copy((InputStream)fis, (OutputStream)os);
                fis.close();
                os.closeArchiveEntry();
            }
            catch (FileNotFoundException e) {
                logger.info("\u627e\u4e0d\u5230\u6587\u4ef6" + e);
                throw new Exception("\u4f20\u5165\u7684\u76ee\u6807\u6587\u4ef6target\u4e3a\u7a7a");
            }
            catch (IOException e) {
                logger.info("IO\u9519\u8bef" + e);
                throw new Exception(e);
            }
        }
        if (os != null) {
            try {
                os.flush();
                os.close();
            }
            catch (IOException e) {
                logger.info("IO\u9519\u8bef" + e);
                throw new Exception(e);
            }
        }
        if (out != null) {
            try {
                out.flush();
                out.close();
            }
            catch (IOException e) {
                logger.info("IO\u9519\u8bef" + e);
                throw new Exception(e);
            }
        }
        return target;
    }
}

