/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.util.ReflectionUtils;

public class POJOUtils {
    private static Logger log = LoggerFactory.getLogger(POJOUtils.class);

    private static String javaFieldName(String dbColName) {
        String[] words = StringUtils.split((String)dbColName, (String)"_");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (i > 0) {
                buffer.append(StringUtils.capitalize((String)word.toLowerCase()));
                continue;
            }
            buffer.append(word.toLowerCase());
        }
        return buffer.toString();
    }

    public static String javaPropToColName(String prop) {
        String regx = "[A-Z]";
        Pattern pattern = Pattern.compile(regx);
        Matcher m = pattern.matcher(prop);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "_" + m.group().toLowerCase());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static List<Object[]> getPOJOValues(Object bean) {
        return POJOUtils.getPOJOValues(bean, false);
    }

    public static List<Object[]> getPOJOValues(Object bean, boolean withNull) {
        Field[] fields;
        if (bean == null) {
            return new ArrayList<Object[]>();
        }
        ArrayList<Object[]> vals = new ArrayList<Object[]>();
        Class<?> cls = bean.getClass();
        for (Field f : fields = cls.getDeclaredFields()) {
            if (f.getName().equals("serialVersionUID")) continue;
            String dbName = POJOUtils.javaPropToColName(f.getName());
            Object val = ReflectionTestUtils.invokeGetterMethod((Object)bean, (String)f.getName());
            if (!withNull && val == null) continue;
            vals.add(new Object[]{dbName, val});
        }
        return vals;
    }

    public static List[] generateInsertInfo(List beans) {
        if (CollectionUtils.isEmpty((Collection)beans)) {
            return null;
        }
        List[] vals = new List[beans.size() + 2];
        if (beans.get(0) == null) {
            return null;
        }
        Class<?> cls = beans.get(0).getClass();
        Field[] fields = cls.getDeclaredFields();
        vals[0] = new ArrayList(fields.length);
        vals[1] = new ArrayList(fields.length);
        for (int i = 0; i < beans.size(); ++i) {
            ArrayList<Object> beanVal;
            Object bean = beans.get(i);
            vals[i + 2] = beanVal = new ArrayList<Object>(fields.length);
            for (Field f : fields) {
                if (f.getName().equals("serialVersionUID")) continue;
                String dbName = POJOUtils.javaPropToColName(f.getName());
                Object val = ReflectionTestUtils.invokeGetterMethod(bean, (String)f.getName());
                if (i == 0) {
                    vals[0].add(dbName);
                    vals[1].add("?");
                }
                beanVal.add(val);
            }
        }
        return vals;
    }

    public static <T> T generatePOJO(ResultSet rs, Class<T> cls) {
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            T t = cls.newInstance();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String colName = metaData.getColumnLabel(i);
                String fieldName = POJOUtils.javaFieldName(colName);
                Object obj = rs.getObject(colName);
                Field field = ReflectionUtils.findField(cls, (String)fieldName);
                if (field == null && (field = ReflectionUtils.findField(cls, (String)colName)) != null) {
                    fieldName = colName;
                }
                if (field == null) continue;
                obj = POJOUtils.convertType(obj, field.getType());
                if (field.getName().startsWith("set")) {
                    fieldName = "set" + StringUtils.capitalize((String)field.getName());
                }
                try {
                    ReflectionTestUtils.invokeSetterMethod(t, (String)fieldName, (Object)obj);
                    continue;
                }
                catch (Exception e) {
                    log.error("{} {} {} {} {}", new Object[]{cls, fieldName, field.getType(), obj, obj == null ? null : obj.getClass()});
                }
            }
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> generateMap(ResultSet rs) {
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String colName = metaData.getColumnLabel(i);
                String fieldName = POJOUtils.javaFieldName(colName);
                Object obj = rs.getObject(colName);
                resultMap.put(colName, obj);
                resultMap.put(fieldName, obj);
            }
            return resultMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Object convertType(Object obj, Class<?> cls) {
        Object result = obj;
        if (cls == BigDecimal.class && obj != null) {
            result = new BigDecimal(obj.toString());
        } else if (Date.class == cls && obj instanceof String && obj != null) {
            try {
                Date date = DateUtils.parseDate((String)obj.toString(), (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd"});
            }
            catch (ParseException e) {
                result = obj;
            }
        } else if (obj != null && obj instanceof Date && String.class == cls) {
            Date date = (Date)obj;
            String dateStr = DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
            result = dateStr;
        } else if (obj != null && (cls == Integer.class || cls == Integer.TYPE)) {
            result = Integer.parseInt(obj.toString());
        }
        return result;
    }
}

