/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import com.irdstudio.sdk.beans.core.util.Base64;
import com.irdstudio.sdk.beans.core.util.CrypticUtility;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public final class RSAUtility {
    public static final String RSA_KEY_ALGORITHM = "RSA";
    public static final String CIPHER_ALGORITHM = "RSA/ECB/PKCS1Padding";
    static Base64.Encoder encoder = java.util.Base64.getEncoder();

    public static final KeyPair getDefaultKeyPair() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(RSA_KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        return keyPairGen.generateKeyPair();
    }

    public static RSAPublicKey getPublicKey(String modulus, String exponent) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(new BigInteger(modulus, 16), new BigInteger(exponent, 16));
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static PublicKey getPublicKey(String key) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decode(key));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        return keyFactory.generatePublic(keySpec);
    }

    public static PrivateKey getPrivateKey(String key) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.decode(key));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        return keyFactory.generatePrivate(keySpec);
    }

    public static String encrypt2hex(String str, Key key) throws Exception {
        return CrypticUtility.byte2hex(RSAUtility.encrypt(str.getBytes("UTF-8"), key));
    }

    public static String encrypt2hex(String str, byte[] key) throws Exception {
        return CrypticUtility.byte2hex(RSAUtility.encrypt(CrypticUtility.getEncByteFromStr(str), key));
    }

    public static String encryptByBase64(String str, String key) throws Exception {
        return new String(encoder.encode(RSAUtility.encrypt(CrypticUtility.getEncByteFromStr(str), RSAUtility.getPublicKey(key))));
    }

    public static String encryptByBase64(String str, Key key) throws Exception {
        return new String(encoder.encode(RSAUtility.encrypt(CrypticUtility.getEncByteFromStr(str), key)));
    }

    public static byte[] encrypt(byte[] str, byte[] encrytKey) throws Exception {
        return RSAUtility.encrypt(str, new SecretKeySpec(encrytKey, CIPHER_ALGORITHM));
    }

    public static byte[] encrypt(byte[] plainText, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, key);
        return cipher.doFinal(plainText);
    }

    public static String decrypt2hex(String str, byte[] key) throws Exception {
        return CrypticUtility.byte2hex(RSAUtility.decrypt(CrypticUtility.getEncByteFromStr(str), key));
    }

    public static byte[] decrypt(byte[] ciperText, byte[] decrytKey) throws Exception {
        return RSAUtility.decrypt(ciperText, new SecretKeySpec(decrytKey, CIPHER_ALGORITHM));
    }

    public static String decrypt2hex(String str, Key key) throws Exception {
        return new String(RSAUtility.decrypt(CrypticUtility.hex2byte(str.getBytes("UTF-8")), key), "UTF-8");
    }

    public static String decryptByBase64(String str, String key) throws Exception {
        return new String(RSAUtility.decrypt(Base64.decode(str), RSAUtility.getPrivateKey(key)), "UTF-8");
    }

    public static String decryptByBase64(String str, Key key) throws Exception {
        return new String(RSAUtility.decrypt(Base64.decode(str), key), "UTF-8");
    }

    public static byte[] decrypt(byte[] ciperText, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_KEY_ALGORITHM);
        cipher.init(2, key);
        return cipher.doFinal(ciperText);
    }

    public static void main(String[] args) throws Exception {
        String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCHDmTC9EMBbR55wuaUfzsSXBnWZQCNLkcmnGIlS6GF6Ln44X7tK90pPdrgGrUUNaznrjQck0KMYpFGHilBkeUF0SH8agHPjUHv+C+I5HiTqNBO7mmkP1tEerLdKGWRXN16e7dW7opoukzq+CuaThcmVaSIDxArvOLokP7/z63J7wIDAQAB";
        String privateKey = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAIcOZML0QwFtHnnC5pR/OxJcGdZlAI0uRyacYiVLoYXoufjhfu0r3Sk92uAatRQ1rOeuNByTQoxikUYeKUGR5QXRIfxqAc+NQe/4L4jkeJOo0E7uaaQ/W0R6st0oZZFc3Xp7t1buimi6TOr4K5pOFyZVpIgPECu84uiQ/v/PrcnvAgMBAAECgYA+6K54vQyFGo3qi6WaIBWk/K+wVQXHvXm4+3kgBDWtyXTvACJ+WUNAVaahYu9cBZCPrm5prRJ/j945eg0flNTHinlH+0ame4pbRJp4b26jmzuv/Vf2ut7fmcS5KfRV5dhxAXb+mKNsLqydRssUSKAp/fou7+M9fZOoT4t3GKc9IQJBAOdxr/76/Fi7Ctqc/woJP8p6qyMxy/xzNAhrJZkz7bZtQHIlahwpGCYaibz0cXXDPR6+YxQLbD2tUpjxrxg+FpECQQCVYrDCsFVpzf5GHvqUNbCvnzeFjCg9fhHEGY10ssKRYNTLNASXQi/3AKjWCyYp+otdhgZNy6LVxMC8Z3WqExh/AkAu7h2a3XfX4i2EQLtyZIe73f3fyBQt34pYfqmEFESKbkLYIoAOr8KGz3DIkOSE1Y8KMd7TTLGpHAEYpEE18DkRAkATMeQukAPZnYtvrSlbg+6ZEmdK9LBy/lEAFpxzg0i2729IUP3KBcot/dqz7ijQOg5QTRlgQ6s/tpFhZBXdbai3AkEAiWn4ubTEG48xViyvf/9iud3dANfuvvBjg0kikCfnddncFGmna0PG9IEF2kP03G6Gowh4w58VX1BFR+Xrn8Ke+g==";
        System.out.println("Please enter your information:");
        InputStreamReader in = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(in);
        String input = bufferedReader.readLine();
        String encryptByBase64Info = RSAUtility.encryptByBase64(input, publicKey);
        System.out.println("EncryptByBase64 information:");
        System.out.println(encryptByBase64Info);
        System.out.println("Please enter your  EncryptByBase64 information:");
        InputStreamReader in1 = new InputStreamReader(System.in);
        BufferedReader bufferedReader1 = new BufferedReader(in1);
        String input1 = bufferedReader1.readLine();
        System.out.println("DecryptByBase64 information:");
        String decryptByBase64Info = RSAUtility.decryptByBase64(input1, privateKey);
        System.out.println(decryptByBase64Info);
    }
}

