/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalExecUtil {
    private static Logger logger = LoggerFactory.getLogger(TerminalExecUtil.class);

    public static boolean isWindows() {
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        return isWindows;
    }

    public static boolean localTerminalExec(File workDir, Consumer<String> consumer, String ... command) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (TerminalExecUtil.isWindows()) {
            String[] newComds = new String[command.length + 2];
            newComds[0] = "cmd.exe";
            newComds[1] = "/C";
            System.arraycopy(command, 0, newComds, 2, command.length);
            builder.command(newComds);
        } else {
            builder.command("bash", "-c", StringUtils.join((Object[])command, (String)" "));
        }
        builder.directory(workDir);
        try {
            Process process = builder.start();
            StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), consumer);
            StreamGobbler errorStreamGobbler = new StreamGobbler(process.getErrorStream(), consumer);
            Executors.newSingleThreadExecutor().submit(streamGobbler);
            Executors.newSingleThreadExecutor().submit(errorStreamGobbler);
            int exitCode = process.waitFor();
            logger.info("\u672c\u5730\u7ec8\u7aef\u6267\u884c\u547d\u4ee4\u8fd4\u56de: " + exitCode + " " + StringUtils.join(builder.command(), (String)" "));
            return exitCode == 0;
        }
        catch (Exception e) {
            logger.error("\u672c\u5730\u7ec8\u7aef\u6267\u884c\u547d\u4ee4\u5f02\u5e38: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream inputStream;
        private Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }
}

