/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.db;

import com.irdstudio.sdk.beans.db.impl.DBImportMysqlImpl;
import com.irdstudio.sdk.beans.db.impl.DBImportOracleImpl;
import com.irdstudio.sdk.beans.db.vo.DBInfoVO;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public interface DBImportPlugin {
    public DBInfoVO readDBInfo(String var1, String var2, String var3);

    default public Connection getDBConnection(String url, String user, String pwd) {
        Connection conn = null;
        try {
            Class.forName(this.getDriverClass());
            StringBuffer connStr = new StringBuffer(url);
            conn = DriverManager.getConnection(connStr.toString(), user, pwd);
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
        return conn;
    }

    public String getDriverClass();

    public static class Factory {
        public static DBImportPlugin getInstance(int dbmsType) {
            switch (dbmsType) {
                case 425: {
                    return new DBImportMysqlImpl();
                }
                case 125: {
                    return new DBImportOracleImpl();
                }
            }
            return null;
        }
    }
}

