/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.db.impl;

import com.irdstudio.sdk.beans.db.DBImportPlugin;
import com.irdstudio.sdk.beans.db.enums.IndexType;
import com.irdstudio.sdk.beans.db.vo.DBImportTableFieldVO;
import com.irdstudio.sdk.beans.db.vo.DBImportTableIndexVO;
import com.irdstudio.sdk.beans.db.vo.DBImportTableVO;
import com.irdstudio.sdk.beans.db.vo.DBInfoVO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBImportMysqlImpl
implements DBImportPlugin {
    Logger logger = LoggerFactory.getLogger(DBImportMysqlImpl.class);

    @Override
    public DBInfoVO readDBInfo(String url, String user, String pwd) {
        Connection conn = null;
        try {
            DBImportTableVO tb;
            conn = this.getDBConnection(url, user, pwd);
            String dbName = this.queryDBName(conn);
            List<DBImportTableVO> tables = this.queryTables(dbName, conn);
            List<DBImportTableFieldVO> fields = this.queryTableFields(dbName, conn);
            List<DBImportTableIndexVO> indexes = this.queryTableIndexes(dbName, conn);
            DBInfoVO db = new DBInfoVO();
            db.setTables(tables);
            HashMap<String, DBImportTableVO> tableMap = new HashMap<String, DBImportTableVO>(tables.size());
            for (DBImportTableVO tb2 : tables) {
                tableMap.put(tb2.getTable_name(), tb2);
                tb2.setFields(new ArrayList<DBImportTableFieldVO>());
                tb2.setIndexes(new ArrayList<DBImportTableIndexVO>());
            }
            for (DBImportTableFieldVO field : fields) {
                tb = (DBImportTableVO)tableMap.get(field.getTable_name());
                if (tb == null) continue;
                tb.getFields().add(field);
            }
            for (DBImportTableIndexVO index : indexes) {
                tb = (DBImportTableVO)tableMap.get(index.getTable_name());
                if (tb == null) continue;
                tb.getIndexes().add(index);
            }
            DBInfoVO dBInfoVO = db;
            return dBInfoVO;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private ResultSet executeSQL(String sql, List param, Connection conn) throws Exception {
        PreparedStatement ps = conn.prepareStatement(sql);
        if (CollectionUtils.isNotEmpty((Collection)param)) {
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
        }
        ResultSet rs = ps.executeQuery();
        return rs;
    }

    private String queryDBName(Connection conn) throws Exception {
        String dbNameSQL = new SQL(){
            {
                this.SELECT("database()");
            }
        }.toString();
        String dbName = null;
        ResultSet rs = this.executeSQL(dbNameSQL, null, conn);
        if (rs.next()) {
            dbName = rs.getString(1);
        }
        rs.close();
        return dbName;
    }

    private List<DBImportTableVO> queryTables(String dbName, Connection conn) throws Exception {
        String sql = new SQL(){
            {
                this.SELECT("table_name, table_comment, table_schema");
                this.FROM("information_schema.tables");
                this.WHERE("table_schema = ?");
            }
        }.toString();
        ResultSet rs = this.executeSQL(sql, Arrays.asList(dbName), conn);
        ArrayList<DBImportTableVO> tables = new ArrayList<DBImportTableVO>();
        while (rs.next()) {
            DBImportTableVO tb = new DBImportTableVO();
            tb.setTable_name(rs.getString(1));
            tb.setTable_comment(rs.getString(2));
            tables.add(tb);
        }
        return tables;
    }

    private List<DBImportTableFieldVO> queryTableFields(String dbName, Connection conn) throws Exception {
        String sql = new SQL(){
            {
                this.SELECT("table_name, column_name, column_default, is_nullable, data_type, column_type, column_comment");
                this.FROM("information_schema.columns");
                this.WHERE("table_schema = ?");
            }
        }.toString();
        ResultSet rs = this.executeSQL(sql, Arrays.asList(dbName), conn);
        ArrayList<DBImportTableFieldVO> fields = new ArrayList<DBImportTableFieldVO>();
        while (rs.next()) {
            DBImportTableFieldVO ff = new DBImportTableFieldVO();
            ff.setTable_name(rs.getString(1));
            ff.setColumn_name(rs.getString(2));
            ff.setColumn_default(rs.getString(3));
            ff.setIs_nullable(rs.getString(4));
            ff.setData_type(rs.getString(5));
            ff.setColumn_type(rs.getString(6));
            ff.setColumn_comment(rs.getString(7));
            fields.add(ff);
        }
        return fields;
    }

    private List<DBImportTableIndexVO> queryTableIndexes(String dbName, Connection conn) throws Exception {
        String sql = new SQL(){
            {
                this.SELECT("table_name, index_name, group_concat(column_name) as columns");
                this.FROM("information_schema.STATISTICS ");
                this.WHERE("table_schema = ?");
                this.GROUP_BY("table_name, index_name");
            }
        }.toString();
        ResultSet rs = this.executeSQL(sql, Arrays.asList(dbName), conn);
        ArrayList<DBImportTableIndexVO> indexes = new ArrayList<DBImportTableIndexVO>();
        while (rs.next()) {
            DBImportTableIndexVO ii = new DBImportTableIndexVO();
            ii.setTable_name(rs.getString(1));
            String indexName = rs.getString(2);
            if (StringUtils.equals((CharSequence)indexName, (CharSequence)"PRIMARY")) {
                ii.setIndex_type(IndexType.Primary.getCode());
                ii.setIndex_name(String.format("PK_%s", ii.getTable_name().toUpperCase()));
            } else {
                ii.setIndex_type(IndexType.Index.getCode());
                ii.setIndex_name(indexName);
            }
            ii.setColumns(rs.getString(3));
            indexes.add(ii);
        }
        return indexes;
    }

    @Override
    public String getDriverClass() {
        return "com.mysql.jdbc.Driver";
    }
}

