/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.db.impl;

import com.irdstudio.sdk.beans.db.DBImportPlugin;
import com.irdstudio.sdk.beans.db.enums.IndexType;
import com.irdstudio.sdk.beans.db.vo.DBImportTableFieldVO;
import com.irdstudio.sdk.beans.db.vo.DBImportTableIndexVO;
import com.irdstudio.sdk.beans.db.vo.DBImportTableVO;
import com.irdstudio.sdk.beans.db.vo.DBInfoVO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBImportOracleImpl
implements DBImportPlugin {
    Logger logger = LoggerFactory.getLogger(DBImportOracleImpl.class);

    @Override
    public String getDriverClass() {
        return "oracle.jdbc.OracleDriver";
    }

    @Override
    public DBInfoVO readDBInfo(String url, String user, String pwd) {
        Connection conn = null;
        try {
            DBImportTableVO tb;
            conn = this.getDBConnection(url, user, pwd);
            List<DBImportTableVO> tables = this.queryTables(conn);
            List<DBImportTableFieldVO> fields = this.queryTableFields(conn);
            List<DBImportTableIndexVO> indexes = this.queryTableIndexes(conn);
            DBInfoVO db = new DBInfoVO();
            db.setTables(tables);
            HashMap<String, DBImportTableVO> tableMap = new HashMap<String, DBImportTableVO>(tables.size());
            for (DBImportTableVO tb2 : tables) {
                tableMap.put(tb2.getTable_name(), tb2);
                tb2.setFields(new ArrayList<DBImportTableFieldVO>());
                tb2.setIndexes(new ArrayList<DBImportTableIndexVO>());
            }
            for (DBImportTableFieldVO field : fields) {
                tb = (DBImportTableVO)tableMap.get(field.getTable_name());
                if (tb == null) continue;
                tb.getFields().add(field);
            }
            for (DBImportTableIndexVO index : indexes) {
                tb = (DBImportTableVO)tableMap.get(index.getTable_name());
                if (tb == null) continue;
                tb.getIndexes().add(index);
            }
            DBInfoVO dBInfoVO = db;
            return dBInfoVO;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private ResultSet executeSQL(String sql, List param, Connection conn) throws Exception {
        PreparedStatement ps = conn.prepareStatement(sql);
        if (CollectionUtils.isNotEmpty((Collection)param)) {
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
        }
        ResultSet rs = ps.executeQuery();
        return rs;
    }

    private List<DBImportTableVO> queryTables(Connection conn) throws Exception {
        String sql = new SQL(){
            {
                this.SELECT("ut.table_name, comments as table_comment");
                this.FROM("user_tables ut left join user_tab_comments utc on ut.table_name = utc.table_name");
            }
        }.toString();
        ResultSet rs = this.executeSQL(sql, null, conn);
        ArrayList<DBImportTableVO> tables = new ArrayList<DBImportTableVO>();
        while (rs.next()) {
            DBImportTableVO tb = new DBImportTableVO();
            tb.setTable_name(rs.getString(1));
            tb.setTable_comment(rs.getString(2));
            tables.add(tb);
        }
        return tables;
    }

    private List<DBImportTableFieldVO> queryTableFields(Connection conn) throws Exception {
        String sql = new SQL(){
            {
                this.SELECT("uc.table_name, uc.column_name, uc.data_default as column_default, uc.nullable as is_nullable, uc.data_type, uc.DATA_LENGTH, uc.DATA_PRECISION, uc.DATA_SCALE, ucc.COMMENTS as column_comment");
                this.FROM("user_tab_columns uc left join user_col_comments ucc on uc.table_name = ucc.table_name and uc.column_name = ucc.column_name");
            }
        }.toString();
        ResultSet rs = this.executeSQL(sql, null, conn);
        ArrayList<DBImportTableFieldVO> fields = new ArrayList<DBImportTableFieldVO>();
        while (rs.next()) {
            DBImportTableFieldVO ff = new DBImportTableFieldVO();
            ff.setTable_name(rs.getString(1));
            ff.setColumn_name(rs.getString(2));
            ff.setColumn_default(rs.getString(3));
            ff.setIs_nullable(rs.getString(4));
            ff.setData_type(rs.getString(5));
            String length = rs.getString(6);
            String precision = rs.getString(7);
            String scale = rs.getString(8);
            if (StringUtils.isNotBlank((CharSequence)precision)) {
                ff.setColumn_type(String.format("%s(%s,%s)", ff.getData_type(), precision, scale));
            } else {
                ff.setColumn_type(String.format("%s(%s)", ff.getData_type(), length));
            }
            ff.setColumn_comment(rs.getString(9));
            fields.add(ff);
        }
        return fields;
    }

    private List<DBImportTableIndexVO> queryTableIndexes(Connection conn) throws Exception {
        String sql = new SQL(){
            {
                this.SELECT("uic.table_name, uic.INDEX_NAME, uc.CONSTRAINT_TYPE, LISTAGG(uic.COLUMN_NAME, ',') within group ( ORDER BY uic.COLUMN_NAME ) as COLUMN_NAMES");
                this.FROM("user_ind_columns uic left join user_constraints uc on uic.table_name = uc.TABLE_NAME and uic.INDEX_NAME = uc.INDEX_NAME");
                this.GROUP_BY("uic.table_name, uc.CONSTRAINT_TYPE, uic.INDEX_NAME");
            }
        }.toString();
        ResultSet rs = this.executeSQL(sql, null, conn);
        ArrayList<DBImportTableIndexVO> indexes = new ArrayList<DBImportTableIndexVO>();
        while (rs.next()) {
            DBImportTableIndexVO ii = new DBImportTableIndexVO();
            ii.setTable_name(rs.getString(1));
            String indexName = rs.getString(2);
            String indexType = rs.getString(3);
            ii.setColumns(rs.getString(4));
            ii.setIndex_name(indexName);
            if (StringUtils.isBlank((CharSequence)indexType)) {
                indexType = indexName.startsWith("PK_") ? "P" : "C";
            }
            if (StringUtils.equals((CharSequence)indexType, (CharSequence)IndexType.Primary.getCode()) && !indexName.startsWith("PK_")) {
                indexType = "C";
            }
            ii.setIndex_type(indexType);
            indexes.add(ii);
        }
        return indexes;
    }
}

