/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.db.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyJdbcUtil {
    private static final Logger logger = LoggerFactory.getLogger(MyJdbcUtil.class);

    public static Statement createStatement(Connection conn) {
        Statement st = null;
        try {
            st = conn.createStatement();
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return st;
    }

    public static PreparedStatement createPrepareStatement(Connection conn, String sql) {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return ps;
    }

    public static void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void close(Connection conn) {
        if (null != conn) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void executeSql(Statement st, String sql) {
        try {
            st.execute(sql);
        }
        catch (SQLException e) {
            logger.error("\u6267\u884cSQL\u9519\u8bef! \n" + sql, (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

