/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.e4a.client.filter;

import com.irdstudio.sdk.beans.core.util.CookiesUtil;
import com.irdstudio.sdk.beans.core.util.GsonUtils;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.e4a.service.facade.E4AService;
import com.irdstudio.sdk.beans.e4a.service.vo.AuthInfoVO;
import com.irdstudio.sdk.beans.ssm.vo.UserInfo;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class E4AFilterCentralized
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(E4AFilterCentralized.class);
    private static String[] passedPaths = null;
    private E4AService e4aService;

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext applicationcontext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
        this.e4aService = (E4AService)applicationcontext.getBean("e4aService", E4AService.class);
        String urls = filterConfig.getInitParameter("allowUrl");
        if (StringUtils.isNotBlank((CharSequence)urls)) {
            passedPaths = urls.split(";");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse rep, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)rep;
        response.setHeader("Content-type", "text/html;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        String requestPath = request.getServletPath();
        AntPathMatcher matcher = new AntPathMatcher();
        if (passedPaths != null) {
            for (String passedPath : passedPaths) {
                boolean flag = matcher.match(passedPath, requestPath);
                if (!flag) continue;
                logger.info("sso client request path '" + requestPath + "'is matched,filter chain will be continued.");
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        AuthInfoVO authInfo = null;
        try {
            String token = request.getHeader("Authorization");
            AuthInfoVO vo = new AuthInfoVO();
            vo.setToken(token);
            vo.setSessionId(CookiesUtil.getCookieValue((HttpServletRequest)request, (String)"ssoclient"));
            vo.setTimestamp(StringUtil.String2Long((String)CookiesUtil.getCookieValue((HttpServletRequest)request, (String)"ssottp")));
            vo.setMd5(CookiesUtil.getCookieValue((HttpServletRequest)request, (String)"ssomd5"));
            authInfo = this.e4aService.valifyToken(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("sso client request token check fail");
            response.setStatus(401);
            ResponseData data = new ResponseData();
            data.createData((Object)false, "-1", "valify token \u9519\u8bef", false);
            String outputmessage = GsonUtils.toJson((Object)data);
            try (PrintWriter rsp = response.getWriter();){
                rsp.write(outputmessage);
            }
            return;
        }
        if (authInfo == null || !authInfo.isCheckToken() || authInfo.getUserInfo() == null || authInfo.getUserInfo().getUserId() == null) {
            logger.info("Token \u6821\u9a8c\u5931\u8d25\uff1a" + authInfo);
            response.setStatus(401);
            ResponseData data = new ResponseData();
            data.createData((Object)false, "-1", "token\u9a8c\u8bc1\u5931\u8d25", false);
            String outputmessage = GsonUtils.toJson((Object)data);
            try (PrintWriter rsp = response.getWriter();){
                rsp.write(outputmessage);
            }
            return;
        }
        logger.info("\u6821\u9a8c\u901a\u8fc7");
        UserInfo cUserInfo = new UserInfo();
        BeanCopier beanCopier = BeanCopier.create(authInfo.getUserInfo().getClass(), cUserInfo.getClass(), (boolean)false);
        beanCopier.copy((Object)authInfo.getUserInfo(), (Object)cUserInfo, null);
        request.getSession().setAttribute("userInfo", (Object)cUserInfo);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

