/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.mail.recv;

import com.irdstudio.sdk.beans.mail.common.MailServerType;
import com.irdstudio.sdk.beans.mail.config.MailConfig;
import com.irdstudio.sdk.beans.mail.recv.ConfigurableMailReceiver;
import javax.mail.Flags;
import jodd.mail.EmailFilter;
import jodd.mail.MailServer;
import jodd.mail.ReceiveMailSession;
import jodd.mail.ReceivedEmail;

public class DefaultMailReceiverImpl
implements ConfigurableMailReceiver {
    private MailConfig config;

    public DefaultMailReceiverImpl(MailConfig config) {
        this.config = config.copy();
    }

    @Override
    public ReceivedEmail[] receiveUnreadEmail(boolean mark, boolean delete) {
        return this.receive(true, mark, delete);
    }

    @Override
    public ReceivedEmail[] receiveAllEmail(boolean mark, boolean delete) {
        return this.receive(false, mark, delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReceivedEmail[] receive(boolean unread, boolean mark, boolean delete) {
        MailServer<ReceiveMailSession> server = this.createServer(this.config);
        try (ReceiveMailSession session = (ReceiveMailSession)server.createSession();){
            EmailFilter seenFilter;
            session.open();
            EmailFilter emailFilter = seenFilter = unread ? EmailFilter.filter().flag(Flags.Flag.SEEN, false) : null;
            ReceivedEmail[] emails = mark && (!delete || this.config.serverType() == MailServerType.POP3) ? session.receiveEmailAndMarkSeen(seenFilter) : (delete ? session.receiveEmailAndDelete(seenFilter) : session.receiveEmail(seenFilter));
            ReceivedEmail[] receivedEmailArray = emails;
            return receivedEmailArray;
        }
    }

    private MailServer<ReceiveMailSession> createServer(MailConfig config) {
        MailConfig local = this.config;
        MailServer.Builder builder = MailServer.create().host(local.serverAddress()).port(local.port().intValue()).ssl(local.ssl().booleanValue()).auth(local.username(), local.password());
        switch (local.serverType()) {
            case POP3: {
                return builder.buildPop3MailServer();
            }
            case IMAP: {
                return builder.buildImapMailServer();
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u4f7f\u7528\u8be5\u7c7b\u578b\u7684Server\u63a5\u6536Mail\uff0c\u7c7b\u578b\uff1a" + (Object)((Object)local.serverType()));
    }

    @Override
    public void setConfig(MailConfig config) {
        this.config = config.copy();
    }
}

