/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.sqlite.utils;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.sdk.beans.core.spring.SpringPropertyUtils;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.FileUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import com.irdstudio.sdk.beans.sqlite.annotation.DBColumnField;
import com.irdstudio.sdk.beans.sqlite.annotation.TableMode;
import com.irdstudio.sdk.beans.sqlite.cache.SqliteCache;
import com.irdstudio.sdk.beans.sqlite.vo.BeanColumnMap;
import com.irdstudio.sdk.beans.sqlite.vo.BeanColumnMaps;
import com.irdstudio.sdk.beans.sqlite.vo.BeanTableMap;
import com.irdstudio.sdk.beans.sqlite.vo.SqliteMaster;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.test.util.ReflectionTestUtils;

public class SqliteUtils {
    private static Logger logger = LoggerFactory.getLogger(SqliteUtils.class);
    @Value(value="${sqlite.db.batch.insert.count}")
    public static int BATCH_INSERT_COUNT = 500;
    private static final String TEMPLATE_FILES_ROOT_PATH = "sqlite/template/";
    private static final String SQLITE_DRIVER = "org.sqlite.JDBC";
    private static final String QUERY_LIST_BYPAGE_TEMPLATE = "query.list.paging.auto.sql.template";
    private static final String QUERY_LIST_TEMPLATE = "query.list.auto.sql.template";
    private static final String INSERT_TEMPLATE = "insert.auto.sql.template";
    private static final String UPDATE_TEMPLATE = "update.auto.sql.template";
    private static final String DETAIL_TEMPLATE = "detail.auto.sql.template";
    private static final String DELETE_TEMPLATE = "delete.auto.sql.template";
    private static final String BATCH_INSERT_TEMPLATE = "batch.insert.auto.sql.template";
    private static final String RS_TO_BEANS_TEMPLATE = "resultset.beans.json.template";
    private static final String RS_TO_BEAN_TEMPLATE = "resultset.bean.json.template";
    private static GroupTemplate groupTemplate;

    private static String getTemplateAll(String templateName, Object bean) {
        Map paramMap = null;
        if (bean != null) {
            paramMap = BeanUtility.beanAll2Map((Object)bean);
        }
        return SqliteUtils.getTemplate(templateName, paramMap);
    }

    private static String getTemplate(String templatePath, Map<String, Object> paramMap) {
        if (Objects.isNull(templatePath)) {
            throw new NullPointerException("\u4f20\u5165\u6a21\u677f\u4e3a\u7a7a\uff01");
        }
        Template template = groupTemplate.getTemplate(templatePath);
        template.binding(paramMap);
        paramMap.keySet().stream().forEach(s -> {
            if (paramMap.get(s) instanceof List) {
                template.binding(s, paramMap.get(s));
            }
        });
        return template.render();
    }

    public static Connection getConnection(String dbName) {
        Connection conn = null;
        String url = "jdbc:sqlite:" + dbName;
        logger.debug("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\uff0curl\uff1a{}", (Object)url);
        try {
            Class.forName(SQLITE_DRIVER);
            conn = DriverManager.getConnection(url);
        }
        catch (ClassNotFoundException e) {
            logger.error("\u83b7\u53d6sqlite\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("\u83b7\u53d6sqlite\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return conn;
    }

    public static String getAutoSql4Insert(BaseInfo baseInfo) throws Exception {
        BeanColumnMaps beanColumnMaps = SqliteUtils.getBeanColumnMaps(baseInfo);
        return SqliteUtils.getTemplateAll(INSERT_TEMPLATE, beanColumnMaps);
    }

    public static String getAutoSql4QueryDetail(BaseInfo baseInfo) throws Exception {
        BeanColumnMaps beanColumnMaps = SqliteUtils.getBeanColumnMaps(baseInfo);
        return SqliteUtils.getTemplateAll(DETAIL_TEMPLATE, beanColumnMaps);
    }

    public static String getAutoSql4QueryList(BaseInfo baseInfo) throws Exception {
        BeanColumnMaps beanColumnMaps = SqliteUtils.getBeanColumnMaps(baseInfo);
        beanColumnMaps.setOrder(baseInfo.getOrder());
        return SqliteUtils.getTemplateAll(QUERY_LIST_TEMPLATE, beanColumnMaps);
    }

    public static String getAutoSql4QueryListByPage(BaseInfo baseInfo) throws Exception {
        BeanColumnMaps beanColumnMaps = SqliteUtils.getBeanColumnMaps(baseInfo);
        baseInfo.checkAndSetPageInfo();
        beanColumnMaps.setLimit(baseInfo.getSize());
        beanColumnMaps.setOffset((baseInfo.getPage() - 1) * baseInfo.getSize());
        beanColumnMaps.setOrder(baseInfo.getOrder());
        return SqliteUtils.getTemplateAll(QUERY_LIST_BYPAGE_TEMPLATE, beanColumnMaps);
    }

    public static String getAutoSql4Update(BaseInfo baseInfo) throws Exception {
        BeanColumnMaps beanColumnMaps = SqliteUtils.getBeanColumnMaps(baseInfo);
        List<BeanColumnMap> mappings = beanColumnMaps.getMappings();
        ArrayList<BeanColumnMap> newMappings = new ArrayList<BeanColumnMap>(mappings.size());
        for (int i = 0; i < mappings.size(); ++i) {
            if (mappings.get(i).getValue() == null) continue;
            newMappings.add(mappings.get(i));
        }
        beanColumnMaps.setMappings(mappings);
        return SqliteUtils.getTemplateAll(UPDATE_TEMPLATE, beanColumnMaps);
    }

    public static String getAutoSql4Delete(BaseInfo baseInfo) throws Exception {
        BeanColumnMaps beanColumnMaps = SqliteUtils.getBeanColumnMaps(baseInfo);
        return SqliteUtils.getTemplateAll(DELETE_TEMPLATE, beanColumnMaps);
    }

    public static String getAutoSql4BatchInsert(List<? extends BaseInfo> baseInfos) throws Exception {
        BeanTableMap beanTableMap = SqliteUtils.getBeanTableMap(baseInfos);
        return SqliteUtils.getTemplateAll(BATCH_INSERT_TEMPLATE, beanTableMap);
    }

    private static Field[] getDomainFields(Class<? extends Object> obj) {
        return obj.getDeclaredFields();
    }

    private static String getGetValueMethodName(String fieldName) {
        byte[] items = fieldName.getBytes();
        items[0] = (byte)((char)items[0] - 97 + 65);
        return "get" + new String(items);
    }

    public static String getConditionNotNull(BaseInfo baseInfo, List<String> ignoreColumns) throws Exception {
        StringBuffer condition = new StringBuffer();
        List<BeanColumnMap> sameBeanColumnMaps = SqliteUtils.getCacheBeanColumnMaps(baseInfo);
        Method method = null;
        Object fieldValue = null;
        for (BeanColumnMap mapping : sameBeanColumnMaps) {
            if (SqliteUtils.isIgnoreColumn(ignoreColumns, mapping.getColumnName()) || (fieldValue = (method = baseInfo.getClass().getMethod(SqliteUtils.getGetValueMethodName(mapping.getBeanMemberName()), new Class[0])).invoke((Object)baseInfo, new Object[0])) == null || "".equals(fieldValue.toString())) continue;
            mapping.setValue(fieldValue.toString());
            if (mapping.isNumber()) {
                condition.append(" AND ").append(mapping.getColumnName()).append(" = ").append(mapping.getValue());
                continue;
            }
            condition.append(" AND ").append(mapping.getColumnName()).append(" = '").append(mapping.getValue()).append("'");
        }
        return condition.toString();
    }

    private static boolean isIgnoreColumn(List<String> ignoreColumns, String columnName) {
        if (ignoreColumns == null || ignoreColumns.size() == 0) {
            return false;
        }
        for (String ignoreColumn : ignoreColumns) {
            if (!ignoreColumn.toLowerCase().equals(columnName.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static BeanColumnMaps getBeanColumnMaps(BaseInfo baseInfo) throws Exception {
        BeanColumnMaps maps = new BeanColumnMaps();
        maps.setTableName(SqliteUtils.getTableName(baseInfo));
        List<BeanColumnMap> list = SqliteUtils.getCacheBeanColumnMaps(baseInfo);
        maps.setMappings(list);
        if (list != null) {
            for (BeanColumnMap fieldMapping : list) {
                fieldMapping.setValue(null);
                fieldMapping.setValueIsNull(true);
                Object fieldValue = ReflectionTestUtils.invokeGetterMethod((Object)baseInfo, (String)fieldMapping.getBeanMemberName());
                fieldMapping.setValue(fieldValue == null ? null : fieldValue.toString());
                fieldMapping.setValueIsNull(fieldValue == null || "".equals(fieldValue.toString()));
            }
        }
        return maps;
    }

    private static BeanTableMap getBeanTableMap(List<? extends BaseInfo> baseInfos) throws Exception {
        BeanTableMap beanTableMap = new BeanTableMap();
        BaseInfo firstBean = baseInfos.get(0);
        beanTableMap.setTableName(SqliteUtils.getTableName(firstBean));
        List<BeanColumnMap> sameBeanColumnMaps = SqliteUtils.getCacheBeanColumnMaps(firstBean);
        ArrayList<BeanColumnMaps> beanColumnMapList = new ArrayList<BeanColumnMaps>();
        BeanColumnMaps beanColumnMaps = null;
        ArrayList<BeanColumnMap> mappings = null;
        Method method = null;
        Object fieldValue = null;
        BeanColumnMap beanColumnMap = null;
        for (BaseInfo baseInfo : baseInfos) {
            beanColumnMaps = new BeanColumnMaps();
            mappings = new ArrayList<BeanColumnMap>();
            for (BeanColumnMap sameBeanColumnMap : sameBeanColumnMaps) {
                beanColumnMap = new BeanColumnMap();
                method = baseInfo.getClass().getMethod(SqliteUtils.getGetValueMethodName(sameBeanColumnMap.getBeanMemberName()), new Class[0]);
                fieldValue = method.invoke((Object)baseInfo, new Object[0]);
                beanColumnMap.setColumnName(sameBeanColumnMap.getColumnName());
                beanColumnMap.setPk(sameBeanColumnMap.isPk());
                beanColumnMap.setNumber(sameBeanColumnMap.isNumber());
                beanColumnMap.setBeanMemberName(sameBeanColumnMap.getBeanMemberName());
                beanColumnMap.setValue(fieldValue == null ? null : fieldValue.toString());
                beanColumnMap.setValueIsNull(fieldValue == null || "".equals(fieldValue.toString()));
                mappings.add(beanColumnMap);
            }
            beanColumnMaps.setMappings(mappings);
            beanColumnMapList.add(beanColumnMaps);
        }
        beanTableMap.setBeanColumnMapList(beanColumnMapList);
        return beanTableMap;
    }

    public static List<BeanColumnMap> getCacheBeanColumnMaps(BaseInfo baseInfo) throws Exception {
        String className = baseInfo.getClass().getSimpleName();
        List<BeanColumnMap> list = SqliteCache.getBeanTableMap(className);
        if (list != null) {
            return list;
        }
        try {
            Field[] fields = SqliteUtils.getDomainFields(baseInfo.getClass());
            DBColumnField df = null;
            BeanColumnMap beanColumnMap = null;
            String fieldName = null;
            String columnName = null;
            boolean isPk = false;
            boolean isNumber = false;
            for (Field field : fields) {
                fieldName = field.getName();
                df = field.getAnnotation(DBColumnField.class);
                if (df == null) continue;
                beanColumnMap = new BeanColumnMap();
                columnName = df.name();
                isPk = df.isPK();
                isNumber = df.isNumber();
                beanColumnMap.setColumnName(columnName);
                beanColumnMap.setPk(isPk);
                beanColumnMap.setNumber(isNumber);
                beanColumnMap.setBeanMemberName(fieldName);
                beanColumnMap.setFieldCls(field.getType());
                if (list == null) {
                    list = new ArrayList<BeanColumnMap>();
                }
                list.add(beanColumnMap);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6JavaBean\u4e0e\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u6620\u5c04\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw e;
        }
        SqliteCache.setBeanTableMap(className, list);
        return list;
    }

    private static String getTableName(BaseInfo baseInfo) {
        TableMode tm = baseInfo.getClass().getAnnotation(TableMode.class);
        return tm == null ? "" : tm.dbName();
    }

    private static <T> T resultSet2Bean(ResultSet rs, T t) throws Exception {
        try {
            List<BeanColumnMap> mappings = SqliteUtils.getCacheBeanColumnMaps((BaseInfo)t);
            Object columnValue = null;
            Object resObj = t.getClass().newInstance();
            if (rs.next()) {
                for (BeanColumnMap mapping : mappings) {
                    columnValue = rs.getObject(mapping.getColumnName());
                    columnValue = SqliteUtils.getColumnTypeValue(columnValue, mapping.getFieldCls());
                    ReflectionTestUtils.invokeSetterMethod(resObj, (String)mapping.getBeanMemberName(), (Object)columnValue);
                }
            } else {
                return null;
            }
            return (T)resObj;
        }
        catch (SQLException e) {
            logger.error("\u7ed3\u679c\u96c6\u8f6cBean\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw e;
        }
    }

    private static Object getColumnTypeValue(Object columnValue, Class<?> typeClass) {
        block0: {
            String value;
            block4: {
                block3: {
                    block2: {
                        block1: {
                            if (columnValue == null) break block0;
                            value = columnValue.toString();
                            if (typeClass != String.class) break block1;
                            columnValue = value;
                            break block0;
                        }
                        if (typeClass != Integer.class) break block2;
                        columnValue = Integer.parseInt(value);
                        break block0;
                    }
                    if (typeClass != BigDecimal.class) break block3;
                    columnValue = new BigDecimal(value);
                    break block0;
                }
                if (typeClass != Long.class) break block4;
                columnValue = Long.parseLong(value);
                break block0;
            }
            if (typeClass != Double.class) break block0;
            columnValue = Double.parseDouble(value);
        }
        return columnValue;
    }

    public static <T> List<T> resultSet2Beans(ResultSet rs, T t) throws Exception {
        try {
            List<BeanColumnMap> sameBeanColumnMaps = SqliteUtils.getCacheBeanColumnMaps((BaseInfo)t);
            Object columnValue = null;
            ArrayList beans = new ArrayList();
            while (rs.next()) {
                Object reObj = t.getClass().newInstance();
                for (BeanColumnMap sameBeanColumnMap : sameBeanColumnMaps) {
                    columnValue = rs.getObject(sameBeanColumnMap.getColumnName());
                    columnValue = SqliteUtils.getColumnTypeValue(columnValue, sameBeanColumnMap.getFieldCls());
                    ReflectionTestUtils.invokeSetterMethod(reObj, (String)sameBeanColumnMap.getBeanMemberName(), (Object)columnValue);
                }
                beans.add(reObj);
            }
            return beans;
        }
        catch (SQLException e) {
            logger.error("\u7ed3\u679c\u96c6\u8f6cBeanList\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw e;
        }
    }

    public static void releaseConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static <T> List<T> autoExecuteQueryList(Connection conn, T t) throws Exception {
        long start = System.currentTimeMillis();
        List<T> beans = SqliteUtils.executeQueryList(conn, SqliteUtils.getAutoSql4QueryList((BaseInfo)t), t);
        logger.debug("\u81ea\u52a8\u67e5\u8be2\u5217\u8868\u8bb0\u5f55\u8017\u65f6(ms)\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return beans;
    }

    public static <T> List<T> autoExecuteQueryListByPage(Connection conn, T t) throws Exception {
        long start = System.currentTimeMillis();
        BaseInfo queryBean = (BaseInfo)t;
        String sql = SqliteUtils.getAutoSql4QueryListByPage(queryBean);
        String querySizeSql = SqliteUtils.getQuerySizeSqlFromByPageSql(sql);
        int size = SqliteUtils.queryListSize(conn, querySizeSql);
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        List<T> beans = SqliteUtils.executeQueryList(conn, sql, t);
        if (beans != null) {
            BaseInfo resultBean = null;
            for (T tt : beans) {
                resultBean = (BaseInfo)tt;
                resultBean.setTotal(size);
            }
        }
        logger.debug("\u81ea\u52a8\u67e5\u8be2\u5217\u8868\u8bb0\u5f55\u8017\u65f6(ms)\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return beans;
    }

    public static <T> List<T> executeQueryListByPage(Connection conn, String sql, T t) throws Exception {
        long start = System.currentTimeMillis();
        String querySizeSql = SqliteUtils.getQuerySizeSqlFromByPageSql(sql);
        int size = SqliteUtils.queryListSize(conn, querySizeSql);
        if (size == 0) {
            return new ArrayList();
        }
        ((BaseInfo)t).setTotal(size);
        List<T> beans = SqliteUtils.executeQueryList(conn, SqliteUtils.fixByPageSql(sql, (BaseInfo)t), t);
        if (beans != null) {
            BaseInfo resultBean = null;
            for (T tt : beans) {
                resultBean = (BaseInfo)tt;
                resultBean.setTotal(size);
            }
        }
        logger.debug("\u81ea\u52a8\u67e5\u8be2\u5217\u8868\u8bb0\u5f55\u8017\u65f6(ms)\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return beans;
    }

    private static String fixByPageSql(String sql, BaseInfo baseInfo) {
        if (sql.toUpperCase().indexOf(" LIMIT ") == -1) {
            baseInfo.checkAndSetPageInfo();
            return sql + " LIMIT " + baseInfo.getSize() + " OFFSET " + (baseInfo.getPage() - 1) * baseInfo.getSize();
        }
        return sql;
    }

    public static String getQuerySizeSqlFromByPageSql(String byPageSql) {
        String querySizeSql = byPageSql.substring(byPageSql.toUpperCase().indexOf("FROM"), byPageSql.length());
        if (querySizeSql.toUpperCase().lastIndexOf(" LIMIT ") != -1) {
            querySizeSql = querySizeSql.substring(0, querySizeSql.toUpperCase().lastIndexOf("LIMIT"));
        }
        return "SELECT count(1) " + querySizeSql;
    }

    public static String getQuerySizeSqlFromConditionSql(String conditionSql) {
        String querySizeSql = conditionSql.substring(conditionSql.toUpperCase().indexOf("FROM"), conditionSql.length());
        return "SELECT count(1) " + querySizeSql;
    }

    public static int queryListSize(Connection conn, String sql) throws Exception {
        logger.debug("\u6267\u884c\u67e5\u8be2\u8bb0\u5f55\u6570sql\uff1a{}", (Object)sql);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            int count = 0;
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                count = rs.getInt(1);
            }
            logger.debug("\u67e5\u8be2\u8bb0\u5f55\u603b\u6570\u4e3a\uff1a{}", (Object)count);
            int n = count;
            return n;
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u67e5\u8be2\u8bb0\u5f55\u6570\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> List<T> executeQueryList(Connection conn, String sql, T t) throws Exception {
        long start = System.currentTimeMillis();
        logger.debug("\u6267\u884c\u67e5\u8be2\u5217\u8868\u8bb0\u5f55sql\uff1a{}", (Object)sql);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            List<T> beans = SqliteUtils.resultSet2Beans(rs, t);
            logger.debug("\u67e5\u8be2\u5217\u8868\u8bb0\u5f55\u7ed3\u679c\uff1a{}", JSONObject.toJSON(beans));
            logger.debug("\u67e5\u8be2\u5217\u8868\u8017\u65f6(ms)\uff1a{}", (Object)(System.currentTimeMillis() - start));
            List<T> list = beans;
            return list;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u5217\u8868\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> T autoExecuteQueryOne(Connection conn, T t) throws Exception {
        long start = System.currentTimeMillis();
        T bean = SqliteUtils.executeQueryOne(conn, SqliteUtils.getAutoSql4QueryDetail((BaseInfo)t), t);
        logger.debug("\u81ea\u52a8\u67e5\u8be2\u5355\u6761\u8bb0\u5f55\u8017\u65f6(ms)\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return bean;
    }

    public static <T> T executeQueryOne(Connection conn, String sql, T t) throws Exception {
        long start = System.currentTimeMillis();
        logger.debug("\u6267\u884c\u67e5\u8be2\u5355\u6761\u8bb0\u5f55sql\uff1a{}", (Object)sql);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            T bean = SqliteUtils.resultSet2Bean(rs, t);
            logger.debug("\u67e5\u8be2\u5355\u6761\u8bb0\u5f55\u7ed3\u679c\uff1a{}", JSONObject.toJSON(bean));
            logger.debug("\u67e5\u8be2\u5355\u6761\u8bb0\u5f55\u8017\u65f6(ms)\uff1a{}", (Object)(System.currentTimeMillis() - start));
            T t2 = bean;
            return t2;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u5217\u8868\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static int autoExecuteInsert(Connection conn, BaseInfo baseInfo) throws Exception {
        long start = System.currentTimeMillis();
        int count = SqliteUtils.executeInsert(conn, SqliteUtils.getAutoSql4Insert(baseInfo));
        logger.debug("\u81ea\u52a8\u6267\u884c\u63d2\u5165\u8017\u65f6(ms)\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return count;
    }

    public static int executeInsert(Connection conn, String sql) throws Exception {
        long start = System.currentTimeMillis();
        logger.debug("\u6267\u884c\u63d2\u5165sql\uff1a{}", (Object)sql);
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            int count = stmt.executeUpdate(sql);
            logger.debug("\u63d2\u5165\u5f71\u54cd\u8bb0\u5f55\u6570\uff1a{}", (Object)count);
            logger.debug("\u6267\u884c\u63d2\u5165\u8017\u65f6(ms)\uff1a{}", (Object)(System.currentTimeMillis() - start));
            int n = count;
            return n;
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u63d2\u5165\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static int executeInsertBatch(Connection conn, List<? extends BaseInfo> list) throws Exception {
        long start = System.currentTimeMillis();
        try {
            int count = 0;
            int totalRecords = list.size();
            int insertTimes = totalRecords % BATCH_INSERT_COUNT == 0 ? totalRecords / BATCH_INSERT_COUNT : totalRecords / BATCH_INSERT_COUNT + 1;
            logger.debug("\u6267\u884c\u6279\u91cf\u63d2\u5165\uff0c\u5355\u4e2a\u6279\u6b21\u63d2\u5165\u6570\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8e\u3010{}\u3011\uff0c\u672c\u6b21\u5f85\u63d2\u5165\u603b\u8bb0\u5f55\u4e3a\u3010{}\u3011\uff0c\u5206\u3010{}\u3011\u4e2a\u6279\u6b21\u63d2\u5165......", new Object[]{BATCH_INSERT_COUNT, totalRecords, insertTimes});
            int toIndex = 0;
            String sql = SqliteUtils.getAutoSql4BatchInsert(list);
            for (int i = 0; i < insertTimes; ++i) {
                logger.debug("\u6267\u884c\u7b2c\u3010{}\u3011\u4e2a\u6279\u6b21\u63d2\u5165......", (Object)(i + 1));
                toIndex = i == insertTimes - 1 ? totalRecords : (i + 1) * BATCH_INSERT_COUNT;
                sql = SqliteUtils.getAutoSql4BatchInsert(list.subList(i * BATCH_INSERT_COUNT, toIndex));
                count += SqliteUtils.executeInsert(conn, sql);
            }
            logger.debug("\u6267\u884c\u6279\u91cf\u63d2\u5165\u603b\u8017\u65f6(ms)\uff1a{}", (Object)(System.currentTimeMillis() - start));
            int n = count;
            return n;
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u6279\u91cf\u63d2\u5165\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw e;
        }
    }

    public static int autoExecuteUpdate(Connection conn, BaseInfo baseInfo) throws Exception {
        long start = System.currentTimeMillis();
        int count = SqliteUtils.executeUpdate(conn, SqliteUtils.getAutoSql4Update(baseInfo));
        logger.debug("\u81ea\u52a8\u6267\u884c\u66f4\u65b0\u8017\u65f6(ms)\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return count;
    }

    public static int executeUpdate(Connection conn, String sql) throws Exception {
        long start = System.currentTimeMillis();
        logger.debug("\u6267\u884c\u66f4\u65b0sql\uff1a{}", (Object)sql);
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            int count = stmt.executeUpdate(sql);
            logger.debug("\u66f4\u65b0\u5f71\u54cd\u8bb0\u5f55\u6570\uff1a{}", (Object)count);
            logger.debug("\u6267\u884c\u66f4\u65b0\u8017\u65f6(ms)\uff1a{}", (Object)(System.currentTimeMillis() - start));
            int n = count;
            return n;
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u66f4\u65b0\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static int autoExecuteDelete(Connection conn, BaseInfo baseInfo) throws Exception {
        long start = System.currentTimeMillis();
        int count = SqliteUtils.executeDelete(conn, SqliteUtils.getAutoSql4Delete(baseInfo));
        logger.debug("\u81ea\u52a8\u6267\u884c\u5220\u9664\u8017\u65f6(ms)\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return count;
    }

    public static int executeDelete(Connection conn, String sql) throws Exception {
        long start = System.currentTimeMillis();
        logger.debug("\u6267\u884c\u5220\u9664sql\uff1a{}", (Object)sql);
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            int count = stmt.executeUpdate(sql);
            logger.debug("\u5220\u9664\u5f71\u54cd\u8bb0\u5f55\u6570\uff1a{}", (Object)count);
            logger.debug("\u6267\u884c\u5220\u9664\u8017\u65f6(ms)\uff1a{}", (Object)(System.currentTimeMillis() - start));
            int n = count;
            return n;
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u5220\u9664\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<SqliteMaster> querySqliteMasterList(Connection conn, String sql) throws Exception {
        ArrayList<SqliteMaster> sqliteMasters = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            SqliteMaster master = null;
            while (rs.next()) {
                master = new SqliteMaster();
                master.setType(rs.getString("type"));
                master.setName(rs.getString("name"));
                master.setTableName(rs.getString("tbl_name"));
                master.setSql(rs.getString("sql"));
                if (sqliteMasters == null) {
                    sqliteMasters = new ArrayList<SqliteMaster>();
                }
                sqliteMasters.add(master);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u5217\u8868\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return sqliteMasters;
    }

    public static void copyDbFile(String sqliteDbPath, String srcAppId, String targetAppId, String[] keepDataTables) throws Exception {
        List<SqliteMaster> sqliteMasters;
        String sql;
        Connection conn;
        block7: {
            conn = null;
            String dbFilePath = sqliteDbPath.replaceAll("//", "");
            SqliteCache.loadDbFilePath(dbFilePath);
            String srcFileName = null;
            srcFileName = srcAppId == null || "".equals(srcAppId) ? SqliteCache.getDefaultSrcDbfilePath() : SqliteCache.getDbFilePathByAppIdFromMap(srcAppId);
            if (srcFileName == null || "".equals(srcFileName)) {
                throw new Exception("\u627e\u4e0d\u5230\u590d\u5236\u6e90\uff0c\u65e0\u6cd5\u5b8c\u6210\u590d\u5236\uff01");
            }
            String targetFileName = dbFilePath + targetAppId + SqliteCache.DB_FILE_POSTFIX;
            logger.debug("\u590d\u5236\u6570\u636e\u5e93\u6587\u4ef6{}\u5230{}......", (Object)srcFileName, (Object)targetFileName);
            FileUtil.byteCopyFile((File)new File(srcFileName), (String)targetFileName);
            SqliteCache.setToExistsDb(targetAppId, targetFileName);
            conn = SqliteUtils.getConnection(sqliteDbPath + targetAppId + SqliteCache.DB_FILE_POSTFIX);
            sql = "SELECT * FROM sqlite_master WHERE type = 'table'";
            sqliteMasters = SqliteUtils.querySqliteMasterList(conn, sql);
            if (sqliteMasters != null && sqliteMasters.size() != 0) break block7;
            SqliteUtils.releaseConnection(conn);
            return;
        }
        try {
            sql = "DELETE FROM ";
            for (SqliteMaster master : sqliteMasters) {
                if (SqliteUtils.tableNeedKeepData(keepDataTables, master.getTableName())) continue;
                SqliteUtils.executeDelete(conn, sql + master.getTableName());
            }
        }
        catch (Exception e) {
            try {
                logger.error("\u590d\u5236\u6570\u636e\u5e93\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                SqliteUtils.releaseConnection(conn);
                throw throwable;
            }
        }
        SqliteUtils.releaseConnection(conn);
    }

    private static boolean tableNeedKeepData(String[] keepDataTables, String curTableName) {
        if (keepDataTables == null || keepDataTables.length == 0) {
            return false;
        }
        for (String keepDataTableName : keepDataTables) {
            if (!keepDataTableName.toLowerCase().equals(curTableName.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    static {
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader(TEMPLATE_FILES_ROOT_PATH);
        Configuration cfg = null;
        try {
            cfg = Configuration.defaultConfiguration();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        groupTemplate = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
        BATCH_INSERT_COUNT = Integer.valueOf(SpringPropertyUtils.getProperty((String)"sqlite.db.batch.insert.count", (String)"500"));
    }
}

