(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.FilterParamsPop = {
        props: {
            modelValue: Object,
            disabled: Boolean,
            filterConfig: Array
        },
        emits: ['update:modelValue', 'filter'],
        data(){
            return {
                visible: false,

            }
        },
        methods: {
            filterDialog() {
                this.visible = true
            },
            reset() {
                const self = this;
                if (this.filterConfig && this.filterConfig.length > 0) {
                    this.filterConfig.forEach(el=>{
                        self.queryParams[el.key] = undefined
                    })
                }
                this.$emit('reset');
                this.closePop();
            },
            closePop() {
                this.visible = false;
            },
            doFilter() {
                this.$emit('filter', this.queryParams);
                this.visible = false;
            },
            _clickOutsideFunc: _.debounce(function(event){
                try {
                    if (this.$refs.popRef.popperRef.triggerRef.contains(event.target) || this.$refs.popRef.popperRef.contentRef.contains(event.target)) {
                        return ;
                    } {
                        this.closePop();
                    }
                } catch(e) {
                    console.error(e);
                }
            }, 100)
        },
        computed:{
            queryParams: {
                get() {
                    return this.modelValue || {}
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
            displayCount() {
                const self = this;
                let count = 0
                const list = this.filterConfig || []
                if (!self.queryParams) return count;
                list.forEach(function(el) {
                    if (self.queryParams && !!self.queryParams[el.key]) {
                        count++;
                    }
                })
                return count
            },
        },
        mounted() {
            $('body').on('click', this._clickOutsideFunc)
        },
        unmounted() {
            $('body').off('click', this._clickOutsideFunc)
        },
        template: `
<el-popover ref="popRef" placement="bottom-start" :width="400" trigger="click" :visible="visible" >
    <template #reference>
        <el-button class="button" icon="Filter" text size="small" @click="filterDialog">更多筛选 <span class="filter-btn-suffix">{{displayCount}}</span> </el-button>
    </template>
    <el-form :show-message="true" label-position="top" style="margin-bottom:0px;">
        <el-row>
            <el-col v-for="(f, index) in filterConfig" :key="index" >
                <el-form-item  :label="f.name" style="margin-bottom: 2px;">
                    <template v-if="f.type == 'select'">
                        <combobox v-model="queryParams[f.key]" style="width:100%"  :placeholder="f.name" :op-type="f.opType" :disabled="disabled" ></combobox>
                    </template>
                    <template v-else-if="f.type == 'userCombobox'">
                        <user-combobox v-model="queryParams[f.key]" style="width:100%"  :placeholder="f.name" :op-type="f.opType" :disabled="disabled" ></user-combobox>
                    </template>
                    <template v-else-if="f.type == 'datetime'">
                        <own-date-picker  :disabled="disabled" placeholder="待选择"  style="width:100%"
                                v-model="queryParams[f.key]" 
                                type="datetime"
                                :format="f.format || 'YYYY-MM-DD hh:mm:ss'"
                                :value-format="f.format || 'YYYY-MM-DD hh:mm:ss'"
                        ></own-date-picker>
                    </template>
                    <template v-else-if="f.type == 'date'">
                        <own-date-picker  :disabled="disabled" placeholder="待选择"  style="width:100%"
                                v-model="queryParams[f.key]" 
                                type="date"
                                :format="f.format || 'YYYY-MM-DD'"
                                :value-format="f.format || 'YYYY-MM-DD'"
                        ></own-date-picker>
                    </template>
                    <template v-else>
                        <el-input v-model="queryParams[f.key]" :disabled="disabled"  placeholder="待输入"></el-input>
                    </template>
                </el-form-item>
            </el-col>
            <el-col style="text-align: right; margin: 10px 0px; display: flex; justify-content: space-between;">
                <div>
                    <el-button type="info" plain icon="RefreshLeft" size="small" @click="reset" >重置</el-button>
                </div>
                <div>
                    <el-button type="default" icon="Close" size="small" @click="closePop" >关闭</el-button>
                    <el-button type="primary" icon="Check" size="small" @click="doFilter" :disabled="disabled">筛选</el-button>
                </div>
            </el-col>
        </el-row>
    </el-form>
</el-popover>
        `
    }
}));
