(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.TreeContainer = {
        props: {
            nodeKey: String,
            defaultActive: String,
            activeFirst: Boolean,
            mode: {
                type: String,
                default: 'page'
            },
            tabsType: {
                type: String,
                default: 'border-card'
            },
            navMode: {
                type: String,
                default: 'menu'
            },
            hideAside: {
                type: Boolean,
                default: false
            },
            offset: {
                type: Number,
                default: 5
            },
            asideOffset: {
                type: Number,
                default: 0
            },
            menuData: Array,
            defaultOpeneds: Array,
            expandAll: {
                type: Boolean,
                default: true
            },
            showLogo: Boolean,
            showTop: Boolean,
            topTitle: {
                type: String,
                default: ()=>undefined
            },
            tabClass: [Array, Object],
            uniqueOpened: {
                type: Boolean,
                default: false
            },
            combineView: {
                type: Boolean,
                default: false,
            }
        },
        emits: ['collapse', 'open', 'close', 'select', 'change'],
        data(){
            return {
                collapse: false,
                activeName: '',
                tabs: [],
                windowHeight: 0,
                refresh: true,

                defaultActiveLocal: '',

                componentRefresh: false,

                tooHigh: false,
                tooHighHandleFlag: false,
            }
        },
        watch: {
            "expandedAllKeys": {
                handler: function(val) {
                    this.refreshTree();
                    if (this.tooHighHandleFlag) {
                        this.tooHighHandleFlag =  false;
                    }
                }
            },
            "defaultActive": {
                handler:function(val) {
                    this.defaultActiveLocal = val;
                },
                immediate: true
            },
            "activeName": {
                handler:function(val, oldVal) {
                    if(val !== oldVal) {
                        this.componentRefresh = true;
                        this.$nextTick(()=>this.componentRefresh=false);
                    }
                }
            },
        },
        methods: {
            handleMenuCollect() {
                this.$nextTick(()=>{
                    // 获取滚动条的高度
                    const wrapRef = this.$refs.scrollbarRef.wrapRef;
                    if (wrapRef && !this.tooHighHandleFlag) {
                        const windowHeight = window.innerHeight;
                        const menuHeight = $(wrapRef).find('.el-scrollbar__view').height();

                        if ( ( windowHeight - menuHeight - 50) < 0 ) {
                            this.tooHigh = true;
                            this.refreshTree();
                        } else {
                            this.tooHigh = false;
                        }
                        this.tooHighHandleFlag = true
                    }
                })
            },
            refreshTree() {
                this.refresh = false;
                this.$nextTick(()=>{
                    this.refresh = true;
                    this.handleMenuCollect();
                })
            },
            makeAsideCollect() {
                if (this.$refs.treeMenuRef) {
                    this.$refs.treeMenuRef.makeCollect();
                } else {
                    setTimeout(this.makeAsideCollect, 50)
                }
            },
            handlerCollapse(val) {
                this.collapse = val
                // 处理菜单收缩再展开展示层级不是默认展示修正
                if (this.$refs.treeMenuRef &&  this.$refs.treeMenuRef.open && !val && !this.combineView) {
                    this.expandedAllKeys.forEach(el=>this.$refs.treeMenuRef.open(el))
                }
                this.$emit('collapse', val)
            },
            handleSelect(item, key, keyPath, parents) {
                this.$emit('select', item, key, keyPath, parents)
            },
            handleOpen(item, key, keyPath, parents) {
                this.$emit('open', item, key, keyPath, parents)
            },
            handleClose(item, key, keyPath, parents) {
                this.$emit('close', item, key, keyPath, parents)
            },
            handleContextMenu(item, key, event) {
                this.$emit('contextMenu', item, key, event)
            },
            handleNodeClick(data, node) {
                function getAllText(node) {
                    var text = [] ;
                    var parent = node.parent;
                    while(parent) {
                        text.push(parent.data) ;
                        parent = parent.parent;
                    }
                    text = text.reverse();
                    text.splice(0, 1)
                    return text;
                }
                const parents = getAllText(node);
                this.handleSelect(data, null, null, parents);
            },
            handleNodeContextmenu(event, data, node) {
                this.$emit('contextMenu', data, null, event)
            },
            addTab(title, url, closable = true,  type='url', callback, componentParams) {
                const tabIndex = this.tabs.findIndex(function(el){ return el.name == title});
                if (url) {
                    if (url.lastIndexOf('?') < 0) {
                        url += '?' ;
                    }
                    if (url.lastIndexOf('winTitle') < 0) {
                        url += '&winTitle=' + encodeURIComponent(title)
                    }
                }
                if (tabIndex >= 0) {
                    this.activeName = title
                } else if (type == 'url'){
                    if (this.windowHeight === 0) {
                        this.getWindowSize();
                    }
                    this.tabs.push({
                        name: title,
                        url: url,
                        closable: closable,
                        type: type
                    })
                    this.activeName = title;
                    setTimeout(()=>{
                        // 将点击事件在本window document触发
                        window.frames[window.frames.length -1].document.addEventListener('mousedown', (e)=>{
                            window.top.document.dispatchEvent(new MouseEvent('mousedown', { target: e.target }))
                        })
                    }, 50)
                } else if (type == 'component'){
                    let jsUrl = url, componentName = '', params = {};
                    if (jsUrl.lastIndexOf('?') >= 0) {
                        const searchParams = jsUrl.substring(jsUrl.lastIndexOf('?'))
                        var arr = searchParams.substring(1).split('&');
                        for (var i=0; i<arr.length ; i++) {
                            var kv = arr[i].split('=');
                            if (kv && kv.length == 2) {
                                params[kv[0]] = decodeURIComponent(kv[1])
                            }
                        }
                        componentName = jsUrl.substring(jsUrl.lastIndexOf('/') + 1, jsUrl.lastIndexOf('?'))
                    } else {
                        componentName = jsUrl.substring(jsUrl.lastIndexOf('/') + 1)
                    }
                    componentName = componentName.replace('.js', '')
                    const renderCompFunc = ()=>{
                        app.component(componentName, CardComponents[componentName])
                        this.tabs.push({
                            name: title,
                            url: componentName,
                            type: type,
                            closable: closable,
                            params: componentParams || params
                        })
                        this.activeName = title;
                        if(callback) {
                            callback(true);
                        }
                    }
                    if (CardComponents[componentName]) {
                        renderCompFunc()
                    } else {
                        loadjs(jsUrl, renderCompFunc);
                    }

                }
            },
            closeTab(name) {
                const tabIndex = this.tabs.findIndex(function(el){ return el.name == name});
                if (tabIndex >= 0) {
                    this.tabs.splice(tabIndex, 1)
                    if (this.tabs[tabIndex]) {
                        this.activeName = this.tabs[tabIndex].name
                    } else if (this.tabs[tabIndex - 1]) {
                        this.activeName = this.tabs[tabIndex - 1].name
                    } else if (this.tabs.length > 0) {
                        this.activeName = this.tabs[this.tabs.length - 1].name
                    } else {
                        this.activeName = '';
                    }
                }
            },
            clearTab(){
                this.tabs.splice(0, this.tabs.length) ;
            },
            itemChangeHandler() {
                this.$emit.apply(this, ["change", ...arguments ]);
            },
            getWindowSize: _.debounce(function() {
                let height = window.innerHeight ;
                this.windowHeight = height;
            }, 150),

            activeMenu(findFunc=(node)=>false) {
                function findResource(findFunc, node) {
                    if (findFunc(node)) {
                        return node;
                    }
                    if (node.children && node.children.length > 0) {
                        let re = undefined;
                        node.children.forEach(el=>{
                            let findRe = findResource(findFunc, el);
                            if (findRe) {
                                re = findRe;
                                return false;
                            }
                        })
                        if (re) {
                            return re;
                        }
                    }
                }
                let targetNode = undefined;
                this.menuData.forEach(el=>{
                    let re = findResource(findFunc, el);
                    if (re) {
                        targetNode = re;
                        return false
                    }
                })
                if (targetNode) {
                    this.defaultActiveLocal = targetNode.menuKey
                    this.refreshTree();
                    setTimeout(()=>{
                        // 打开页面
                        this.handleSelect(targetNode, targetNode.menuKey)
                    }, 50)
                }
                return targetNode
            },
            parseQueryParam() {
                var r = window.location.search.substring(1);
                if (r != null) {
                    var arr = r.split('&'), params = {};
                    for (var i=0; i<arr.length ; i++) {
                        var kv = arr[i].split('=');
                        if (kv && kv.length == 2) {
                            params[kv[0]] = decodeURI(kv[1])
                        }
                    }
                    return params;
                }
                return {};
            },
        },
        provide() {
            return {
                searchParams : this.parseQueryParam(),
                windowHeight : vue.computed(()=>this.windowHeight),
            }
        },
        computed:{
            asideWidth() {
                return this.collapse ? '56px' : '220px'
            },
            pageItem() {
                const { activeName, tabs} = this;
                const item = tabs.find(function(el){ return el.name == activeName});
                return item;
            },
            defaultProps() {
                return {
                    children: 'children',
                    label: 'text',
                }
            },
            heightOffset() {
                return this.offset
            },
            expandedAllKeys() {
                const self = this;
                const { navMode, nodeKey } = self;
                if (!self.expandAll || !self.menuData) {
                    return self.defaultOpeneds || []
                }
                const openeds = [];
                // 递归初始化展开目录 有子节点的就展开
                function recursionMenu(child, prefix, index, openeds) {
                    if (child.children && child.children.length > 0) {
                        openeds.push(navMode === 'tree' ? child[nodeKey] : `${prefix}${index}` )
                        child.children.forEach(function(elChild, cIdx){
                            recursionMenu(elChild, `${prefix}${index}-`, cIdx, openeds)
                        })
                    }
                }
                self.menuData.forEach(function(el, index){
                    recursionMenu(el, "", index, openeds)
                })
                return openeds;
            },
            subsName() {
                const urlParams = this.parseQueryParam();
                return urlParams.subsName || ''
            },
            userName() {
                let singUserName = '';
                try {
                    signUserName = $.cookie('signUserName') ? Base64.decode($.cookie('signUserName').replace(' ', '+')) : signUserId ;
                } catch(e){
                    console.error(e)
                }
                return signUserName
            },
            asideStyle() {
                return { height: (this.windowHeight - this.asideOffset) == 0 ? '100%': (this.windowHeight - this.asideOffset) }
            }

        },
        mounted() {

            let self = this;
            $(window).on('resize', self.getWindowSize)
            self.getWindowSize();

        },
        unmounted() {

            $(window).off('resize', this.getWindowSize)
        },
        template: `
<el-container style="height: auto; 
--tree-container-tabs-left-border: none;--tree-container-tabs-top-border: 1px;">
    <el-aside :width="asideWidth" style="height: 100%; --el-menu-bg-color: #FFF; background: #FFF; " :style="asideStyle" v-if="!hideAside">
        <el-scrollbar ref="scrollbarRef">
             <tree-menu :collapse="collapse" :data="menuData" v-if="navMode == 'menu' && refresh" ref="treeMenuRef"
                :show-logo="showLogo"
                :show-icon="true"
                :top-title="topTitle"
                :unique-opened="uniqueOpened"
                :active-first="activeFirst"
                :default-active="defaultActiveLocal"
                :default-openeds="tooHigh ? [] :expandedAllKeys" 
                :combine-view="combineView"
                @select="handleSelect"
                @open="handleOpen"
                @close="handleClose"
                @collapse="handlerCollapse" 
                @context-menu="handleContextMenu"
               ></tree-menu>
               <el-tree class="tree-mode-tree" :data="menuData" :props="defaultProps"  v-if="navMode == 'tree' && refresh" 
                    :default-expanded-keys="expandedAllKeys" :default-expand-all="expandAll" :node-key="nodeKey" highlight-current :current-node-key="activeFirst"
                    @node-click="handleNodeClick" 
                    @node-contextmenu="handleNodeContextmenu" 
                    >
                   <template #default="{ node, data }">
                        <el-icon><i class="icon iconfont" :class="[ data.iconCls || data.icon || 'icon-yingyong']" /></el-icon>
                        <span>{{ data.text }}</span>
                   </template>
               </el-tree>
        </el-scrollbar>
    </el-aside>
    <el-main class="tree-main">
        <template v-if="showTop">
            <div class="tree-container-show-top">
                <div>{{subsName}}</div>
                <div>{{userName}}</div>
            </div>
        </template>
        <template v-if="mode == 'tabs'">
            <el-tabs v-model="activeName" class="tree-tabs" :type="tabsType" :class="tabClass" @tab-remove="closeTab" style="border-left: var(--tree-container-tabs-left-border);border-top-width: var(--tree-container-tabs-top-border);" >
                <el-tab-pane
                        v-for="item in tabs"
                        :key="item.name"
                        :label="item.name"
                        :name="item.name"
                        :closable="item.closable"
                >
                    <template v-if="item.type== 'url'">
                        <el-row>
                            <el-col :span="24" :style="{ height: windowHeight - 71 - heightOffset + 5 }">
                                <iframe scrolling="auto" frameborder="0" :src="item.url" :ref="pageItem.name" style="width:100%;height:100%;"></iframe>
                            </el-col>
                        </el-row>
                    </template>
                    <template v-else>
                        <el-row>
                            <el-col :span="24" >
                                <component :is="item.url" :ref="item.name" :params="item.params" v-bind="item.params" @change="itemChangeHandler"></component>
                            </el-col>
                        </el-row>
                    </template>
                </el-tab-pane>
            </el-tabs>
        </template>
        <template v-else-if="mode == 'list'">
            <div v-for="item in tabs" >
                    <template v-if="item.type== 'url'">
                        <el-row>
                            <el-col :span="24" :style="{ height: windowHeight - 65 - heightOffset + 5 }">
                                <iframe scrolling="auto" frameborder="0" :src="item.url" style="width:100%;height:100%;"></iframe>
                            </el-col>
                        </el-row>
                    </template>
                    <template v-else>
                        <el-row>
                            <el-col :span="24" >
                                <component :is="item.url" :ref="item.name"  :params="item.params" v-bind="item.params" @change="itemChangeHandler"></component>
                            </el-col>
                        </el-row>
                    </template>
            </div>
        </template>
        <template v-else-if="pageItem">
            <template v-if="pageItem.type== 'url'">
                <el-row>
                    <el-col :span="24" :style="{ height: windowHeight - heightOffset - 30 }">
                        <iframe scrolling="auto" frameborder="0" :src="pageItem.url" style="width:100%;height:100%;" :ref="pageItem.name"></iframe>
                    </el-col>
                </el-row>
            </template>
            <template v-else>
                <el-row>
                    <el-col :span="24" >
                        <component v-if="!componentRefresh" :ref="pageItem.name" :is="pageItem.url" :params="pageItem.params" v-bind="pageItem.params" @change="itemChangeHandler"></component>
                    </el-col>
                </el-row>
            </template>
        </template>
        
    </el-main>
</el-container>
        `
    }
}));
