const getShapeStyleFuction = (style, properties) => {
    if (properties.backgroundColor) {
        style.fill = properties.backgroundColor
    }
    if (properties.gradientColor && style.fill !== properties.gradientColor) {
        style.fillGradient = properties.gradientColor
    }
    if (properties.borderColor) {
        style.stroke = properties.borderColor
    }
    if (properties.borderWidth) {
        style.strokeWidth = properties.borderWidth
    }
    if (properties.borderStyle) {
        if (properties.borderStyle === 'solid') {
            style.strokeDashArray = '0'
            // nodeResize里的bug导致的,array小写了
            style.strokeDasharray = '0'
        }
        if (properties.borderStyle === 'dashed') {
            style.strokeDashArray = '3 3'
            style.strokeDasharray = '3 3'
        }
        if (properties.borderStyle === 'dotted') {
            style.strokeDashArray = '1 1'
            style.strokeDasharray = '1 1'
        }
        if (properties.borderStyle === 'hidden') {
            style.stroke = style.fill
        }
    }
    return style
}

const getTextStyleFunction = (style = {}, properties) => {
    if (properties.fontColor) {
        style.color = properties.fontColor
    }
    if (properties.fontSize) {
        style.fontSize = properties.fontSize
    }
    if (properties.fontFamily) {
        style.fontFamily = properties.fontFamily
    }
    if (properties.lineHeight) {
        style.lineHeight = properties.lineHeight
    }
    if (properties.textAlign) {
        style.textAlign = properties.textAlign
    }
    if (properties.fontWeight) {
        style.fontWeight = properties.fontWeight
    }
    if (properties.textDecoration) {
        style.textDecoration = properties.textDecoration
    }
    if (properties.fontStyle) {
        style.fontStyle = properties.fontStyle
    }
    return style
}

class BaseNewNode extends BaseNode {
}

class BaseNewModel extends BaseNodeModel {
    setAttributes () {
        this.fill = 'red'
    }
}

var BaseNode = {
    type: 'BaseNode',
    view: BaseNewNode,
    model: BaseNewModel
}


// 矩形
class RectNewModel extends RectResize.model {

    setToBottom () {
        this.zIndex = 0
    }

    getNodeStyle () {
        const style = super.getNodeStyle()
        const properties = this.getProperties()
        return getShapeStyleFuction(style, properties)
    }

    getTextStyle () {
        const style = super.getTextStyle()
        style.overflowMode = 'autoWrap'
        const properties = this.getProperties()
        return getTextStyleFunction(style, properties)
    }
}

var RectNode = {
    type: 'pro-rect',
    view: RectResize.view,
    model: RectNewModel
}

// 下箭头
class DownArrowModel extends RectNode.model {
    initNodeData(data) {
        super.initNodeData(data)
        this.width = 50
        this.height = 80
    }
}
class DownArrowView extends RectNode.view {
    getResizeShape() {
        const { x, y, width, height } = this.props.model
        const style = this.props.model.getNodeStyle()
        const ArrowWidth =  1/3 * width;
        const upY = y - 1/2 * height;
        const downY = y + 1/2 * height;
        const downY2 = y + 1/5 * height;
        const attrs = {
            ...style,
            x,
            y,
            width,
            height,
            points: [
                [x - 1/2 * ArrowWidth, downY2],
                [x - 1/2 * width, downY2],
                [x, downY],
                [x + 1/2 * width, downY2],
                [x + 1/2 * ArrowWidth, downY2],
                [x + 1/2 * ArrowWidth, upY],
                [x - 1/2 * ArrowWidth, upY],
            ]
        }

        return h('g', {}, [
                h('polygon', { ...attrs })
            ]
        );
    }
}

var DownArrowNode =  {
    type: 'down-arrow',
    view: DownArrowView,
    model: DownArrowModel
}


// 左箭头
class LeftArrowModel extends RectNode.model {
    initNodeData(data) {
        super.initNodeData(data)
        this.width = 80
        this.height = 50
    }
}
class LeftArrowView extends RectNode.view {
    getResizeShape() {
        const { x, y, width, height } = this.props.model
        const style = this.props.model.getNodeStyle()
        const ArrowHeight =  1/3 * height;
        const leftX = x - 1/2 * width;
        const leftX2 = x - 1/5 * width;
        const rightX = x + 1/2 * width;
        const attrs = {
            ...style,
            x,
            y,
            width,
            height,
            points: [
                [leftX2, y - 1/2 * ArrowHeight],
                [leftX2, y - 1/2 * height],
                [leftX, y],
                [leftX2, y + 1/2 * height],
                [leftX2, y + 1/2 * ArrowHeight],
                [rightX, y + 1/2 * ArrowHeight],
                [rightX, y - 1/2 * ArrowHeight],
            ]
        }

        return h('g', {}, [
                h('polygon', { ...attrs })
            ]
        );
    }
}

var LeftArrowNode = {
    type: 'left-arrow',
    view: LeftArrowView,
    model: LeftArrowModel
}

// 右箭头
class RightArrowModel extends RectNode.model {
    initNodeData(data) {
        super.initNodeData(data)
        this.width = 80
        this.height = 50
    }
}

class RightArrowView extends RectNode.view {
    getResizeShape() {
        const { x, y, width, height } = this.props.model
        const style = this.props.model.getNodeStyle()
        const ArrowHeight =  1/3 * height;
        const leftX = x - 1/2 * width;
        const rightX = x + 1/2 * width;
        const rightX2 = x + 1/5 * width;
        const attrs = {
            ...style,
            x,
            y,
            width,
            height,
            points: [
                [rightX2, y - 1/2 * ArrowHeight],
                [rightX2, y - 1/2 * height],
                [rightX, y],
                [rightX2, y + 1/2 * height],
                [rightX2, y + 1/2 * ArrowHeight],
                [leftX, y + 1/2 * ArrowHeight],
                [leftX, y - 1/2 * ArrowHeight],
            ]
        }

        return h('g', {}, [
                h('polygon', { ...attrs })
            ]
        );
    }
}

var RightArrowNode = {
    type: 'right-arrow',
    view: RightArrowView,
    model: RightArrowModel
}

// 文本节点
class TextNewNode extends TextNode {
}
class TextNewModel extends TextNodeModel {
    getNodeStyle () {
        const style = super.getNodeStyle()
        const properties = this.getProperties()
        return getShapeStyleFuction(style, properties)
    }

    getTextStyle () {
        const style = super.getTextStyle()
        const properties = this.getProperties()
        if (properties.backgroundColor) {
            style.backgroundStyle = {
                fill: properties.backgroundColor
            }
        }
        return getTextStyleFunction(style, properties)
    }

    setAttributes () {
        super.setAttributes()
        if (!this.text.value) {
            this.text.value = 'text'
        }
    }
}

var TextNode = {
    type: 'pro-text',
    view: TextNewNode,
    model: TextNewModel
}
