(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    /**
     *  头部logo
     */
    exports.HeaderLogo = {
        props: {
            module: Object,
            drawerShow: Boolean,
            logoShow: {
                type: Boolean,
                default: true
            },
            suffixDesc: {
                type: String
            }
        },
        methods: {
            moduleClick(e) {
                this.$emit('moduleClick', e)
            },
        },
        computed: {
            moduleTitle() {
                if (!this.module) return '';
                // return this.module.moduleShort;
                return this.module.moduleName;
            },
            moduleIcon() {
                if (!this.module) return '';
                return this.module.moduleIcon;
            }
        },
        template: `
<div style="display:flex;" >
    <div style="overflow: hidden; padding-left: 5px; flex: 0 0 160px; width: 160px;" v-if="logoShow">
        <svg width="320" height="70" xmlns="http://www.w3.org/2000/svg" class="svg-canvas" transform="scale(0.5) translate(-180,-15) " preserveAspectRatio="none" version="1.1" style="background:#224a7d;">
         <g>
          <title>Layer 1</title>
          <g id="svg_2" stroke="null">
           <path d="m60.5222,8.70934l-1.01876,0.01559a26.17065,20.58688 0 0 0 -23.4315,13.22462l-0.22595,0.48645l0.15857,-0.03118a22.36516,17.59333 0 0 0 -16.84721,17.05075c0,9.2457 9.11731,16.92914 20.75179,17.55591l0.68975,0.03118l39.24408,0l0.44001,-0.00935a19.32077,15.19849 0 0 0 18.54778,-14.61849l0.01189,-0.52387l-0.01982,-0.70474a19.33663,15.21096 0 0 0 -11.67016,-13.30569l-0.55496,-0.17774l0.01982,0.15591a26.16272,20.58064 0 0 0 -25.32235,-19.13999l-0.77299,-0.00936l0.00001,0zm0,4.67742l0.64217,0.00936a20.20476,15.89387 0 0 1 19.52294,14.78064l0.11892,1.33774a2.97304,2.33871 0 0 0 1.90274,2.02376l1.58562,0.4771l0.56686,0.18086a13.35884,10.5086 0 0 1 8.03513,9.65107l-0.00793,0.43656a13.35884,10.5086 0 0 1 -12.8237,10.07204l-0.31712,0.00936l-38.99831,0l-0.48758,-0.02183c-8.46721,-0.45839 -15.16248,-6.09935 -15.16248,-12.88785c0,-5.91537 5.11362,-11.06989 12.36783,-12.51677l1.38741,-0.27752a2.97304,2.33871 0 0 0 2.08113,-1.50301l0.46776,-1.06646l0.23784,-0.50827a20.20872,15.89699 0 0 1 18.8768,-10.19678l0.00396,0l0.00001,0z" fill="#ffffff" id="svg_4" stroke="null"/>
           <path d="m66.9281,39.10944a2.97304,2.33871 0 0 1 0.40433,4.65559l-0.40433,0.02183l-15.8562,0a2.97304,2.33871 0 0 1 -0.40433,-4.65559l0.40433,-0.02183l15.8562,0z" fill="#ffffff" id="svg_5" stroke="null"/>
          </g>
          <text stroke="#000" font-style="normal" xml:space="preserve" text-anchor="start" font-family="Helvetica, Arial, sans-serif" font-size="24" id="svg_1" y="35.22895" x="111.26316" stroke-width="0" fill="#ffffff">软件服务平台</text>
          <text xml:space="preserve" text-anchor="start" font-family="Helvetica, Arial, sans-serif" font-size="12" id="svg_3" y="53.65" x="108" stroke-width="0" stroke="#000" fill="#ffffff">Software Service Platform</text>
         </g>
        </svg>
    </div>

    <div style="line-height: var(--index-nav-line-height); display: inline-flex; justify-content: left; align-items: center;" 
        @click="moduleClick"
        v-if="!!module" class="nav-log-title"> 
        <i class="divider-i" v-if="logoShow"></i>
        <template v-if="moduleIcon.startsWith('#icon')">
            <svg class="icon svg-icon" style="color: #FFF; padding-right: 5px; font-size: 14px; " aria-hidden="true"><use :xlink:href="moduleIcon"></use></svg>   
        </template>
        <template v-else>
            <i class="iconfont" :class="[ moduleIcon ]" style="font-size: 18px;"></i>
        </template>
        {{ moduleTitle }}
        <template v-if="suffixDesc">
            <i class="divider-i" style="padding-left: 12px;"></i>
            {{ suffixDesc }}
        </template>
    </div>
    <div style="line-height: var(--index-nav-line-height); display: inline-flex; justify-content: left; align-items: center; flex: 0 0 5px;" v-else> 
       <i class="divider-i"></i>
    </div>
</div>
        `
    }
}));
