(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.GroupItem = {
        props: {
            item: Object,
            disabled: Boolean,
        },
        inject: ['listLoading'],
        emits: ['change'],
        data(){
            return {

            }
        },
        methods: {
            refresh() {
                this.$refs.formGroupRef.refreshFilterCount();
            },
            cancel() {
                // 取消分组
                this.item.queryParams[this.item.key] = '';
                this.$nextTick(this.item.change)
                this.$emit('cancel')
            }
        },
        watch:{
            listLoading: {
                handler: function(val) {
                    const realVal = vue.unref(val)
                    if (realVal) {
                        this.refresh()
                    }
                },
                deep: true,
            }
        },
        computed:{

        },
        mounted() {

        },
        unmounted() {

        },
        template: `
<el-form-item :label="item.label+ '分组：'" class="filter-item align-right" >
    <form-item-radio-group ref="formGroupRef"
            v-model="item.queryParams[item.key]"
            :dg-url="item.dgUrl"
            :query-params="item.queryParams"
            :rest-method="item.restMethod"
            :query-params-handler="item.queryParamsHandler"
            @change="item.change"
            :filter-key="item.key"
            :group-key="item.groupKey"
            :filter-op-type="item.opType"
            :filter-no-num="item.filterNoNum"
            :filter-count-method="item.filterCountMethod"
            :filter-loop-count="item.filterLoopCount"
    >
        <template #cancel>
            <el-button type="primary" text size="small" @click="cancel" >取消分组</el-button>
        </template>
</form-item-radio-group>
    
</el-form-item>

        `
    }
}));
