(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.PageTablePagination = {
        props: [
            'pageInfo',
            'loadMethod',
            'pageSizes'
        ],
        emits: ['sizeChange', 'currentChange'],
        inject: ['DIC'],
        data(){
            return {
            }
        },
        methods: {
            handleSizeChange(size) {
                const self = this;
                self.$emit('sizeChange', size);
                self.pageInfo.size = size;
                self.loadMethod();
            },
            handleCurrentChange(page) {
                const self = this;
                self.$emit('currentChange', page);
                self.pageInfo.page = page;
                self.loadMethod();
            },
        },
        computed:{
        },
        mounted() {

        },
        unmounted() {

        },
        template: `
<div class="table-pagination">
    <el-pagination small
                   v-model:current-page="pageInfo.page"
                   v-model:page-size="pageInfo.size"
                   :page-sizes="pageSizes || [5, 10, 20, 30, 40, 50, 100, 200, 300]"
                   background
                   layout="sizes, prev, pager, next, total"
                   :total="pageInfo.total"
                   @size-change="handleSizeChange"
                   @current-change="handleCurrentChange"
    />
</div>
        `
    }
}));
