(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.TreeTileMenu = {
        props: {
            activeFirst: Boolean,
            showIcon: {
                type: Boolean,
                default: false
            },
            data: Array,
        },
        inject: ['searchParams'],
        emits: ['collapse', 'open', 'close', 'select'],
        data(){
            return {

            }
        },
        methods: {
            findTargetMenuItem(data, key, keyPath, parents) {
                if (key && key.split('-').length > 0) {
                    const keys = key.split('-');
                    let item = data, i = 0, len = keys.length;
                    while(i < len && item) {
                        item = item[keys[i]];
                        i++;
                        if (i < len) {
                            parents.push(item);
                            item = item.children
                        }
                    }
                    return item;
                } else {
                    return undefined;
                }
            },
            handleSelect(node, key, keyPath) {
                // 点击后 隐藏菜单
                this.data.forEach(el=>el.visible = false) ;
                const parents = []
                if (keyPath && keyPath.length > 0) {
                    let root = this.data[keyPath[0]]
                    if (root) {
                        root.visible = false
                    }
                }
                this.$emit('select', node, key, keyPath, parents)
            },
            handleOpen(key, keyPath) {
                const parents = []
                const item = this.findTargetMenuItem(this.data, key, keyPath, parents)
                this.$emit('open', item, key, keyPath, parents)
            },
            handleClose(key, keyPath) {
                const parents = []
                const item = this.findTargetMenuItem(this.data, key, keyPath, parents)
                this.$emit('close', item, key, keyPath, parents)
            },

            wrapperIndex() {
                let arr = [ ...arguments ].filter(el=>{ return el !== null || el !== undefined })
                return arr.join('-')
            },

            open(index) {
                if (this.$refs.menuRef) {
                    this.$refs.menuRef.open(index)
                }
            },
            handleNodeIconShow(node) {
                const self = this;
                const { searchMode, defaultIcon, showIcon, mode } = self;
                const hasIcon = !!( node.iconCls || node.icon )
                return showIcon && hasIcon
            },
            genMenuItemStyle(index) {
                let deep = (index.split('-') || []).length - 1
                return {
                    'padding-top': deep > 0 ? 0: undefined,
                    'padding-left': deep > 0 ? (deep - 2) * 15: undefined,
                }
            },
            genSubItemStyle(index) {
                let deep = (index.split('-') || []).length - 1
                return {
                    //'padding-top': deep > 0 ? 0: undefined,
                    'padding-left': deep > 0 ? (deep - 2) * 15: undefined,
                }
            },
            handleClickOutside(node) {
                console.log(node, 'click outside')
            },
            clickOutside(e){
                let className = $(e.target).attr('class') || 'not-target';
                if (className.indexOf('tree-tile') < 0 || className === 'tree-tile-menu') {
                    this.data.forEach(el=>el.visible = false) ;
                }
            }

        },
        computed:{
            searchMode() {
                const { search } = this;
                return search && search.length > 1
            },
            headerIcon() {
                return this.localCollapse ? 'Expand' : 'Fold'
            },
            defaultIcon() {
                return this.mode === 'horizontal' ? '' : 'icon-yingyong'
            },
            contextPath() {
                return window.contextPath;
            },
            popperOptions() {
                return window.EL_POPPER_OPTIONS
            }

        },
        mounted() {
            const self = this;
            const {activeFirst,  data } = self;
            document.addEventListener('mousedown', self.clickOutside)
            if (activeFirst) {
                if (data && data.length > 0) {
                    if (!data[0].children || data[0].children.length == 0) {
                        self.$emit('select', data[0])
                    } else if (data[0].children && data[0].children.length > 0) {
                        let child = data[0].children[0] ;
                        if (!child.children || child.children.length == 0) {
                            self.$emit('select', child)
                        } else {
                            child = child.children[0] ;
                            if (!child.children || child.children.length == 0) {
                                self.$emit('select', child)
                            }
                        }
                    }
                }
            }
        },
        unmounted() {
            document.removeEventListener('mousedown', this.clickOutside)
        },
        render() {
            const self = this;
            const { h } = Vue;
            const {  defaultIcon, showIcon } = self;

            function createMenuItemTitle(node) {
                return h('span', node.text)

            }
            function createMenuItem(node, index, parent, pKeyPath) {
                if (node.children && node.children.length > 0 && !node.hide ) {
                    const menuKey = self.wrapperIndex.apply(self, [...pKeyPath, index])
                    node.menuKey = menuKey
                    if (!parent ) {
                        // 一根节点才渲染 Tooltip
                        return h(ElementPlus.ElTooltip, {
                            class: ['tree-tile-menu-sub'],
                            popperOptions: self.popperOptions,
                            popperClass: "tree-tile-menu-sub-popper",
                            placement: "bottom-start",
                            showArrow: false,
                            effect: 'light',
                            visible: node.visible,
                            trigger: 'click',
                            index: menuKey,
                            ref: 'menuTooltip',
                            key: index,
                        }, {
                            default: ()=>[
                                h('div', {
                                    class: { 'tree-tile-menu-item': true, 'tree-tile-menu-sub-root-title' : !parent },
                                    index: menuKey,
                                    key: index,
                                }, [
                                    h(ElementPlus.ElIcon, { style: { "display" : self.handleNodeIconShow(node) ? undefined : 'none' }, class: [ 'tree-menu-icon']},
                                        node.iconCls && node.iconCls.startsWith('#')
                                            ? h('svg', { class: [ "icon", "svg-icon" ], style: { 'padding-right': '5px', 'font-size': '14px' }}, h('use', { 'xlink:href': node.iconCls }))
                                            : h('i', { class: [ "iconfont",  node.iconCls || node.icon || defaultIcon ]})  ),
                                    h('span', {
                                            style: "width: 100%; flex: 1; display: flex; align-items: center; justify-content: space-between;",
                                            onClick: (event)=>{ node.visible = true; console.log(node.visible, event) }
                                        },
                                        createMenuItemTitle(node))
                                ])
                            ],
                            content: ()=> [
                                h('div', { class: ['tree-tile-menu-sub-container'] },
                                    node.children.map(function(el, elIdx){
                                        return createMenuItem(el, elIdx, node, [...pKeyPath, index])
                                    })
                                )
                            ]
                        })
                    } else {
                        return h('div', {
                            class: {'tree-tile-menu-item': true, 'border-left': (menuKey.split('-') || []).length == 2 },
                            index: menuKey,
                            key: index,
                        }, {
                            default: ()=>[
                                h('div', {
                                    class: { 'tree-tile-menu-sub-item': true },
                                    style: self.genMenuItemStyle(menuKey),
                                    index: menuKey,
                                    key: index,
                                }, [
                                    h('div', {
                                        class: ['tree-tile-menu-sub-item-title'],
                                    },
                                        h(ElementPlus.ElIcon, { style: { "display" : self.handleNodeIconShow(node) ? undefined : 'none' }, class: [ 'tree-menu-icon']},
                                            node.iconCls && node.iconCls.startsWith('#')
                                                ? h('svg', { class: [ "icon", "svg-icon" ], style: { 'padding-right': '5px', 'font-size': '14px' }}, h('use', { 'xlink:href': node.iconCls }))
                                                : h('i', { class: [ "iconfont",  node.iconCls || node.icon || defaultIcon ]})  ),
                                        h('span', {
                                                style: "width: 100%; flex: 1; display: flex; align-items: center; justify-content: space-between;",
                                                onClick: (event)=>{ /*node.stopClickOnLabel && event.stopPropagation();  self.handleSelect(menuKey) ; */ },
                                            },
                                            createMenuItemTitle(node)
                                        ),
                                    ),
                                    h('div', { class: ['tree-tile-menu-sub-item-container'] },
                                        node.children.map(function(el, elIdx){
                                            return createMenuItem(el, elIdx, node, [...pKeyPath, index])
                                        })
                                    )
                                ])
                            ],
                        })
                    }

                } else {
                    const menuKey = self.wrapperIndex.apply(self, [...pKeyPath, index])
                    node.menuKey = menuKey
                    if (pKeyPath.length === 1) {
                        return h('div', {
                            class: {'tree-tile-menu-item': true, 'border-left': (menuKey.split('-') || []).length == 2 },
                            index: menuKey,
                            key: index,
                        }, {
                            default: ()=>[
                                h('div', {
                                    class: { 'tree-tile-menu-sub-item': true },
                                    style: self.genMenuItemStyle(menuKey),
                                    index: menuKey,
                                    key: index,
                                }, [
                                    h('div', {
                                            class: { 'tree-tile-menu-item': true, 'tree-tile-menu-sub-root-title' : !parent, 'tree-tile-menu-sub-title' : parent,},
                                            style: { 'padding-top': 0 },
                                            onClick: (event)=> { self.handleSelect(node, menuKey, [...pKeyPath, index]) }
                                        },
                                        h(ElementPlus.ElIcon, { style: { "display" : self.handleNodeIconShow(node) ? undefined : 'none' }, class: [ 'tree-menu-icon']},
                                            node.iconCls && node.iconCls.startsWith('#')
                                                ? h('svg', { class: [ "icon", "svg-icon" ], style: { 'padding-right': '5px', 'font-size': '14px' }}, h('use', { 'xlink:href': node.iconCls }))
                                                : h('i', { class: [ "iconfont",  node.iconCls || node.icon || defaultIcon ]})  ),
                                        h('span', {
                                                style: "width: 100%; flex: 1; display: flex; align-items: center; justify-content: space-between;",
                                            },
                                            createMenuItemTitle(node)
                                        ),
                                    ),

                                ])
                            ],
                        })
                    } else {
                        return h('div', {
                            class: { 'tree-tile-menu-item': true, 'tree-tile-menu-sub-root-title' : !parent, 'tree-tile-menu-sub-title' : parent,},
                            style: self.genSubItemStyle(menuKey),
                            index: menuKey,
                            key: index,
                            onClick: (event)=> { self.handleSelect(node, menuKey, [...pKeyPath, index]) }
                        }, {
                            default: ()=>[
                                h(ElementPlus.ElIcon, { style: { "display" : self.handleNodeIconShow(node) ? undefined : 'none' }, class: [ 'tree-menu-icon']},
                                    node.iconCls && node.iconCls.startsWith('#')
                                        ? h('svg', { class: [ "icon", "svg-icon" ], style: { 'padding-right': '5px', 'font-size': '14px' }}, h('use', { 'xlink:href': node.iconCls }))
                                        : h('i', { class: [ "iconfont",  node.iconCls || node.icon || defaultIcon ]})
                                ),
                                h('span', {
                                        style: "width: 100%; flex: 1; display: flex; align-items: center; justify-content: space-between;",
                                    },
                                    createMenuItemTitle(node)
                                )
                            ],
                        })
                    }

                }
            }
            return h('div', { style: { "padding-top": "0px"}}, [
                h('div', {
                    class: "tree-tile-menu",
                    ref: 'menuRef'
                }, self.data.map(function(el, index){
                        return createMenuItem(el, index, null, [])
                    })
                )
            ])
        },
    }
}));
