(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.FilterRadioGroup = {
        props: [
            'modelValue',
            'filterCountData',
            'opType',
            'filterNoNum',
        ],
        emits: ['update:modelValue', 'change'],
        inject: ['DIC'],
        data(){
            return {
            }
        },
        methods: {
            formatterFilterCount(type) {
                if (this.filterNoNum || !this.filterCountData) {
                    return ''
                }
                return `(${this.filterCountData[type] || '0'})`
            },
        },
        computed:{
            filterTypeDic(){
                if (_.isArray(this.opType)) {
                    return this.opType;
                } else {
                    return this.DIC[this.opType] || []
                }
            },
            value: {
                get() {
                    return this.modelValue
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                    this.$emit("change", value)
                }
            }
        },
        mounted() {

        },
        unmounted() {

        },
        template: `
<el-radio-group class="table-filter-radio" v-model="value" >
    <el-radio-button v-for="el in filterTypeDic" :key="el.enname" :label="el.enname" >{{el.cnname}}{{ formatterFilterCount(el.enname) }}</el-radio-button>
    <slot name="cancel"></slot>
</el-radio-group>
        `
    }
}));