(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.SortDropdown = {
        props: {
            sortItem: Array,
            disabled: Boolean,
        },
        emits: ['sort'],
        data(){
            return {
                currentItem: undefined
            }
        },
        methods: {
            handlerCommand(param) {
                if (param.command == 'sortList') {
                    this.currentItem = param.item
                    this.$emit('sort', param.item, param.initFlag)
                }
            }
        },
        computed:{
            DIC(){
                if (_.isArray(this.opType)) {
                    return this.opType;
                } else {
                    return window[this.opType] || []
                }
            },
            displayLabel() {
                if (this.currentItem) {
                    return this.currentItem.label || ""
                } else {
                    return "";
                }
            }
        },
        mounted() {
            if(this.sortItem && this.sortItem.length > 0 && !this.currentItem) {
                this.handlerCommand({command: 'sortList', item: this.sortItem[0], initFlag: true})
            }
        },
        unmounted() {

        },
        template: `
<el-dropdown trigger="click" @command="handlerCommand"  :disabled="disabled">
    <el-button class="button" icon="Sort" text size="small" >{{displayLabel}}</el-button>
    <template #dropdown>
      <el-dropdown-menu>
        <el-dropdown-item v-for="(item, index) in sortItem" :key="index" :command="{ command: 'sortList', item: item}">
            {{item.label}}
            <span style="float: right; color: var(--el-text-color-secondary); display: inline-block; margin-left: 10px;" v-if="displayLabel == item.label"><el-icon><Select></Select></el-icon></span>
        </el-dropdown-item>
      </el-dropdown-menu>
    </template>
</el-dropdown>
        `
    }
}));
