(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.OwnCard = {
        props: {
            'breadcrumb': Array,
            'shadow': String
        },
        data(){
            return {
            }
        },
        methods: {
        },
        computed:{
            title() {
                if (_.isArray(this.breadcrumb ) ) {
                    return this.breadcrumb.join("->")
                } else {
                    return this.breadcrumb;
                }
            }
        },
        mounted() {

        },
        unmounted() {

        },
        template: `
                    <el-card class="box-card pure-theme" :shadow="shadow" >
                        <template #header>
                            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header></page-header>
                        </template>
                        <slot></slot>
                    </el-card>
        `, _designerRule: {
            //插入菜单位置
            menu: 'layout',
            icon: 'icon-card',
            name: 'OwnCard',
            //名称
            label: '卡片',
            drag: true,
            inside: false,
            mask: false,
            rule({t}) {
                return {
                    type: 'OwnCard',
                    props: {
                        breadcrumb: t('com.elCard.props.header')
                    },
                    style: {
                        width: '100%'
                    },
                    children: []
                };
            },
            props(_, {t}) {
                return [
                    {
                        type: 'input',
                        field: 'breadcrumb',
                    }, {
                        type: 'select',
                        field: 'shadow',
                        value: 'always',
                        options: [{label: 'always', value: 'always'}, {label: 'never', value: 'never'}, {label: 'hover', value: 'hover'}]
                    }
                ]
            }
        }
    }
}));
