(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {

    exports.SDynamicUtil = {
        handlerDynamicItemClick: function(event, row) {
            if ($(event.target).hasClass('timeline-href')) {
                if (row.dlType1 == 'gitlab') {
                    const hrefDOM = $(event.target);
                    if (hrefDOM.attr('subs')) {
                        const subsId = hrefDOM.attr('subs');
                        $.restfulGet('/allinapaas/api/portal/s/subs/info/' + subsId, null, function(data){
                            if (data.rows) {
                                ElementDialog.createDialog(row.subsName + '详情',`/allinapaas/page/allinapaas/design/console/SSubsInfoView.html?subsId=${row.subsId}` );
                            }
                        }, function(e) {
                        }, true)
                    } else if (hrefDOM.attr('app')) {
                        const appId = hrefDOM.attr('app');
                        $.restfulGet('/allinapaas/api/portal/paas/apps/info/' + appId, null, function(data){
                            if (data.rows) {
                                ElementDialog.createDialog('查看应用', '/allinapaas/page/allinapaas/design/console/PaasAppsTabsView.html?appId='+data.rows.appId );
                            }
                        }, function(e) {
                        }, true)
                    }
                }
            } else if ($(event.target).hasClass('timeline-linked')) {
                const id = $(event.target).text().replace("#", "")
                if (row.dlType1 == 'gitlab') {
                    // 代码仓库 从上级节点 获取 href 进行跳转
                    const hrefDOM = $(event.target).parent();
                    let href = hrefDOM.attr('href');
                    if (href) {
                        window.JLUtil.linkNewPage(href)
                    }
                } else if (id == row.dlBizkey) {
                    // 为该业务主键点击
                    let url = '';
                    if (row.dlType2 == '00') {
                        // 任务动态 打开任务查看
                        url = '/allinrdm/page/project/console/RdmTaskInfoView.html?taskId=' + id
                    } else if (row.dlType2 == '01') {
                        // 问题动态
                        url = '/allinrdm/page/project/console/RdmIssueInfoView.html?issueId=' + id
                    } else if (row.dlType2 == '02') {
                        // 需求动态
                        url = '/allinrdm/page/project/console/RdmRequirementInfoView.html?reqId=' + id
                    } else if (row.dlType2 == '03') {
                        // 项目动态
                        url = '/allinrdm/page/project/console/RdmProjectInfoView.html?appId=' + id
                    } else if (row.dlType2 == '04') {
                        // OKR动态
                        // 有可能是目标编号  或者是关键结果编号
                        $.restfulGet('/allinrdm/api/rdm/objective/info/' + id, null, function(data){
                            if (data.rows) {
                                //window.top.addTab(id + 'OKR管理','/allinrdm/page/project/console/RdmObjectiveKrIndex.html?' + 'objectiveId=' + id);
                                ElementDialog.createDialog(data.rows.objectiveName + '-详情', '/allinrdm/page/project/console/RdmObjectiveInfoView.html?objectiveId=' + id)
                            }
                        }, function(e) {
                            // 关键结果
                            ElementDialog.createDialog('详情','/allinrdm/page/project/console/RdmObjectiveKrView.html?' + '&krId=' + id);
                        }, true)

                        return;
                    } else if (row.dlType2 == '05') {
                        // 团队动态
                        window.top.addTab(id + '团队管理', `/allinrdm/page/project/console/RdmProjectUserList.html?teamId=${id}`);
                        return;
                    } else if (row.dlType2 == '06') {
                        // 周报动态
                        window.top.addTab(`${id}周报填写`,'/allinrdm/page/admin/console/RdmWeeklyReportTaskList.html?' + 'reportId=' + id);
                        return;
                    } else if (row.dlType2 == '11') {
                        // 组件动态
                        ElementDialog.createDialog('详情','/allinrdm/page/sam/console/SdkComInfoView.html?' + 'comId=' + id);
                    } else if (row.dlType2 == '12') {
                        // 服务器
                        $.restfulGet('/allinapaas/api/paas/ecs/info/' + id, null, function(data){
                            ElementDialog.createDialog('详情','/allinapaas/page/allinapaas/design/console/PaasEcsInfoTabsView.html?' + 'ecsId=' + id + '&ecsName=' + data.rows.ecsName + '&cloudEcsId=' + data.rows.cloudEcsId);
                        }, $.noop, true)
                        
                    }
                    url && ElementDialog.createDialog('详情', url);
                }
            }
        }
    };

}));