(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.FilterCondition = {
        props: {
            modelValue: Object,
            visible: Boolean,
            disabled: Boolean,
            labelWidth: {
                type: String,
                default: '100px'
            },
            config: Array
        },
        emits: ['update:modelValue', 'filter'],
        data(){
            return {
                filterCond: []
            }
        },
        watch: {
            'modelValue': {
                handler: function(val) {
                    if(!val || val.length === 0) {
                        return
                    }
                    if (this.filterCond && this.filterCond.length > 0 ) {
                        this.filterCond.forEach(el=>{
                            const item = val.find(v=>v.name === el.name)
                            if (item) {
                                el.type = item.type
                                el.op = item.op
                                el.values = item.values
                                el.valueNames = item.valueNames
                                el.name = item.name
                                el.key = item.key
                                el.keys = item.keys
                                el.colNames = item.colNames
                                el.thisDate = item.thisDate
                            } else {
                                el.values.splice(0, el.values.length)
                                el.valueNames.splice(0, el.valueNames.length)
                                if(el.thisDate) {
                                    Object.assign(el.thisDate, {
                                        "weekId": "",
                                        "year": "",
                                        "weekNumber": "",
                                        "startDate": "",
                                        "endDate": "",
                                        "month": '',
                                    })
                                }
                            }
                        })
                    } else {
                        this.filterCond = val;
                    }

                },
                deep: true
            },
            'filterCond': {
                handler: function(value) {
                    // 过滤 values 不为空的
                    let items = []
                    if (value) {
                        items = value.filter(el=>el.values && el.values.length > 0 && el.values[0])
                        if(items && items.length > 0) {
                            items = items.map(el=>{
                                return {
                                    type: el.type,
                                    logicOp: el.logicOp,
                                    op: el.op,
                                    colNames: el.colNames,
                                    key: el.key,
                                    keys: el.keys,
                                    values: el.values,
                                    valueNames: el.valueNames,
                                    name: el.name,
                                    thisDate: el.thisDate
                                }
                            })
                        }
                    }
                    this.$emit('update:modelValue', items)
                },
                deep: true
            }
        },
        methods: {
            filterDialog() {
                this.visible = true
            },
            reset() {
                const self = this;
                // 重围已有过滤条件值
                self.filterCond.forEach(el=>{
                    el.values.splice(0, el.values.length)
                    el.valueNames.splice(0, el.values.length)
                    if(el.thisDate) {
                        Object.assign(el.thisDate, {
                            "weekId": "",
                            "year": "",
                            "weekNumber": "",
                            "startDate": "",
                            "endDate": "",
                            "month": '',
                        })
                    }
                })
                // self.filterCond.splice(0, self.filterCond.length);
                // 触发查询
                this.$nextTick(()=>this.$emit('filter'))
                // 显示过虑条件文本
                this.showText()
            },
            showText() {
                this.$emit('close');
            },
            doFilter() {
                this.$nextTick(()=>{
                    this.$emit('filter');
                    this.showText();
                })
            },
        },
        provide() {
            return {
                filterCond: vue.computed(()=>this.filterCond),
                filterConfig: vue.computed(()=>this.config)
            }
        },
        mounted() {
            this.filterCond = this.modelValue || []
        },
        unmounted() {
        },
        template: `
<el-row :gutter="disabled ? 0 : 20" :style="{ 'margin': disabled ? '0px 50px' : '' }">
    <template v-if="visible">
        <filter-item v-for="(item, index) in config" :key="index" :disabled="disabled" :config="item" :label-width="labelWidth"></filter-item>
        <el-col style="text-align: right; margin: 0px 0px; display: flex; justify-content: flex-end;" v-if="!disabled">
            <div>
                <el-button type="default" icon="Close" size="small" @click="showText" >关闭</el-button>
                <el-button type="primary" icon="Check" size="small" @click="doFilter" :disabled="disabled">过滤</el-button>
            </div>
        </el-col>
    </template>
    <template v-else>
        <el-col :span="24" style="display: flex; align-items: center; flex-wrap: wrap;">
            <filter-item-text v-for="(item, index) in modelValue" :key="index" :config="item" @remove="doFilter" :disabled="disabled"></filter-item-text>
            <el-button v-if="modelValue && modelValue.length > 0 && !disabled" type="primary" text size="small" @click="reset" class="filter-cond-item-text-empty-btn">清空</el-button>
        </el-col>
    </template>
</el-row>
        `
    }
}));
