(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {

    const OFFSET_WINDOW_TOP = 140 ;

    // 默认展示菜单
    exports.NavTileMenu = {
        props: ['signUserId', 'modelValue', 'resourceId'],
        data(){
            return {

                formData: {
                    actorno: this.signUserId,
                    defaultDisplay: '',
                },

                menuList: [], // 菜单
                menuTree: [], // 菜单
                collectList: [], // 收藏
                usageList: [], // 最近

                windowHeight: 0,

                searchStr: "", // 搜索

                activeGroup: 'usage', // 激活的分组
                collapseGroup: true, // 收起分组
                clickScrolling: false, // 标识是点击滚动的
            }
        },
        emits: ['update:modelValue'],
        watch: {
            value(val) {
                if (val) {
                    this.queryList();
                }
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            searchMenu(e) {
                const self = this;
                const  { menuTree , searchStr} = self;
                if (!searchStr || searchStr.length == 0) {
                    menuTree.forEach(el=>{
                        el.serachHide = self.recursionSearch(el, '', true);
                    })
                }
                if (searchStr) {
                    menuTree.forEach(el=>{
                        el.serachHide = self.recursionSearch(el, searchStr, false);
                    })
                }
            },
            recursionSearch(data, search, resetFlag) {
                if (data.children && data.children.length > 0) {
                    let hide = true;
                    for (let i= 0; i < data.children.length; i++) {
                        let re = this.recursionSearch(data.children[i], search, resetFlag);
                        if (!re) {
                            hide = re;
                        }
                    }
                    data.serachHide = hide;
                } else {
                    if (resetFlag) {
                        data.serachHide = !resetFlag
                    } else {
                        data.serachHide = ! ( data.text.toLowerCase().indexOf(search.toLowerCase()) >= 0 );
                    }
                }
                return data.serachHide;
            },
            controlShow(el, index) {
                if (!el) {
                    return false;
                }
                const self = this;
                const { searchMode } = self;
                if (searchMode) {
                    return !el.serachHide
                } else {
                    return true;
                }
            },
            queryList() {
                const self = this;
                self.loading = true;

                const taskQueue = new TaskQueue();
                // 查询模块
                taskQueue.push(callback=>{
                    $.restfulGet('/allincloud/api/s/resources/onetree', { actorno: self.signUserId, resourceid: (self.resourceId || '') }, function(data){
                        let map = {}, root = [], list = [];
                        data.rows.forEach(el=>{
                            let node = {
                                id: el.resourceid,
                                text: el.cnname,
                                iconCls: el.icon,
                                serachHide: false, // 控制搜索时的显示隐藏
                                children: [],
                                ...el
                            }
                            map[node.id] = node;
                            list.push(node);
                        });
                        list.forEach(el=>{
                            let node = map[el.id];
                            let parent = map[el.parentid];
                            if (parent) {
                                parent.children.push(node)
                            } else if(node.parentid === 'root') {
                                root.push(node)
                            }
                        })
                        self.menuList = list;
                        // 树状
                        self.menuTree = root;
                        callback(true)
                    }, function(e){
                        self.loading = false;
                        callback(false)
                    }, true);
                })
                // 查询 最近6条 收藏
                taskQueue.push(callback=>{
                    $.restfulPostForm('/allincloud/api/s/resource/shortcuts', {
                            size: 6, descOrder: 'shortcutOpTime',
                            shortcutUser: self.signUserId ,
                            shortcutType: '1'
                        },
                    function(data){
                        self.collectList = data.rows;
                        callback(true)
                    }, function(e){
                        self.loading = false;
                        callback(false)
                    }, true);
                })
                // 查询 最近6条 最近访问
                taskQueue.push(callback=>{
                    $.restfulPostForm('/allincloud/api/s/resource/shortcuts/usage', {
                            size: 6, descOrder: 'shortcutOpTime',
                            shortcutUser: self.signUserId ,
                            shortcutType: '2'
                        },
                    function(data){
                        self.usageList = data.rows;
                        callback(true)
                    }, function(e){
                        self.loading = false;
                        callback(false)
                    }, true);
                })
                // 结束
                taskQueue.push(callback=>{
                    self.loading = false;

                })
                taskQueue.start()

            },
            selectMenu(menu) {
                const self = this ;
                
                self.value = false;
                setTimeout(function(){
                    self.recordMenu(menu); // 有权限则记录访问
                    self.$emit('select', Vue.toRaw(menu))
                },200)


            },
            closeDrawer() {
                this.value = false;
            },
            showCollect(event) {
                this.collapseGroup = false;
            },
            cancelCollectMenu(menu) {
                // 取消收藏
                const self = this;
                $.restfulPostJson('/allincloud/api/s/resource/shortcut/cancel',  { resourceid: menu.id}, function(data){
                    if (data.rows > 0) {
                        const idx = self.collectList.findIndex(el=>el.resourceid  === menu.id)
                        if (idx >= 0) {
                            self.collectList.splice(idx, 1);
                        }
                    }
                }, function(e){

                }, true);
            },
            collectMenu(menu) {
                // 收藏
                const self = this;
                $.restfulPostJson('/allincloud/api/s/resource/shortcut',  { resourceid: menu.id, shortcutType: '1' }, function(data){
                    if (data.rows > 0) {
                        self.collectList.push({ resourceid: menu.id, shortcutType: '1' })
                    }
                }, function(e){

                }, true);
            },
            recordMenu(menu) {
                // 记录经常访问
                const self = this;
                if (!menu.url) {
                    // 没有url 不记录
                    return;
                }
                $.restfulPostJson('/allincloud/api/s/resource/shortcut',  { resourceid: menu.id, shortcutType: '2' }, function(data){
                    if (data.rows > 0) {
                        // self.usageList.splice(0, 1);
                        // self.usageList.push({ resourceid: module.resourceid, shortcutType: '1' })
                    }
                }, function(e){

                }, true);
            },
            getWindowSize: _.debounce(function() {
                let height = window.innerHeight ;
                this.windowHeight = height - 50 ;

            }, 150),
            scrollTo(item) {
                const self = this;
                // 获取目标的 offsetTop
                // css选择器是从 1 开始计数，我们是从 0 开始，所以要 +1
                const navContents = document.querySelectorAll(`.chose-display-container .chose-display-group-title`);
                let targetElem = null;
                for(let i=0; i<navContents.length; i++){ // 找到分组的锚点
                    const el = navContents[i]
                    let group = $(el).attr('anchor-id');
                    if (group == item.enname) {
                        targetElem = el;
                        break
                    }
                }
                if (!targetElem || !self.$refs.groupScrollRef) return;
                self.clickScrolling = true;
                self.activeGroup = $(targetElem).attr('anchor-id');
                const scrollTop = self.$refs.groupScrollRef.wrapRef.scrollTop;
                const elTop = $(targetElem).offset().top;
                if (  elTop < OFFSET_WINDOW_TOP ) {
                    // 向上 减
                    self.$refs.groupScrollRef.setScrollTop(scrollTop - Math.abs(elTop) + OFFSET_WINDOW_TOP)
                } else {
                    // 向下 加
                    self.$refs.groupScrollRef.setScrollTop(scrollTop + elTop - OFFSET_WINDOW_TOP)
                }
                setTimeout(()=>{
                    self.clickScrolling = false;
                }, 200)

            },
            onScroll: _.throttle(function() {
                const self =   this;
                if (self.clickScrolling) {
                    return;
                }

                const scrollTop = document.documentElement.scrollTop || document.body.scrollTop;


                // 获取所有锚点元素
                const navContents = document.querySelectorAll(`.chose-display-container .chose-display-group-title`);

                const navLength = navContents.length
                for (let i=0; i<navLength; i++) {
                    const item = navContents[i]
                    const navIdx = i
                    if (!item.offsetParent || item.getBoundingClientRect().bottom == 0) {
                        // 当前页面没有显示
                        continue
                    }
                    let group = $(item).attr('anchor-id');
                    if (group) {
                        let rect = item.offsetParent.getBoundingClientRect();
                        if ((rect.top >= OFFSET_WINDOW_TOP && rect.bottom >= OFFSET_WINDOW_TOP) ||
                            (rect.top < OFFSET_WINDOW_TOP && rect.bottom >= OFFSET_WINDOW_TOP)) {
                            self.activeGroup  = group;
                            break;
                        }

                    }
                }

            }, 500),
        },
        provide() {
            return {
            }
        },
        computed: {

            searchMode() {
                const { searchStr } = this;
                return searchStr && searchStr.length > 1
            },
            value: {
                get() {
                    return this.modelValue
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
            DIC() {
                return {
                }
            },

            breadcrumb() {
                return ['菜单' ];

            },
            menuMap() {
                const self = this;
                const { menuList } = self;
                let map = {} ;
                if (menuList) {
                    menuList.forEach(el=>{
                        map[el.id] = el;
                    })
                }
                return map;
            },
        },
        unmounted() {
            $(window).on('resize', this.getWindowSize)
        },
        mounted() {
            let self = this;

            $(window).on('resize', self.getWindowSize)
            self.getWindowSize();
            self.queryList();

            window.menuInst = this;
        },
        template: `
        <el-drawer v-model="value" direction="ttb" :close-on-click-modal="true" append-to-body :with-header="false" size="100%" 
            modal-class="chose-display-modal nav-tile-menu-modal"
            style="--el-drawer-padding-primary: 0px; ">
            <template #default>
                <div class="chose-display-container">
                     <el-row :style="{ height: windowHeight * 0.6 }">
                        <el-col :span="5" style="border-right: 1px solid var(--el-border-color-light);" >
                            <el-scrollbar >
                                <div class="chose-display-menu" @click="showCollect">
                                    <el-icon><i class="iconfont icon-pingfen"></i></el-icon>
                                    <span>我的收藏</span>
                                </div>
                                <div class="chose-display-menu" @click="()=>collapseGroup = true">
                                    <el-icon><i class="iconfont icon-gonggeshitu"></i></el-icon>
                                    <span>所有菜单</span>
                                </div>
                                <ul class="chose-display-menu-ul" v-show="collapseGroup">
                                    <li class="chose-display-menu-ul-li" nav-id="usage" :nav-text="最近访问" :class="{ active: 'usage' === activeGroup }" 
                                      @click="scrollTo({enname: 'usage', cnname: '最近访问'}, $event)"
                                        >最近访问</li>
                                <template v-for="(el,index) in menuTree">
                                    <li class="chose-display-menu-ul-li"  :key="index" 
                                        :nav-id="el.id" :nav-text="el.text"
                                        :class="{ active: el.id === activeGroup }"
                                        @click="scrollTo(el, $event)"
                                        >{{ el.text }}</li>
                                </template>
                                </ul>
                            </el-scrollbar>
                        </el-col> 
                        <el-col :span="19" v-show="collapseGroup">
                            <div style="display: flex; justify-content: space-between; padding: 20px 10px 10px 40px; ">
                                <el-input v-model="searchStr" size="large" placeholder="搜索菜单" 
                                    style="width: 50%; "
                                    @keydown.enter="searchMenu" @input="searchMenu" prefix-icon="Search"></el-input>
                                <el-button icon="Close" size="large" text @click="closeDrawer" ></el-button>
                            </div>
                            <el-scrollbar ref="groupScrollRef" @scroll="onScroll" :style="{ height: windowHeight * 0.6 - 70 }">
                                <div class="chose-display-group"  >
                                    <el-row style="padding-top: 0px;" >
                                        <el-col style="display:flex;">
                                            <div class="chose-display-group-title" anchor-id="usage" anchor-text="最近访问">最近访问</div>
                                        </el-col>
                                    </el-row>
                                    <el-row :gutter="10">
                                        <el-col :span="5" v-for="(m, mIdx) in usageList.map(el=>menuMap[el.resourceid]).filter(controlShow)" :key="mIdx">
                                            <div class="chose-display-item" @click="selectMenu(m)" 
                                            >
                                                <div class="chose-display-item-name" style="flex: 0; padding-left: 0;padding-top:5px">
                                                    <span>{{m.text}}</span>
                                                    <el-icon v-if="collectList.findIndex(el=>el.resourceid === m.resourceid ) >= 0 " @click.stop.prevent="cancelCollectMenu(m)" > <i class="iconfont icon-pingfen" style="color: var(--el-color-warning);" ></i> </el-icon>
                                                    <el-icon v-if="collectList.findIndex(el=>el.resourceid === m.resourceid ) < 0 " class="chose-display-item-collect-icon" @click.stop.prevent="collectMenu(m)" > <i class="iconfont icon-pingfen" style="color:  #999;" ></i> </el-icon>
                                                </div>
                                            </div>
                                        </el-col>
                                    </el-row>
                                </div>
                                <template v-for="(group, index) in menuTree" >
                                <div class="chose-display-group"  :key="index" >
                                    <el-row style="padding-top: 0px;" >
                                        <el-col style="display:flex;">
                                            <div class="chose-display-group-title"
                                                :anchor-id="group.id" :anchor-text="group.text"
                                                >{{group.text}}</div>
                                        </el-col>
                                    </el-row>
                                    <el-row :gutter="10">
                                        <el-col :span="24">
                                            <nav-tile-menu-item :data="group.children" :collect-list="collectList" 
                                                @select="selectMenu"
                                                @cancel-collect="cancelCollectMenu"
                                                @collect="collectMenu"
                                            
                                            ></nav-tile-menu-item>
                                        </el-col>
                                    </el-row>
                                </div>
                                </template>
                            </el-scrollbar>
                        </el-col> 
                        <el-col :span="18" v-show="!collapseGroup">
                            <el-scrollbar >
                                <div class="chose-display-group"  >
                                    <el-row style="padding-top: 0px;" >
                                        <el-col style="display:flex;">
                                            <div class="chose-display-group-title">我的收藏</div>
                                        </el-col>
                                    </el-row>
                                    <el-row :gutter="10">
                                        <el-col :span="5" v-for="(m, mIdx) in collectList.filter(el=>!!menuMap[el.resourceid]).map(el=>menuMap[el.resourceid])" :key="mIdx">
                                            <div class="chose-display-item" @click="selectMenu(m)" 
                                                :class="{ 'chose-display-item-selected' : m.resourceid === formData.defaultDisplay }" 
                                            >
                                                <div class="chose-display-item-name" style="flex: 0; padding-left: 0;padding-top:5px">
                                                    <span>{{m.cnname}}</span>
                                                    <el-icon > <i class="iconfont icon-pingfen" style="color: var(--el-color-warning);" ></i> </el-icon>
                                                </div>
                                            </div>
                                            
                                        </el-col>
                                    </el-row>
                                </div>
                            </el-scrollbar>
                        </el-col> 
                    </el-row>
                </div>
                
            </template>
        </el-drawer>
        `
    }

}));