if(!jslib) var jslib = {};

function successHandler(data, method, url, param, successCall, failureCall, async, stop) {
	if(!successCall){
		if (window.ElementPlus) {
			window.ElementPlus.ElMessage({
				showClose: true,
				message: data.message,
				type: 'success',
			})
		} else {
			// $.messager.alert("提示", data.message, "info");
		}
	} else {
		successCall(data);
	}
	return true;

}
function errorHandler(e, method, url, param, successCall, failureCall, async, stop) {
	if (e && e.responseJSON && !stop) {
		const data = e.responseJSON
		if (data && data.code == '302') {
			console.log('重定向请求')
			// 重新请求一次
			$[method].call(this, url, param, successCall, failureCall, async, true);
			return;
		}
	}
	let message = '操作失败！';
	if (e && e.responseJSON) {
		const data = e.responseJSON
		message = data.message
	}
	if (failureCall) {
		failureCall(e);
	} else {
		if (window.ElementPlus) {
			window.ElementPlus.ElMessage({
				showClose: true,
				message: message,
				type: 'error',
			})
		} else {
			// $.messager.alert("提示", message, "error");
		}
	}
}

(function($) {

	$.getUrlParam = function(name, decode = window.decodeURI) {
		var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
		var lastIdx = 0, nextIdx = 0;
		var searchStr = window.location.search.substring(1);
		while(searchStr.substring(nextIdx).search(reg) != -1) {
			lastIdx = searchStr.substring(nextIdx).search(reg);
			searchStr = searchStr.substring(nextIdx);
			nextIdx = lastIdx + name.length ;
		}
		if (lastIdx == -1) {
			return  '';
		}
		var r = searchStr.match(reg);
		if (r != null) {
			let val = decode(r[2]);
			if (val == 'undefined' || val == 'null') {
				return ''
			} else {
				return val
			}
		}
		return '';
	};

	$.fn.serializeJson=function(){
		var serializeObj={};
		var array=this.serializeArray();
		//解决disabled属性无法serialize
		$(':disabled[name]', this).each(function () {
			array.push({ name: this.name, value: $(this).val() });
		});

		var str=this.serialize();
		$(array).each(function(){
			if(serializeObj[this.name]){
				if($.isArray(serializeObj[this.name])){
					serializeObj[this.name].push(this.value);
				}else{
					serializeObj[this.name]=[serializeObj[this.name],this.value];
				}
			}else{
				serializeObj[this.name]=this.value;
			}
		});
		return serializeObj;
	};

	$.restfulPostForm = function(url, param, successCall, failureCall, async=false, stop) {
		$.ajax({
			url:url,
			type:"POST",
			data: param,
			contentType:"application/x-www-form-urlencoded;charset=UTF-8",
			dataType:"json",
			async:async,
			success: function(data) {
				successHandler(data, 'restfulPostForm', url, param, successCall, failureCall, async, stop)
			},
			error: function(e) {
				errorHandler(e, 'restfulPostForm', url, param, successCall, failureCall, async, stop)
			}
		});
	};

	$.restfulPostJson = function(url, param, successCall, failureCall, async=false, stop) {
		$.ajax({
			url:url,
			type:"POST",
			data:JSON.stringify(param),
			contentType:"application/json;charset=utf-8",
			dataType:"json",
			async:async,
			success: function(data) {
				successHandler(data, 'restfulPostJson', url, param, successCall, failureCall, async, stop)
			},
			error: function(e) {
				errorHandler(e, 'restfulPostJson', url, param, successCall, failureCall, async, stop)
			}
		});
	};

	$.restfulGet = function(url, param, successCall, failureCall, async=false, stop) {
		$.ajax({
			type : "GET",
			url : url,
			data : param,
			contentType:"application/json;charset=utf-8",
			async : async,
			success: function(data) {
				successHandler(data, 'restfulGet', url, param, successCall, failureCall, async, stop)
			},
			error: function(e) {
				errorHandler(e, 'restfulGet', url, param, successCall, failureCall, async, stop)
			}
		});
	};

	$.restfulPut = function(url, param, successCall, failureCall, async=true, stop) {
		$.ajax({
			url:url,
			type:"PUT",
			data:JSON.stringify(param),
			contentType:"application/json;charset=utf-8",
			dataType:"json",
			async:async,
			success: function(data) {
				successHandler(data, 'restfulPut', url, param, successCall, failureCall, async, stop)
			},
			error: function(e) {
				errorHandler(e, 'restfulPut', url, param, successCall, failureCall, async, stop)
			}
		});
	};

	$.restfulDelete = function(url, param, successCall, failureCall, async=false, stop) {
		$.ajax({
			url:url,
			type:"DELETE",
			data:JSON.stringify(param),
			contentType:"application/json;charset=utf-8",
			dataType:"json",
			async: async,
			success: function(data) {
				successHandler(data, 'restfulDelete', url, param, successCall, failureCall, async, stop)
			},
			error: function(e) {
				errorHandler(e, 'restfulDelete', url, param, successCall, failureCall, async, stop)
			}
		});
	};

	// 检查模块权限
	$.checkModuleRole = function(loginUserId, moduleCode, callback) {
		$.ajax({
			url: '/allincloud/api/s/rolemodules',
			type:"POST",
			data: {
				moduleCode: moduleCode,
				loginUserId: loginUserId
			},
			contentType:"application/x-www-form-urlencoded;charset=UTF-8",
			async:false,
			success: function(data) {
				if (callback) {
					callback(data)
				}
				if (!data.success || data.rows.length == 0) {
					window.location.href = '/allincloud/page/401.html'
				}
			}
		});
	}
	$.checkModuleRoleWithEnv = function(moduleCode, callback) {
		$.ajax({
			type: "get",
			url: '/allincloud/api/s/env/role',
			data: {
				module: moduleCode
			},
			async:false,
			success: function(data) {
				if (callback) {
					callback(data)
				}
				if (!data.success) {
					window.location.href = '/allincloud/page/401.html'
				}
			}
		});
	}

	$.uuid = function() {
		return uuidv4().replace(/-/g, "").toUpperCase();
	}

	// 获取用户 列表与卡片偏好
	$.fetchUserProfile = function() {
		return new Promise((resolve, reject) => {

			let signUserId = $.cookie('signUserId');
			// let profile = $.cookie('userProfile');
			// if (profile) {
			// 	try {
			// 		profile = JSON.parse(profile);
			// 	} catch(e) {
			// 		reject();
			// 	}
			// 	if (!profile.listType) {
			// 		profile.listType = 'list' ; // 默认列表
			// 	}
			// 	resolve(profile)
			// 	return;
			// }
			$.restfulGet('/allincloud/api/s/user/profile/' + signUserId, null, function(data){
				if (data.rows) {
					$.cookie('userProfile', JSON.stringify({ listType: data.rows.listType, menuType: data.rows.menuType, prdOpenType: data.rows.prdOpenType , defaultDisplay : data.rows.defaultDisplay}), { path: '/'});
					resolve(data.rows);
				} else {
					reject();
				}
			}, function(data){ reject(data) }, true);
		});
	}
})(jQuery);


$.ajaxSetup({
	headers: {
		"Authorization": $.cookie('oauth_token')
	},
	statusCode: {401: function() {
			let win = window;
			let pageIdx = location.pathname.indexOf('page');
			let module = $.cookie('module');
			if (module) {
				// 跳转到模块自身登陆页面
				let parent = location.pathname.substring(0, pageIdx);
				parent = parent + 'page/'
				$(win.top.location).attr('href', parent + module +'/login.html');
			} else if(win.top == win) {
				let deep = (location.pathname.substring(pageIdx).split('/') || []).length - 2;
				let parent = '';
				for(let i=1; i <= deep; i++) {
					parent+='../';
				}
				$(win.location).attr('href', parent + 'login.html');
			} else {
				$(win.top.location).attr('href', location.pathname.substring(0, location.pathname.indexOf('page')) + 'login.html');
			}
		}}
});
