(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.Combobox = {
        props: {
            modelValue: String,
            opType: [String, Array],
            placeholder: String,
            disabled: Boolean,
            readonly: Boolean,
            clearable: {
                type: Boolean,
                default: true
            },
        },
        inject: ['DIC'],
        emits: ['update:modelValue', 'change', 'visibleChange'],
        data(){
            return {
                formItem: undefined
            }
        },
        methods: {
            handlerChange(val) {
                this.$emit('change', val)
                const { formItem } = this;
                formItem && formItem.validate();
            },
            handlerVisibleChange(val) {
                this.$emit('visibleChange', val)
            }
        },
        computed:{
            value: {
                get() {
                    return (this.modelValue || '') + ''
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
            options(){
                if (_.isArray(this.opType)) {
                    return this.opType;
                } else {
                    return window[this.opType] || []
                }
            },
            popperOptions() {
                return window.EL_POPPER_OPTIONS
            }
        },
        mounted() {
            this.formItem = vue.inject(ElementPlus.formItemContextKey)
        },
        unmounted() {

        },
        template: `
<el-select v-model="value" class="m-2" :placeholder="placeholder" :popper-options="popperOptions" :clearable="clearable" :disabled="disabled || readonly" 
     @visible-change="handlerVisibleChange"
     @change="handlerChange">
    <el-option
            v-for="item in options"
            :key="item.enname"
            :label="item.cnname"
            :value="item.enname"
    />
</el-select>
        `
        , _designerRule: {
            //插入菜单位置
            menu: 'main',
            //图标
            icon: 'icon-select',
            //名称
            label: '下拉',
            //id,唯一!
            name: 'Combobox',
            //是否可以操作, 除了容器类组件建议为true !
            mask: true,
            //支持组件验证, 值的类型
            validate: ['string'],
            //定义组件的事件
            event: ['change', 'visibleChange'],
            //定义组件的渲染规则
            rule({t}) {
                //组件的生成规则
                return {
                    type: 'Combobox',
                    //field不能重复!!!
                    field: JLUtil.uniqueId(),
                    title: '下拉',
                    info: '',
                    $required: false,
                    props: {},
                };
            },
            //组件的属性配置
            props(_, {t}) {
                return [
                    {
                        type: 'switch',
                        title: '是否禁用',
                        field: 'disabled'
                    },
                    {
                        type: 'switch',
                        title: '是否可清除',
                        field: 'clearable'
                    },
                    {
                        type: 'InputButton',
                        title: '字典配置',
                        field: 'opType',
                        props: {
                            buttonText: "选择",
                            buttonAction: (input, event)=>{
                                if(window.openDictPop) {
                                    window.openDictPop.call(window, input, event)
                                }
                            }
                        }
                    },
                ];
            }
        }
    }
}));
