(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.NavTileMenuItem = {
        props: {

            showIcon: {
                type: Boolean,
                default: false
            },
            data: Array,
            collectList: Array,
        },
        emits: ['select', 'cancelCollect', 'collect'],
        data(){
            return {

            }
        },
        methods: {
            findTargetMenuItem(data, key, keyPath, parents) {
                if (key && key.split('-').length > 0) {
                    const keys = key.split('-');
                    let item = data, i = 0, len = keys.length;
                    while(i < len && item) {
                        item = item[keys[i]];
                        i++;
                        if (i < len) {
                            parents.push(item);
                            item = item.children
                        }
                    }
                    return item;
                } else {
                    return undefined;
                }
            },
            handleSelect(node, key, keyPath) {
                // 点击后 隐藏菜单
                this.data.forEach(el=>el.visible = false) ;
                const parents = []
                if (keyPath && keyPath.length > 0) {
                    let root = this.data[keyPath[0]]
                    if (root) {
                        root.visible = false
                    }
                }
                this.$emit('select', node, key, keyPath, parents)
            },
            cancelCollectMenu(menu, event) {
                event.stopPropagation();
                event.preventDefault();
                this.$emit('cancelCollect', menu);
            },
            collectMenu(menu, event) {
                event.stopPropagation();
                event.preventDefault();
                this.$emit('collect', menu);
            },
            wrapperIndex() {
                let arr = [ ...arguments ].filter(el=>{ return el !== null || el !== undefined })
                return arr.join('-')
            },

            handleNodeIconShow(node) {
                const self = this;
                const { searchMode, defaultIcon, showIcon, mode } = self;
                const hasIcon = !!( node.iconCls || node.icon )
                return showIcon && hasIcon
            },
            genSubItemStyle(index) {
                let deep = (index.split('-') || []).length - 1
                return {
                    //'padding-top': deep > 0 ? 0: undefined,
                    // 'padding-left': deep > 0 ? (deep - 2) * 15: undefined,
                }
            },

        },
        computed:{
            searchMode() {
                const { search } = this;
                return search && search.length > 1
            },
            headerIcon() {
                return this.localCollapse ? 'Expand' : 'Fold'
            },
            defaultIcon() {
                return this.mode === 'horizontal' ? '' : 'icon-yingyong'
            },

        },
        mounted() {
            const self = this;

        },
        unmounted() {
        },
        render() {
            const self = this;
            const { h } = Vue;
            const {  defaultIcon, showIcon } = self;

            function createMenuItemTitle(node, menuKey) {

                let collectFlag = self.collectList.findIndex(el=>el.resourceid === node.resourceid ) >= 0

                return h('span', {
                    class: {
                        'collect-show' : collectFlag,
                        'nav-tile-menu-collect' : !!node.url,
                        'nav-tile-menu-item-url' : !!node.url,
                        'nav-tile-menu-root-mt': menuKey.length == 1  ,
                        'nav-tile-menu-item-parent-title': !node.url || menuKey.length == 1
                    },
                    style: { 'padding-top': 5 }
                }, [
                    node.text,
                    !!node.url ? h('i', {
                        class: [ "iconfont", "icon-pingfen", "collect-icon"],
                        style: { 'color': collectFlag ? 'var(--el-color-warning)' : '#999' },
                        onClick: (event)=>{ collectFlag ? self.cancelCollectMenu(node, event) : self.collectMenu(node, event)  }
                        }) : undefined
                    ]
                )

            }
            function createMenuItem(node, index, parent, pKeyPath) {
                if (node.serachHide) {
                    return undefined;
                }
                if (node.children && node.children.length > 0 && !node.serachHide ) {
                    const menuKey = self.wrapperIndex.apply(self, [...pKeyPath, index])
                    node.menuKey = menuKey
                    return h('div', {
                        class: {'nav-tile-menu-col': true },
                        index: menuKey,
                        key: index,
                    }, [
                        h('div', {
                                class: ['nav-tile-menu-item-title'],
                            },
                            h(ElementPlus.ElIcon, { style: { "display" : self.handleNodeIconShow(node) ? undefined : 'none' }, class: [ 'tree-menu-icon']},
                                node.iconCls && node.iconCls.startsWith('#')
                                    ? h('svg', { class: [ "icon", "svg-icon" ], style: { 'padding-right': '5px', 'font-size': '14px' }}, h('use', { 'xlink:href': node.iconCls }))
                                    : h('i', { class: [ "iconfont",  node.iconCls || node.icon || defaultIcon ]})  ),
                            h('span', {
                                    style: "width: 100%; flex: 1; display: flex; align-items: center; justify-content: space-between;",
                                    onClick: (event)=>{ /*node.stopClickOnLabel && event.stopPropagation();  self.handleSelect(menuKey) ; */ },
                                },
                                createMenuItemTitle(node, menuKey)
                            ),
                        ),
                        h('div', { class: ['nav-tile-menu-item-container'] },
                            node.children.map(function(el, elIdx){
                                return createMenuItem(el, elIdx, node, [...pKeyPath, index])
                            })
                        )
                    ])

                } else {
                    const menuKey = self.wrapperIndex.apply(self, [...pKeyPath, index])
                    node.menuKey = menuKey
                    return h('div', {
                        class: { 'nav-tile-menu-col': true},
                        index: menuKey,
                        key: index,
                        onClick: (event)=> { self.handleSelect(node, menuKey, [...pKeyPath, index]) }
                    }, [
                        h('div', { class: {'nav-tile-menu-item-url' : !!node.url} }, [
                            h(ElementPlus.ElIcon, { style: { "display" : self.handleNodeIconShow(node) ? undefined : 'none' }, class: [ 'tree-menu-icon']},
                                node.iconCls && node.iconCls.startsWith('#')
                                    ? h('svg', { class: [ "icon", "svg-icon" ], style: { 'padding-right': '5px', 'font-size': '14px' }}, h('use', { 'xlink:href': node.iconCls }))
                                    : h('i', { class: [ "iconfont",  node.iconCls || node.icon || defaultIcon ]})
                            ),
                            h('span', {
                                    style: "width: 100%; flex: 1; display: flex; align-items: center; justify-content: space-between;",
                                },
                                createMenuItemTitle(node, menuKey)
                            )
                        ])
                    ])

                }
            }
            return h('div', {
                    class: "nav-tile-menu",
                    ref: 'menuRef'
                }, self.data.map(function(el, index){
                    return createMenuItem(el, index, null, [])
                })
            )
        },
    }
}));
