(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {

    exports.CodeMirrorEditor = {
        props: {
            modelValue: String,
            disabled: Boolean,
            readonly: Boolean,
            width: {
                type: String,
                default: '100%'
            },
            height: {
                type: String,
                default: '450px'
            },
            language: '',
            initBefore: Function,
            initAfter: Function,
            extraKeys: Object,
        },
        emits: ['update:modelValue', 'change'],
        data(){
            return {
                _editor: undefined,
                loading: true,
            }
        },
        watch: {
            disabled(val) {
                if (this.$data._editor) {
                    vue.toRaw(this.$data._editor).doc.cm.setOption('readOnly', val)
                }
            },
            readonly(val) {
                if (this.$data._editor) {
                    vue.toRaw(this.$data._editor).doc.cm.setOption('readOnly', val)
                }
            },
            modelValue(val, oldVal) {
                if (this.$data._editor) {
                    const editor = vue.toRaw(this.$data._editor);
                    const editorVal = editor.getValue();
                    if (editorVal != val) {
                        editor.setValue(val);
                    }

                }
            }
        },
        methods: {
            initEditor() {
                const self = this;
                const $el = self.$el;

                if (self.initBefore) {
                    self.initBefore(CodeMirror)
                }

                self.$data._editor = CodeMirror.fromTextArea($($el).children('textarea')[0], {
                    // value: code,
                    lineNumbers: true,
                    extraKeys: self.extraKeys,
                    readOnly: self.disabled || self.readonly ,
                    mode: {name: self.language , globalVars: true}
                });

                setTimeout(function(){
                    if (self.initAfter) {
                        self.initAfter(self.$data._editor, CodeMirror)
                    }
                    // 绑定事件
                    self.$data._editor.doc.cm.on('change', function(instance, changeObj){
                        self.change();
                    })

                    $(self.$el).find('.CodeMirror').css('height', 'auto');
                    self.loading = false;
                },50)

            },
            change() {
                if (this.$data._editor) {
                    const val = vue.toRaw(this.$data._editor).getValue();
                    this.value = val;
                    this.$emit('change', val)
                }
            },
            getEditor() {
                return vue.toRaw(this.$data._editor);
            }
        },
        computed:{
            value: {
                get() {
                    return this.modelValue
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },

        },
        mounted() {
            const self = this;

            function checkLoad() {
                if (window.CodeMirror) {
                    loadjs([
                        contextPath + "static/js/codemirror/mode/sql.js",
                        contextPath + "static/js/codemirror/mode/freerule.js",
                        contextPath + "static/js/codemirror/addon/hint/show-hint.js",
                        contextPath + "static/js/codemirror/mode/cond.js"
                    ], self.initEditor)
                } else {
                    setTimeout(checkLoad, 250)
                }
            }
            self.loading = true;

            loadjs([
                contextPath + "static/js/codemirror/lib/codemirror.css",
                contextPath + "static/js/codemirror/addon/hint/show-hint.css",
                contextPath + "static/js/codemirror/lib/codemirror.js",
            ], checkLoad)

        },
        unmounted() {

        },
        template: `
<div style="width: 100%;" :style="{ height: height }">
    <textarea  style="border:1px solid #ced4da;" :style="{ width: width, height: height }" :value="value" v-loading="loading"></textarea>
</div>
        `
    }
}));
