/*
 * Decompiled with CFR 0.152.
 */
package feign;

import com.irdstudio.sdk.beans.core.base.BaseService;
import feign.Feign;
import feign.MethodMetadata;
import feign.Request;
import feign.Types;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.openfeign.support.SpringMvcContract;

public class OwnFeignContract
extends SpringMvcContract {
    private static final Log LOG = LogFactory.getLog(OwnFeignContract.class);
    private static final String OTHER_BASE_SERVICE_CLAZZ = "com.irdstudio.framework.beans.core.base.BaseService";

    public MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
        Method superMethod;
        Annotation[] annos = method.getAnnotations();
        if ((annos == null || annos.length == 0) && this.isBaseService(targetType) > 0 && (superMethod = this.getBaseServiceMethod(method)) != null) {
            MethodMetadata data = new MethodMetadata();
            data.targetType(targetType);
            data.method(method);
            data.returnType(Types.resolve(targetType, targetType, (Type)method.getGenericReturnType()));
            data.configKey(Feign.configKey(targetType, (Method)method));
            data.template().method(Request.HttpMethod.POST);
            String serviceName = targetType.getSimpleName();
            String methodName = method.getName();
            String path = String.format("/%s/%s/%s", "_client".replace("_", ""), serviceName, methodName);
            data.template().uri(path, true);
            data.template().header("Content-Type", new String[]{"application/json;charset=UTF-8"});
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            int count = parameterAnnotations.length;
            for (int i = 0; i < count; ++i) {
                boolean isHttpAnnotation = false;
                if (parameterAnnotations[i] != null) {
                    isHttpAnnotation = this.processAnnotationsOnParameter(data, parameterAnnotations[i], i);
                }
                if (isHttpAnnotation) {
                    data.ignoreParamater(i);
                }
                if (parameterTypes[i] == URI.class) {
                    data.urlIndex(Integer.valueOf(i));
                    continue;
                }
                if (isHttpAnnotation || parameterTypes[i] == Request.Options.class) continue;
                if (data.isAlreadyProcessed(Integer.valueOf(i))) {
                    Util.checkState((data.formParams().isEmpty() || data.bodyIndex() == null ? 1 : 0) != 0, (String)"Body parameters cannot be used with form parameters.%s", (Object[])new Object[]{data.warnings()});
                    continue;
                }
                Util.checkState((boolean)data.formParams().isEmpty(), (String)"Body parameters cannot be used with form parameters.%s", (Object[])new Object[]{data.warnings()});
                Util.checkState((data.bodyIndex() == null ? 1 : 0) != 0, (String)"Method has too many Body parameters: %s%s", (Object[])new Object[]{method, data.warnings()});
                data.bodyIndex(Integer.valueOf(i));
                data.bodyType(Types.resolve(targetType, targetType, (Type)genericParameterTypes[i]));
            }
            return data;
        }
        if (annos == null || annos.length == 0) {
            MethodMetadata data = new MethodMetadata();
            data.targetType(targetType);
            data.method(method);
            data.returnType(Types.resolve(targetType, targetType, (Type)method.getGenericReturnType()));
            data.configKey(Feign.configKey(targetType, (Method)method));
            data.ignoreMethod();
            return data;
        }
        return super.parseAndValidateMetadata(targetType, method);
    }

    private int isBaseService(Class<?> targetType) {
        if (StringUtils.equals((CharSequence)targetType.getName(), (CharSequence)BaseService.class.getName())) {
            return 1;
        }
        if (StringUtils.equals((CharSequence)targetType.getName(), (CharSequence)OTHER_BASE_SERVICE_CLAZZ)) {
            return 2;
        }
        Class<?>[] interfaces = targetType.getInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            int flag = -1;
            for (Class<?> intef : interfaces) {
                if (StringUtils.equals((CharSequence)intef.getName(), (CharSequence)BaseService.class.getName())) {
                    flag = 1;
                    break;
                }
                if (!StringUtils.equals((CharSequence)intef.getName(), (CharSequence)OTHER_BASE_SERVICE_CLAZZ)) continue;
                flag = 2;
                break;
            }
            return flag;
        }
        return -1;
    }

    private Method getBaseServiceMethod(Method method) {
        Method superMethod = null;
        try {
            if (this.isBaseService(method.getDeclaringClass()) == 1) {
                superMethod = BaseService.class.getMethod(method.getName(), method.getParameterTypes());
            } else if (this.isBaseService(method.getDeclaringClass()) == 2) {
                Class<?> otherBaseServiceClazz = Class.forName(OTHER_BASE_SERVICE_CLAZZ);
                superMethod = otherBaseServiceClazz.getMethod(method.getName(), method.getParameterTypes());
            }
        }
        catch (Exception e) {
            try {
                if (this.isBaseService(method.getDeclaringClass()) == 1) {
                    superMethod = BaseService.class.getMethod(method.getName(), Object.class);
                } else if (this.isBaseService(method.getDeclaringClass()) == 2) {
                    Class<?> otherBaseServiceClazz = Class.forName(OTHER_BASE_SERVICE_CLAZZ);
                    superMethod = otherBaseServiceClazz.getMethod(method.getName(), Object.class);
                }
            }
            catch (Exception e1) {
                LOG.debug((Object)("\u4e0d\u662fBaseService\u7684\u65b9\u6cd5 " + method.getName()));
            }
        }
        return superMethod;
    }
}

